/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import cofh.api.energy.IEnergyContainerItem;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.util.RenderUtils;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.integration.ModType;
import tonius.simplyjetpacks.item.IControllableArmor;
import tonius.simplyjetpacks.item.IHUDInfoProvider;
import tonius.simplyjetpacks.item.meta.FluxPack;
import tonius.simplyjetpacks.item.meta.Jetpack;
import tonius.simplyjetpacks.item.meta.PackBase;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModCreativeTab;
import tonius.simplyjetpacks.setup.ModEnchantments;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;
import tonius.simplyjetpacks.util.math.MathHelper;

public class ItemPack<T extends PackBase>
extends ItemArmor
implements IControllableArmor,
ISpecialArmor,
IEnergyContainerItem,
IFluidContainerItem,
IHUDInfoProvider {
    private static final String TAG_ENERGY = "Energy";
    private static final String TAG_FLUID = "Fluid";
    public final ModType modType;
    private final Map<Integer, T> packs = new LinkedHashMap<Integer, T>();
    protected String name;

    public ItemPack(ModType modType, String registryName) {
        super(ItemArmor.ArmorMaterial.IRON, 2, EntityEquipmentSlot.CHEST);
        this.name = registryName;
        this.modType = modType;
        this.func_77655_b("simplyjetpacks.pack" + modType.suffix);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(ModCreativeTab.instance);
        this.setRegistryName(registryName);
    }

    public ItemStack putPack(int meta, T pack, boolean returnFull) {
        this.packs.put(meta, pack);
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        if (returnFull) {
            this.addFuel(stack, this.getMaxFuelStored(stack), false);
        }
        return stack;
    }

    public ItemStack putPack(int meta, T pack) {
        return this.putPack(meta, pack, false);
    }

    public T getPack(ItemStack stack) {
        return (T)((PackBase)this.packs.get(stack.func_77952_i()));
    }

    public Collection<T> getPacks() {
        return this.packs.values();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        T pack = this.getPack(stack);
        if (pack != null && entity instanceof EntityPlayer) {
            ((PackBase)pack).tickInventory(world, (EntityPlayer)entity, stack, this);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).tickArmor(world, player, stack, this);
        }
    }

    public String func_77667_c(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return "item.simplyjetpacks." + ((PackBase)pack).getBaseName(true) + this.modType.suffix;
        }
        return super.func_77658_a();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).rarity;
        }
        return super.func_77613_e(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).hasFuelIndicator;
        }
        return super.showDurabilityBar(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double stored = this.getMaxFuelStored(stack) - this.getFuelStored(stack) + 1;
        double max = this.getMaxFuelStored(stack) + 1;
        return stored / max;
    }

    public int getItemEnchantability(ItemStack stack) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).enchantability;
        }
        return super.getItemEnchantability(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.func_77619_b() > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.func_77619_b() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        T pack = this.getPack(stack);
        if (pack != null) {
            ((PackBase)pack).addInformation(stack, this, player, list);
            if (SJStringHelper.canShowDetails()) {
                ((PackBase)pack).addShiftInformation(stack, this, player, list);
            } else {
                list.add(SJStringHelper.getShiftText());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (Map.Entry<Integer, T> e : this.packs.entrySet()) {
            ((PackBase)e.getValue()).addSubItems(this, e.getKey(), list);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        T pack = this.getPack(stack);
        if (pack != null) {
            return ((PackBase)pack).getArmorTexture(stack, entity, slot, this.modType);
        }
        return super.getArmorTexture(stack, entity, slot, type);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack stack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ModelBiped model;
        T pack = this.getPack(stack);
        if (pack != null && ((PackBase)pack).armorModel != null && Config.enableArmor3DModels && (model = RenderUtils.getArmorModel(pack, entityLiving)) != null) {
            return model;
        }
        return super.getArmorModel(entityLiving, stack, armorSlot, _default);
    }

    @Override
    public void onKeyPressed(ItemStack stack, EntityPlayer player, ModKey key, boolean showInChat) {
        T pack = this.getPack(stack);
        if (pack != null) {
            switch (key) {
                case TOGGLE_PRIMARY: {
                    ((PackBase)pack).togglePrimary(stack, player, showInChat);
                    break;
                }
                case TOGGLE_SECONDARY: {
                    ((PackBase)pack).toggleSecondary(stack, player, showInChat);
                    break;
                }
                case MODE_PRIMARY: {
                    ((PackBase)pack).switchModePrimary(stack, player, showInChat);
                    break;
                }
                case MODE_SECONDARY: {
                    ((PackBase)pack).switchModeSecondary(stack, player, showInChat);
                    break;
                }
            }
        }
    }

    protected int getFuelPerDamage(ItemStack stack, T pack) {
        if (ModEnchantments.fuelEffeciency == null) {
            return ((PackBase)pack).armorFuelPerHit;
        }
        int fuelEfficiencyLevel = MathHelper.clampI(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.fuelEffeciency, (ItemStack)stack), 0, 4);
        return (int)Math.round((double)(((PackBase)pack).armorFuelPerHit * (5 - fuelEfficiencyLevel)) / 5.0);
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && !source.func_76363_c()) {
            if (((PackBase)pack).isFluxBased && source.field_76373_n.equals("flux")) {
                return new ISpecialArmor.ArmorProperties(0, 0.5, Integer.MAX_VALUE);
            }
            int energyPerDamage = this.getFuelPerDamage(armor, pack);
            int maxAbsorbed = energyPerDamage > 0 ? 25 * (this.getFuelStored(armor) / energyPerDamage) : 0;
            return new ISpecialArmor.ArmorProperties(0, 0.85 * ((double)((PackBase)pack).armorReduction / 20.0), maxAbsorbed);
        }
        return new ISpecialArmor.ArmorProperties(0, 1.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && this.getFuelStored(armor) >= ((PackBase)pack).armorFuelPerHit) {
            return ((PackBase)pack).armorReduction;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        T pack = this.getPack(armor);
        if (pack != null && ((PackBase)pack).isArmored && ((PackBase)pack).usesFuel) {
            if (((PackBase)pack).fuelType == FuelType.ENERGY && ((PackBase)pack).isFluxBased && source.field_76373_n.equals("flux")) {
                this.addFuel(armor, damage * (source.func_76346_g() == null ? ((PackBase)pack).armorFuelPerHit / 2 : this.getFuelPerDamage(armor, pack)), false);
            } else {
                this.useFuel(armor, damage * this.getFuelPerDamage(armor, pack), false);
            }
        }
    }

    public int getFuelStored(ItemStack stack) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                return this.getEnergyStored(stack);
            }
            case FLUID: 
        }
        FluidStack stored = this.getFluid(stack);
        return stored != null ? stored.amount : 0;
    }

    public int getMaxFuelStored(ItemStack stack) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                return this.getMaxEnergyStored(stack);
            }
            case FLUID: 
        }
        return this.getCapacity(stack);
    }

    public int addFuel(ItemStack stack, int maxAdd, boolean simulate) {
        T pack = this.getPack(stack);
        if (pack == null) {
            return 0;
        }
        switch (((PackBase)pack).fuelType) {
            default: {
                int energy = this.getEnergyStored(stack);
                int energyReceived = Math.min(this.getMaxEnergyStored(stack) - energy, maxAdd);
                if (!simulate) {
                    NBTHelper.setInt(stack, TAG_ENERGY, energy += energyReceived);
                }
                return energyReceived;
            }
            case FLUID: 
        }
        if (((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidReceived = Math.min(this.getCapacity(stack) - amount, maxAdd);
        if (!simulate) {
            NBTHelper.setInt(stack, TAG_FLUID, amount += fluidReceived);
        }
        return fluidReceived;
    }

    public int useFuel(ItemStack stack, int maxUse, boolean simulate) {
        T pack = this.getPack(stack);
        switch (((PackBase)pack).fuelType) {
            default: {
                int energy = this.getEnergyStored(stack);
                int energyExtracted = Math.min(energy, maxUse);
                if (!simulate) {
                    NBTHelper.setInt(stack, TAG_ENERGY, energy -= energyExtracted);
                }
                return energyExtracted;
            }
            case FLUID: 
        }
        if (((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        FluidStack fluid = this.getFluid(stack);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidExtracted = Math.min(amount, maxUse);
        if (!simulate) {
            NBTHelper.setInt(stack, TAG_FLUID, amount -= fluidExtracted);
        }
        return fluidExtracted;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(maxReceive, ((PackBase)pack).fuelPerTickIn));
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        int energy = this.getEnergyStored(container);
        int energyExtracted = Math.min(energy, Math.min(maxExtract, ((PackBase)pack).fuelPerTickOut));
        if (!simulate) {
            NBTHelper.setInt(container, TAG_ENERGY, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        return NBTHelper.getInt(container, TAG_ENERGY);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.ENERGY) {
            return 0;
        }
        return ((PackBase)pack).fuelCapacity;
    }

    public FluidStack getFluid(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return null;
        }
        int amount = NBTHelper.getInt(container, TAG_FLUID);
        return amount > 0 ? new FluidStack(FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid), amount) : null;
    }

    public int getCapacity(ItemStack container) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return 0;
        }
        return ((PackBase)pack).fuelCapacity;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null || resource.getFluid() != FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid)) {
            return 0;
        }
        FluidStack fluid = this.getFluid(container);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidReceived = Math.min(this.getCapacity(container) - amount, Math.min(resource.amount, ((PackBase)pack).fuelPerTickIn));
        if (doFill) {
            NBTHelper.setInt(container, TAG_FLUID, amount += fluidReceived);
        }
        return fluidReceived;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        T pack = this.getPack(container);
        if (pack == null || ((PackBase)pack).fuelType != FuelType.FLUID || ((PackBase)pack).fuelFluid == null) {
            return null;
        }
        FluidStack fluid = this.getFluid(container);
        int amount = fluid != null ? fluid.amount : 0;
        int fluidExtracted = Math.min(amount, Math.min(maxDrain, ((PackBase)pack).fuelPerTickOut));
        if (doDrain) {
            NBTHelper.setInt(container, TAG_FLUID, amount -= fluidExtracted);
        }
        return fluidExtracted > 0 ? new FluidStack(FluidRegistry.getFluid((String)((PackBase)pack).fuelFluid), fluidExtracted) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHUDInfo(List<String> list, ItemStack stack, boolean showFuel, boolean showState) {
        T pack = this.getPack(stack);
        if (pack != null) {
            if (showFuel && ((PackBase)pack).hasFuelIndicator) {
                list.add(((PackBase)pack).getHUDFuelInfo(stack, this));
            }
            if (showState && ((PackBase)pack).hasStateIndicators) {
                list.add(((PackBase)pack).getHUDStatesInfo(stack, this));
            }
        }
    }

    public void registerItemModel() {
        SimplyJetpacks.proxy.registerItemRenderer((Item)this, 0, this.name);
    }

    public static class ItemFluxPack
    extends ItemPack<FluxPack> {
        public ItemFluxPack(ModType modType, String registryName) {
            super(modType, registryName);
        }
    }

    public static class ItemJetpack
    extends ItemPack<Jetpack> {
        public ItemJetpack(ModType modType, String registryName) {
            super(modType, registryName);
        }
    }
}

