/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public enum ChestChangerType {
    IRONGOLD(IronChestType.IRON, IronChestType.GOLD, "ironGoldUpgrade", "mmm", "msm", "mmm"),
    GOLDDIAMOND(IronChestType.GOLD, IronChestType.DIAMOND, "goldDiamondUpgrade", "GGG", "msm", "GGG"),
    COPPERSILVER(IronChestType.COPPER, IronChestType.SILVER, "copperSilverUpgrade", "mmm", "msm", "mmm"),
    SILVERGOLD(IronChestType.SILVER, IronChestType.GOLD, "silverGoldUpgrade", "mGm", "GsG", "mGm"),
    COPPERIRON(IronChestType.COPPER, IronChestType.IRON, "copperIronUpgrade", "mGm", "GsG", "mGm"),
    DIAMONDCRYSTAL(IronChestType.DIAMOND, IronChestType.CRYSTAL, "diamondCrystalUpgrade", "GGG", "GOG", "GGG"),
    WOODIRON(IronChestType.WOOD, IronChestType.IRON, "woodIronUpgrade", "mmm", "msm", "mmm"),
    WOODCOPPER(IronChestType.WOOD, IronChestType.COPPER, "woodCopperUpgrade", "mmm", "msm", "mmm"),
    DIAMONDOBSIDIAN(IronChestType.DIAMOND, IronChestType.OBSIDIAN, "diamondObsidianUpgrade", "mmm", "mGm", "mmm");

    public static final ChestChangerType[] VALUES;
    public final IronChestType source;
    public final IronChestType target;
    public final String itemName;
    public ItemChestChanger item;
    private String[] recipe;

    private ChestChangerType(IronChestType source, IronChestType target, String itemName, String ... recipe) {
        this.source = source;
        this.target = target;
        this.itemName = itemName;
        this.recipe = recipe;
    }

    public boolean canUpgrade(IronChestType from) {
        return from == this.source;
    }

    public ItemChestChanger buildItem() {
        this.item = new ItemChestChanger(this);
        this.item.setRegistryName(this.itemName);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public void addRecipes() {
        for (String sourceMat : this.source.matList) {
            for (String targetMat : this.target.matList) {
                Object targetMaterial = IronChestType.translateOreName(targetMat);
                Object sourceMaterial = IronChestType.translateOreName(sourceMat);
                IronChestType.addRecipe(new ItemStack((Item)this.item), this.recipe, Character.valueOf('m'), targetMaterial, Character.valueOf('s'), sourceMaterial, Character.valueOf('G'), "blockGlass", Character.valueOf('O'), Blocks.field_150343_Z);
            }
        }
    }

    public static void buildItems() {
        for (ChestChangerType type : VALUES) {
            type.buildItem();
        }
    }

    public static void generateRecipes() {
        for (ChestChangerType item : VALUES) {
            item.addRecipes();
        }
    }

    static {
        VALUES = ChestChangerType.values();
    }
}

