/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.recipe.BasicMachineRecipeManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import wanion.lib.common.FixedSizeList;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class IC2Integration
extends AbstractIntegrationThread {
    private final List<Map<IRecipeInput, RecipeOutput>> ic2MachinesRecipeList = new FixedSizeList(5);

    IC2Integration() {
        super("Industrial Craft 2");
        try {
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.centrifuge, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.compressor, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.blastfurnace, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.macerator, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.metalformerCutting, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.metalformerExtruding, Map.class));
            this.ic2MachinesRecipeList.add((Map<IRecipeInput, RecipeOutput>)Util.getField(BasicMachineRecipeManager.class, (String)"recipes", (Object)Recipes.metalformerRolling, Map.class));
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
    }

    public String call() {
        this.ic2MachinesRecipeList.forEach(map -> {
            try {
                this.fixMachinesOutputs((Map<IRecipeInput, RecipeOutput>)map);
            }
            catch (Exception e) {
                UniDict.getLogger().error(this.threadName + e);
            }
        });
        return this.threadName + "The world appears to be entirely industrialized.";
    }

    private void fixMachinesOutputs(Map<IRecipeInput, RecipeOutput> recipes) {
        if (!this.config.inputReplacementIC2) {
            for (Map.Entry<IRecipeInput, RecipeOutput> recipe : recipes.entrySet()) {
                recipe.setValue(new RecipeOutput(recipe.getValue().metadata, this.resourceHandler.getMainItemStacks(recipe.getValue().items)));
            }
        } else {
            HashMap<RecipeInputItemStack, RecipeOutput> newRecipes = new HashMap<RecipeInputItemStack, RecipeOutput>();
            Iterator<Map.Entry<IRecipeInput, RecipeOutput>> recipesIterator = recipes.entrySet().iterator();
            while (recipesIterator.hasNext()) {
                Map.Entry<IRecipeInput, RecipeOutput> recipe = recipesIterator.next();
                IRecipeInput recipeInput = recipe.getKey();
                RecipeOutput recipeOutput = recipe.getValue();
                if (recipeInput instanceof RecipeInputItemStack) {
                    newRecipes.put(new RecipeInputItemStack(this.resourceHandler.getMainItemStack(((RecipeInputItemStack)recipeInput).input), ((RecipeInputItemStack)recipeInput).amount), new RecipeOutput(recipe.getValue().metadata, this.resourceHandler.getMainItemStacks(recipeOutput.items)));
                    recipesIterator.remove();
                    continue;
                }
                recipe.setValue(new RecipeOutput(recipeOutput.metadata, this.resourceHandler.getMainItemStacks(recipeOutput.items)));
            }
            recipes.putAll(newRecipes);
        }
    }
}

