/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.variations.vanilla.behaviour;

import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.behaviour.BehaviourBase;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import java.util.function.Supplier;
import net.minecraft.block.BlockNote;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NoteBlockBehaviour
extends BehaviourBase<NoteBlockBehaviour> {
    private final World world;
    private final IChiseledSheepCapability capability;
    private boolean isTriggered = false;
    private BlockPos currentLocation = null;

    public NoteBlockBehaviour(EntitySheep entity, Supplier<Boolean> configuration) {
        super(entity, configuration);
        this.world = entity.func_130014_f_();
        this.capability = (IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null);
    }

    @Override
    public void onBehaviourStarted(BlockPos currentPos) {
        this.currentLocation = currentPos;
    }

    @Override
    public void onSheepMovedBlock(BlockPos previousLocation, BlockPos newLocation) {
        this.isTriggered = false;
        this.currentLocation = newLocation;
    }

    @Override
    public void updateTask() {
        boolean powered = this.world.func_175640_z(this.currentLocation);
        if (powered && !this.isTriggered) {
            NoteBlockBehaviour.triggerNoteBlock(this.world, this.currentLocation, this.capability);
        }
        this.isTriggered = powered;
    }

    public static void tuneNoteBlockSheep(EntitySheep sheep) {
        IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
        World world = sheep.func_130014_f_();
        NBTTagCompound extraData = capability.getExtraData();
        byte note = NoteBlockBehaviour.getTuning(extraData);
        note = (byte)((note + 1) % 25);
        extraData.func_74774_a("NOTEBLOCK_TUNING", note);
        NoteBlockBehaviour.triggerNoteBlock(world, sheep.func_180425_c(), capability);
    }

    public static byte getTuning(NBTTagCompound extraData) {
        return extraData.func_74764_b("NOTEBLOCK_TUNING") ? extraData.func_74771_c("NOTEBLOCK_TUNING") : (byte)12;
    }

    public static void triggerNoteBlock(World world, BlockPos currentLocation, IChiseledSheepCapability capability) {
        NBTTagCompound extraData;
        int param;
        NoteBlockEvent.Play e;
        IBlockState blockState = world.func_180495_p(currentLocation);
        IBlockState blockStateBeneath = world.func_180495_p(currentLocation.func_177977_b());
        Material material = blockStateBeneath.func_185904_a();
        int id = 0;
        if (material == Material.field_151576_e) {
            id = 1;
        }
        if (material == Material.field_151595_p) {
            id = 2;
        }
        if (material == Material.field_151592_s) {
            id = 3;
        }
        if (material == Material.field_151575_d) {
            id = 4;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(e = new NoteBlockEvent.Play(world, currentLocation, blockState, param = NoteBlockBehaviour.getTuning(extraData = capability.getExtraData()), id)))) {
            id = e.getInstrument().ordinal();
            if (blockStateBeneath.func_177230_c() == Blocks.field_150325_L) {
                id = -1;
            }
            param = e.getVanillaNoteId();
            float f = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
            world.func_184133_a(null, currentLocation, NoteBlockBehaviour.getInstrument(id), SoundCategory.RECORDS, 3.0f, f);
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                worldserver.func_180505_a(EnumParticleTypes.NOTE, true, (double)currentLocation.func_177958_n() + 0.5, (double)currentLocation.func_177956_o() + 1.2, (double)currentLocation.func_177952_p() + 0.5, 0, (double)param / 24.0, 0.0, 0.0, 1.0, new int[0]);
            }
        }
    }

    private static SoundEvent getInstrument(int id) {
        if (id == -1) {
            return SoundEvents.field_187757_eG;
        }
        if (id < 0 || id >= BlockNote.field_176434_a.size()) {
            id = 0;
        }
        return (SoundEvent)BlockNote.field_176434_a.get(id);
    }

    @Override
    public boolean isEquivalentTo(NoteBlockBehaviour other) {
        return super.isEquivalentTo(other);
    }
}

