/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.proxy;

import com.github.atomicblom.shearmadness.Chiseling;
import com.github.atomicblom.shearmadness.Shearing;
import com.github.atomicblom.shearmadness.ai.SheepBehaviourAI;
import com.github.atomicblom.shearmadness.api.BehaviourRegistry;
import com.github.atomicblom.shearmadness.api.Capability;
import com.github.atomicblom.shearmadness.api.ItemStackHelper;
import com.github.atomicblom.shearmadness.api.capability.IChiseledSheepCapability;
import com.github.atomicblom.shearmadness.api.events.RegisterShearMadnessBehaviourEvent;
import com.github.atomicblom.shearmadness.api.events.ShearMadnessSheepKilledEvent;
import com.github.atomicblom.shearmadness.api.events.ShearMadnessSpecialInteractionEvent;
import com.github.atomicblom.shearmadness.capability.CapabilityProvider;
import com.github.atomicblom.shearmadness.utility.ChiselLibrary;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommonForgeEventProxy {
    public void fireRegistryEvent() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterShearMadnessBehaviourEvent(BehaviourRegistry.INSTANCE));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerInteractionWithEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!(event.getTarget() instanceof EntitySheep)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack == null) {
            this.checkSpecialSheepInteraction(event);
            return;
        }
        if (!(itemStack.func_77973_b() instanceof ItemShears)) {
            return;
        }
        EntitySheep sheep = (EntitySheep)event.getTarget();
        if (!sheep.isShearable(itemStack, (IBlockAccess)event.getWorld(), event.getPos())) {
            return;
        }
        IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
        if (capability == null) {
            return;
        }
        if (!capability.isChiseled()) {
            return;
        }
        event.setCanceled(true);
        Shearing.shearSheep(itemStack, sheep, capability);
    }

    private void checkSpecialSheepInteraction(PlayerInteractEvent.EntityInteract event) {
        EntitySheep sheep = (EntitySheep)event.getTarget();
        IChiseledSheepCapability capability = (IChiseledSheepCapability)sheep.getCapability(Capability.CHISELED_SHEEP, null);
        if (capability == null) {
            return;
        }
        if (!capability.isChiseled()) {
            return;
        }
        EntityPlayer entityPlayer = event.getEntityPlayer();
        MinecraftForge.EVENT_BUS.post((Event)new ShearMadnessSpecialInteractionEvent(event.getWorld(), entityPlayer, sheep, capability));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttack(AttackEntityEvent event) {
        Entity sheep = event.getTarget();
        if (sheep == null) {
            return;
        }
        EntityPlayer entityPlayer = event.getEntityPlayer();
        ItemStack activeStack = entityPlayer.field_71071_by.func_70448_g();
        boolean attackedWithChisel = false;
        if (activeStack != null && ChiselLibrary.isChisel(activeStack.func_77973_b())) {
            attackedWithChisel = true;
        } else {
            activeStack = entityPlayer.field_71071_by.field_184439_c[0];
            if (activeStack != null && ChiselLibrary.isChisel(activeStack.func_77973_b())) {
                attackedWithChisel = true;
            }
        }
        if (!attackedWithChisel) {
            return;
        }
        if (!sheep.hasCapability(Capability.CHISELED_SHEEP, null)) {
            return;
        }
        event.setCanceled(true);
        Chiseling.chiselSheep(sheep, entityPlayer, activeStack);
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        IChiseledSheepCapability capability;
        Entity entity = event.getEntity();
        if (entity.hasCapability(Capability.CHISELED_SHEEP, null) && (capability = (IChiseledSheepCapability)entity.getCapability(Capability.CHISELED_SHEEP, null)).isChiseled()) {
            List drops = event.getDrops();
            ItemStack chiselItemStack = capability.getChiselItemStack();
            Item chiselItem = chiselItemStack.func_77973_b();
            drops.removeIf(entityItem -> ItemStackHelper.isStackForBlock(entityItem.func_92059_d(), Blocks.field_150325_L));
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, chiselItemStack.func_77946_l()));
            MinecraftForge.EVENT_BUS.post((Event)new ShearMadnessSheepKilledEvent(drops, event.getSource(), event.getLootingLevel(), chiselItemStack, entity));
        }
    }

    @SubscribeEvent
    public void onCapabilityAttaching(AttachCapabilitiesEvent<Entity> event) {
        if (((Entity)event.getObject()).getClass().equals(EntitySheep.class)) {
            event.addCapability(new ResourceLocation("shearmadness", "chiseledSheep"), (ICapabilityProvider)new CapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onCommonEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLiving && entity.hasCapability(Capability.CHISELED_SHEEP, null)) {
            EntityLiving livingEntity = (EntityLiving)event.getEntity();
            EntityAITasks tasks = livingEntity.field_70714_bg;
            tasks.func_75776_a(0, (EntityAIBase)new SheepBehaviourAI(livingEntity));
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeathEvent(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLiving && entity.hasCapability(Capability.CHISELED_SHEEP, null)) {
            EntityLiving livingEntity = (EntityLiving)entity;
            livingEntity.field_70714_bg.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a instanceof SheepBehaviourAI).forEach(taskEntry -> ((SheepBehaviourAI)taskEntry.field_75733_a).onDeath());
        }
    }
}

