/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpawnCustomParticleMessage
implements IMessage {
    private ResourceLocation particleResourceLocation;
    private float xCoord;
    private float yCoord;
    private float zCoord;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    private float particleSpeed;
    private int particleCount;
    private boolean longDistance;
    private int[] particleArguments;

    public SpawnCustomParticleMessage() {
    }

    public SpawnCustomParticleMessage(ResourceLocation particleResourceLocation, boolean longDistanceIn, float xIn, float yIn, float zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn, int ... argumentsIn) {
        this.particleResourceLocation = particleResourceLocation;
        this.longDistance = longDistanceIn;
        this.xCoord = xIn;
        this.yCoord = yIn;
        this.zCoord = zIn;
        this.xOffset = xOffsetIn;
        this.yOffset = yOffsetIn;
        this.zOffset = zOffsetIn;
        this.particleSpeed = speedIn;
        this.particleCount = countIn;
        this.particleArguments = argumentsIn;
    }

    public void fromBytes(ByteBuf byteBuf) {
        PacketBuffer buf = new PacketBuffer(byteBuf);
        this.particleResourceLocation = new ResourceLocation(buf.func_150789_c(255));
        this.longDistance = buf.readBoolean();
        this.xCoord = buf.readFloat();
        this.yCoord = buf.readFloat();
        this.zCoord = buf.readFloat();
        this.xOffset = buf.readFloat();
        this.yOffset = buf.readFloat();
        this.zOffset = buf.readFloat();
        this.particleSpeed = buf.readFloat();
        this.particleCount = buf.readInt();
        int argumentCount = buf.readInt();
        this.particleArguments = new int[argumentCount];
        for (int j = 0; j < argumentCount; ++j) {
            this.particleArguments[j] = buf.func_150792_a();
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        PacketBuffer buf = new PacketBuffer(byteBuf);
        buf.func_180714_a(this.particleResourceLocation.toString());
        buf.writeBoolean(this.longDistance);
        buf.writeFloat(this.xCoord);
        buf.writeFloat(this.yCoord);
        buf.writeFloat(this.zCoord);
        buf.writeFloat(this.xOffset);
        buf.writeFloat(this.yOffset);
        buf.writeFloat(this.zOffset);
        buf.writeFloat(this.particleSpeed);
        buf.writeInt(this.particleCount);
        buf.writeInt(this.particleArguments.length);
        for (int j = 0; j < this.particleArguments.length; ++j) {
            buf.func_150787_b(this.particleArguments[j]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getParticleResourceLocation() {
        return this.particleResourceLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLongDistance() {
        return this.longDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public double getXCoordinate() {
        return this.xCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getYCoordinate() {
        return this.yCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZCoordinate() {
        return this.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXOffset() {
        return this.xOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getYOffset() {
        return this.yOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getZOffset() {
        return this.zOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getParticleSpeed() {
        return this.particleSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public int getParticleCount() {
        return this.particleCount;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getParticleArgs() {
        return this.particleArguments;
    }
}

