/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.configuration;

import com.github.atomicblom.shearmadness.configuration.BreedingBehaviour;
import com.github.atomicblom.shearmadness.configuration.ShearBehaviour;
import net.minecraftforge.common.config.Configuration;

public enum Settings {
    INSTANCE;

    public static final String CATEGORY = "general";
    private boolean debugModels = false;
    private boolean debugInvisibleBlocks = false;
    public static final String IS_CI_BUILD = "false";

    public static boolean isReleaseBuild() {
        return Boolean.parseBoolean(IS_CI_BUILD);
    }

    public static boolean debugModels() {
        return Settings.INSTANCE.debugModels;
    }

    public static boolean debugInvisibleBlocks() {
        return Settings.INSTANCE.debugInvisibleBlocks;
    }

    public static void syncConfig(Configuration config) {
        Settings.INSTANCE.debugModels = config.getBoolean("debugModels", CATEGORY, false, "Models will be regenerated every frame drawn.");
        Settings.INSTANCE.debugInvisibleBlocks = config.getBoolean("debugInvisibleBlocks", CATEGORY, false, "Invisible Blocks will be shown in-game.");
        Shearing.syncConfig(config);
        Behaviours.syncConfig(config);
    }

    public static enum Behaviours {
        INSTANCE;

        public static final String CATEGORY = "general.behaviours";
        private boolean allowGlowstone = false;
        private boolean allowRedstone = true;
        private boolean allowBookshelf = true;
        private boolean allowCactus = true;
        private boolean allowTNT = true;
        private boolean allowFireDamage = true;
        private boolean allowAutoCrafting = true;
        private BreedingBehaviour breedingBehaviour = BreedingBehaviour.Unchiseled;

        public static boolean allowRedstone() {
            return Behaviours.INSTANCE.allowRedstone;
        }

        public static boolean allowBookshelf() {
            return Behaviours.INSTANCE.allowBookshelf;
        }

        public static boolean allowGlowstone() {
            return Behaviours.INSTANCE.allowGlowstone;
        }

        public static boolean allowCactus() {
            return Behaviours.INSTANCE.allowCactus;
        }

        public static boolean allowTNT() {
            return Behaviours.INSTANCE.allowTNT;
        }

        public static boolean allowFireDamage() {
            return Behaviours.INSTANCE.allowFireDamage;
        }

        public static boolean allowAutoCrafting() {
            return Behaviours.INSTANCE.allowAutoCrafting;
        }

        public static BreedingBehaviour getBreedingBehaviour() {
            return Behaviours.INSTANCE.breedingBehaviour;
        }

        private static void syncConfig(Configuration config) {
            Behaviours.INSTANCE.allowRedstone = config.getBoolean("allowRedstone", CATEGORY, true, "Chiseled redstone sheep will trigger Redstone circuits.");
            Behaviours.INSTANCE.allowBookshelf = config.getBoolean("allowBookshelf", CATEGORY, true, "Chiseled bookshelf sheep will affect enchanting tables.");
            Behaviours.INSTANCE.allowGlowstone = config.getBoolean("allowGlowstone", CATEGORY, false, "Chiseled glowstone sheep will light up the area around them.\nWARNING: testing shows this creates a lot of chunk recalculation. I do not recommend this option.");
            Behaviours.INSTANCE.allowCactus = config.getBoolean("allowCactus", CATEGORY, true, "Chiseled Cactus sheep will deal damage players and destroy items.");
            Behaviours.INSTANCE.allowTNT = config.getBoolean("allowTNT", CATEGORY, true, "Chiseled TNT Sheep will be explode if exposed to active redstone.");
            Behaviours.INSTANCE.allowFireDamage = config.getBoolean("allowFireDamage", CATEGORY, true, "Chiseled Magma sheep will deal fire damage when touched.");
            Behaviours.INSTANCE.allowAutoCrafting = config.getBoolean("allowAutoCrafting", CATEGORY, true, "Crafting Table sheep will use their recipe to consume and produce items.");
            String breedingBehaviourText = config.getString("breedingBehaviour", CATEGORY, BreedingBehaviour.Unchiseled.name(), "Sets the behaviour of when two sheep breed\n* Unchiseled     - Baby sheep will be born without the parent's block (default)\n* SimpleBreeding - Baby sheep will have a 50% chance of being chiseled the same as one parent or the other");
            Behaviours.INSTANCE.breedingBehaviour = BreedingBehaviour.valueOf(breedingBehaviourText);
        }
    }

    public static enum Shearing {
        INSTANCE;

        public static final String CATEGORY = "general.shearing";
        private ShearBehaviour shearBehaviour = ShearBehaviour.RevertSheep;

        public static ShearBehaviour getBehaviour() {
            return Shearing.INSTANCE.shearBehaviour;
        }

        private static void syncConfig(Configuration config) {
            String[] validNames = new String[ShearBehaviour.values().length];
            for (int i = 0; i < ShearBehaviour.values().length; ++i) {
                validNames[i] = ShearBehaviour.values()[i].name();
            }
            String behaviour = config.getString("behaviour", CATEGORY, "RevertSheep", "Sets the behaviour when a sheep is sheared\n* RevertSheep - will change the sheep back to a normal sheep (default).\n* ChiselFarm  - will allow the sheep to produce chiseled blocks (warning, this currently allows duping ores).\n* CannotShear - You cannot shear the sheep while chiseled.\n", validNames);
            Shearing.INSTANCE.shearBehaviour = ShearBehaviour.valueOf(behaviour);
        }
    }
}

