/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.rendering;

import com.github.atomicblom.shearmadness.api.rendering.PartDefinition;
import java.util.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class QuadrupedTransformDefinition {
    protected static final float NintyDegrees = (float)Math.PI;
    protected Optional<PartDefinition> bodyPartDefinition = Optional.empty();
    protected Optional<PartDefinition> headPartDefinition = Optional.empty();
    protected Optional<PartDefinition> leg1PartDefinition = Optional.empty();
    protected Optional<PartDefinition> leg2PartDefinition = Optional.empty();
    protected Optional<PartDefinition> leg3PartDefinition = Optional.empty();
    protected Optional<PartDefinition> leg4PartDefinition = Optional.empty();

    public QuadrupedTransformDefinition() {
        this.bodyPartDefinition = Optional.empty();
        this.headPartDefinition = Optional.empty();
        this.leg1PartDefinition = Optional.empty();
        this.leg2PartDefinition = Optional.empty();
        this.leg3PartDefinition = Optional.empty();
        this.leg4PartDefinition = Optional.empty();
        this.defineParts();
    }

    public void defineParts() {
        Matrix4f rotate = new Matrix4f().rotate((float)Math.toRadians(-90.0), new Vector3f(1.0f, 0.0f, 0.0f));
        this.bodyPartDefinition = Optional.of(new PartDefinition(new Vector3f(0.0f, 5.0f, 2.0f), Matrix4f.mul((Matrix4f)QuadrupedTransformDefinition.createPartMatrix(new Vector3f(12.0f, 20.0f, 10.0f), new Vector3f(0.0f, -2.0f, -14.0f)), (Matrix4f)rotate, null), new Matrix3f()));
        this.headPartDefinition = Optional.of(new PartDefinition(new Vector3f(0.0f, 6.0f, -8.0f), QuadrupedTransformDefinition.createPartMatrix(new Vector3f(8.0f, 8.0f, 8.0f), new Vector3f(0.0f, -1.0f, -1.0f)), new Matrix3f()));
        this.leg1PartDefinition = Optional.of(new PartDefinition(new Vector3f(-3.0f, 12.0f, 7.0f), QuadrupedTransformDefinition.createPartMatrix(new Vector3f(5.6f, 7.4f, 5.6f), new Vector3f(0.0f, 3.0f, 0.1f)), new Matrix3f()));
        this.leg2PartDefinition = Optional.of(new PartDefinition(new Vector3f(3.0f, 12.0f, 7.0f), QuadrupedTransformDefinition.createPartMatrix(new Vector3f(5.6f, 7.4f, 5.6f), new Vector3f(0.0f, 3.0f, 0.1f)), new Matrix3f()));
        this.leg3PartDefinition = Optional.of(new PartDefinition(new Vector3f(-3.0f, 12.0f, -5.0f), QuadrupedTransformDefinition.createPartMatrix(new Vector3f(5.6f, 7.4f, 5.6f), new Vector3f(0.0f, 3.0f, 0.1f)), new Matrix3f()));
        this.leg4PartDefinition = Optional.of(new PartDefinition(new Vector3f(3.0f, 12.0f, -5.0f), QuadrupedTransformDefinition.createPartMatrix(new Vector3f(5.6f, 7.4f, 5.6f), new Vector3f(0.0f, 3.0f, 0.1f)), new Matrix3f()));
    }

    protected static Matrix4f createPartMatrix(Vector3f size, Vector3f additionalTranslate) {
        Vector3f adjustedSize = size.translate(-0.5f, -0.5f, -0.5f);
        Matrix4f matrix = new Matrix4f();
        matrix.rotate((float)Math.PI, new Vector3f(1.0f, 0.0f, 0.0f));
        matrix.translate((Vector3f)Vector3f.add((Vector3f)((Vector3f)new Vector3f((ReadableVector3f)adjustedSize).scale(0.5f)), (Vector3f)additionalTranslate, null).negate());
        matrix.scale(adjustedSize);
        return matrix;
    }

    public Optional<PartDefinition> getBodyPartDefinition() {
        return this.bodyPartDefinition;
    }

    public Optional<PartDefinition> getHeadPartDefinition() {
        return this.headPartDefinition;
    }

    public Optional<PartDefinition> getLeg1PartDefinition() {
        return this.leg1PartDefinition;
    }

    public Optional<PartDefinition> getLeg2PartDefinition() {
        return this.leg2PartDefinition;
    }

    public Optional<PartDefinition> getLeg3PartDefinition() {
        return this.leg3PartDefinition;
    }

    public Optional<PartDefinition> getLeg4PartDefinition() {
        return this.leg4PartDefinition;
    }
}

