/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.rendering;

import com.github.atomicblom.shearmadness.api.rendering.VertexConsumer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class EntityMesh
extends ModelBox {
    private final List<FutureQuad<BakedQuad>> allBakedQuads = new ArrayList<FutureQuad<BakedQuad>>(6);
    private final List<FutureQuad<TexturedQuad>> allTexturedQuads = new ArrayList<FutureQuad<TexturedQuad>>(6);
    private TexturedQuad[] quadList = null;
    private boolean errored;

    public EntityMesh(ModelRenderer renderer) {
        super(renderer, 0, 0, 0.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, false);
    }

    public void addBakedQuads(Matrix4f positionTransform, Matrix3f textureTransform, Collection<BakedQuad> bakedQuads) {
        if (bakedQuads != null && bakedQuads.size() > 0) {
            this.allBakedQuads.add(new FutureQuad<BakedQuad>(bakedQuads, positionTransform, textureTransform));
        }
    }

    public void addTexturedQuads(Matrix4f positionTransform, Matrix3f textureTransform, Collection<TexturedQuad> texturedQuads) {
        if (texturedQuads != null && texturedQuads.size() > 0) {
            this.allTexturedQuads.add(new FutureQuad<TexturedQuad>(texturedQuads, positionTransform, textureTransform));
        }
    }

    public void addTexturedQuads(Matrix4f positionTransform, Matrix3f textureTransform, TexturedQuad ... texturedQuads) {
        if (texturedQuads != null && texturedQuads.length > 0) {
            this.allTexturedQuads.add(new FutureQuad(Lists.newArrayList((Object[])texturedQuads), positionTransform, textureTransform));
        }
    }

    /*
     * WARNING - void declaration
     */
    @SideOnly(value=Side.CLIENT)
    public void func_178780_a(VertexBuffer renderer, float scale) {
        void var5_10;
        if (this.quadList == null) {
            ArrayList outputQuads = Lists.newArrayList();
            for (FutureQuad<TexturedQuad> futureQuad : this.allTexturedQuads) {
                for (TexturedQuad texturedQuad : ((FutureQuad)futureQuad).quads) {
                    PositionTextureVertex[] newPositions = new PositionTextureVertex[4];
                    for (int i = 0; i < texturedQuad.field_78239_a.length; ++i) {
                        PositionTextureVertex vertexPosition = texturedQuad.field_78239_a[i];
                        Vector4f position = new Vector4f((float)vertexPosition.field_78243_a.field_72450_a, (float)vertexPosition.field_78243_a.field_72448_b, (float)vertexPosition.field_78243_a.field_72449_c, 1.0f);
                        Vector3f textureCoords = new Vector3f(vertexPosition.field_78241_b, vertexPosition.field_78242_c, 1.0f);
                        Vector4f transformedPosition = Matrix4f.transform((Matrix4f)((FutureQuad)futureQuad).positionTransform, (Vector4f)position, null);
                        Vector3f transformedTexture = Matrix3f.transform((Matrix3f)((FutureQuad)futureQuad).textureTransform, (Vector3f)textureCoords, null);
                        newPositions[i] = new PositionTextureVertex(transformedPosition.getX(), transformedPosition.getY(), transformedPosition.getZ(), transformedTexture.getX(), transformedTexture.getY());
                    }
                    outputQuads.add(new TexturedQuad(newPositions));
                }
            }
            for (FutureQuad<TexturedQuad> futureQuad : this.allBakedQuads) {
                for (BakedQuad bakedQuad : ((FutureQuad)futureQuad).quads) {
                    try {
                        VertexConsumer consumer = new VertexConsumer(bakedQuad.getFormat(), ((FutureQuad)futureQuad).positionTransform, ((FutureQuad)futureQuad).textureTransform);
                        bakedQuad.pipe((IVertexConsumer)consumer);
                        outputQuads.add(consumer.getOutputQuad());
                    }
                    catch (Exception e) {
                        if (!this.errored) {
                            LogManager.getLogger((String)"ShearMadnessAPI").log(Level.ERROR, "Error creating chiseled model", (Throwable)e);
                        }
                        this.errored = true;
                    }
                }
            }
            this.quadList = new TexturedQuad[outputQuads.size()];
            this.quadList = outputQuads.toArray(this.quadList);
        }
        TexturedQuad[] texturedQuadArray = this.quadList;
        int n = texturedQuadArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            TexturedQuad texturedquad = texturedQuadArray[var5_10];
            texturedquad.func_178765_a(renderer, scale);
            ++var5_10;
        }
    }

    private static class FutureQuad<T> {
        private final Collection<T> quads;
        private final Matrix4f positionTransform;
        private final Matrix3f textureTransform;

        FutureQuad(Collection<T> quads, Matrix4f positionTransform, Matrix3f textureTransform) {
            this.quads = quads;
            this.positionTransform = positionTransform;
            this.textureTransform = textureTransform;
        }
    }
}

