/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api.behaviour;

import java.util.function.Supplier;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.math.BlockPos;

public abstract class BehaviourBase<T extends BehaviourBase> {
    private final EntitySheep entity;
    private final Supplier<Boolean> configuration;

    protected BehaviourBase(EntitySheep sheep) {
        this(sheep, () -> true);
    }

    protected BehaviourBase(EntitySheep entity, Supplier<Boolean> configuration) {
        this.entity = entity;
        this.configuration = configuration;
    }

    public boolean isBehaviourEnabled() {
        return this.configuration.get();
    }

    public void onSheepMovedBlock(BlockPos previousLocation, BlockPos newLocation) {
    }

    public void onBehaviourStarted(BlockPos currentPos) {
    }

    public void onBehaviourStopped(BlockPos previousPos) {
    }

    public void updateTask() {
    }

    public boolean isEquivalentTo(T other) {
        return this.entity.func_110124_au().equals(((BehaviourBase)other).getEntity().func_110124_au());
    }

    public EntitySheep getEntity() {
        return this.entity;
    }
}

