/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api;

import com.github.atomicblom.shearmadness.api.IVariationRegistry;
import com.github.atomicblom.shearmadness.api.ShearMadnessVariation;
import com.github.atomicblom.shearmadness.api.modelmaker.DefaultModelMaker;
import com.github.atomicblom.shearmadness.api.modelmaker.IModelMaker;
import com.github.atomicblom.shearmadness.api.rendering.QuadrupedTransformDefinition;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class VariationRegistry
implements IVariationRegistry {
    public static final VariationRegistry INSTANCE = new VariationRegistry();
    private final List<ShearMadnessVariation> variations = new LinkedList<ShearMadnessVariation>();
    private final IModelMaker defaultHandler = new DefaultModelMaker();

    private VariationRegistry() {
    }

    @Override
    public void registerVariation(Function<ItemStack, Boolean> handlesVariant, IModelMaker variationModelMaker) {
        this.variations.add(new ShearMadnessVariation(handlesVariant, variationModelMaker));
    }

    @Override
    public void registerVariation(Function<ItemStack, Boolean> handlesVariant, QuadrupedTransformDefinition transformDefinition) {
        this.variations.add(new ShearMadnessVariation(handlesVariant, new DefaultModelMaker(transformDefinition)));
    }

    public IModelMaker getVariationModelMaker(ItemStack itemStack) {
        IModelMaker handler = null;
        for (ShearMadnessVariation variation : this.variations) {
            if (!variation.canHandleItemStack(itemStack)) continue;
            handler = variation.getVariationModelMaker();
            break;
        }
        if (handler == null) {
            handler = this.defaultHandler;
        }
        return handler;
    }
}

