/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.shearmadness.api;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public final class ItemStackHelper {
    private ItemStackHelper() {
    }

    public static boolean isStackForBlock(ItemStack itemStack, Block block) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof ItemBlock && Objects.equals(((ItemBlock)item).field_150939_a, block);
    }

    public static boolean isStackForBlockSubclassOf(ItemStack itemStack, Class<? extends Block> blockClass) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof ItemBlock && blockClass.isAssignableFrom(((ItemBlock)item).field_150939_a.getClass());
    }

    public static boolean isStackForBlock(ItemStack itemStack, Block block, int meta) {
        return ItemStackHelper.isStackForBlock(itemStack, block) && itemStack.func_77952_i() == meta;
    }

    public static boolean isStackForBlock(ItemStack itemStack, Block ... blocks) {
        return ItemStackHelper.isStackForBlock(itemStack, (Iterator<Block>)Iterators.forArray((Object[])blocks));
    }

    private static boolean isStackForBlock(ItemStack itemStack, Iterator<Block> blocks) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = ((ItemBlock)item).field_150939_a;
            while (blocks.hasNext()) {
                if (!Objects.equals(blocks.next(), block)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isStackForBlock(ItemStack itemStack, Iterable<Block> blocks) {
        return ItemStackHelper.isStackForBlock(itemStack, blocks.iterator());
    }
}

