/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import javax.annotation.Nullable;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerDefault;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class PartContainerPartCable
extends PartContainerDefault {
    private final PartCable partCable;

    public PartContainerPartCable(PartCable partCable) {
        this.partCable = partCable;
    }

    protected PartPartType getPartPart(EnumFacing side) {
        ISlottedPart multipart;
        IMultipartContainer container = this.partCable.getContainer();
        if (container != null && (multipart = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side))) instanceof PartPartType) {
            return (PartPartType)multipart;
        }
        return null;
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(EnumFacing side, IPartType<P, S> part) {
        return super.canAddPart(side, part) && MultipartHelper.canAddPart((World)this.getWorld(), (BlockPos)this.getPos(), (IMultipart)new PartPartType(side, part));
    }

    @Override
    public <P extends IPartType<P, S>, S extends IPartState<P>> void setPart(EnumFacing side, IPartType<P, S> part, IPartState<P> partState) {
        PartPartType partPart = new PartPartType(side, part);
        super.setPart(side, part, partState);
        MultipartHelper.addPart((World)this.getWorld(), (BlockPos)this.getPos(), (IMultipart)partPart);
    }

    @Override
    public IPartType removePart(EnumFacing side, EntityPlayer player, boolean dropMainElement) {
        PartPartType partPartType = this.getPartPart(side);
        IPartType removed = super.removePart(side, player, dropMainElement);
        if (removed != null && partPartType != null) {
            this.partCable.getContainer().removePart((IMultipart)partPartType);
        }
        return removed;
    }

    @Override
    protected void markDirty() {
        this.partCable.markDirty();
    }

    @Override
    protected void sendUpdate() {
        this.partCable.sendUpdate();
    }

    @Override
    protected World getWorld() {
        return this.partCable.getWorld();
    }

    @Override
    protected BlockPos getPos() {
        return this.partCable.getPos();
    }

    @Override
    protected INetwork getNetwork() {
        return this.partCable.getNetwork();
    }

    @Override
    @Nullable
    public EnumFacing getWatchingSide(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
        Vec3d end = RayTraceUtils.getEnd((EntityPlayer)player);
        RayTraceUtils.AdvancedRayTraceResultPart result = ((TileMultipartContainer)world.func_175625_s(pos)).getPartContainer().collisionRayTrace(start, end);
        if (result == null || result.hit == null) {
            return null;
        }
        IMultipart multipart = ((PartMOP)result.hit).partHit;
        if (!(multipart instanceof PartPartType)) {
            return null;
        }
        PartPartType partPartType = (PartPartType)((PartMOP)result.hit).partHit;
        return partPartType != null ? partPartType.getFacing() : null;
    }
}

