/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PartTypeAdapter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlock;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.item.ItemPart;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;

public abstract class PartTypeBase<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeAdapter<P, S>
implements IGuiContainerProvider {
    private final Item item;
    private ItemConfig itemConfig;
    private final Block block;
    private final int guiID;
    private final String name;
    private final PartRenderPosition partRenderPosition;
    private final Map<Class<? extends INetworkEvent>, IEventAction> networkEventActions;

    public PartTypeBase(String name, PartRenderPosition partRenderPosition) {
        if (this.hasGui()) {
            this.guiID = Helpers.getNewId((ModBase)this.getModGui(), (Helpers.IDType)Helpers.IDType.GUI);
            this.getModGui().getGuiHandler().registerGUI((IGuiContainerProvider)this, ExtendedGuiHandler.PART);
        } else {
            this.guiID = -1;
        }
        this.name = name;
        this.block = this.registerBlock();
        this.item = this.registerItem();
        this.partRenderPosition = partRenderPosition;
        this.networkEventActions = this.constructNetworkEventActions();
    }

    protected ModBase getMod() {
        return IntegratedDynamics._instance;
    }

    public abstract Class<? super P> getPartTypeClass();

    protected Block createBlock(BlockConfig blockConfig) {
        return new IgnoredBlock((ExtendedConfig)blockConfig);
    }

    protected Block registerBlock() {
        BlockConfig blockConfig = new BlockConfig(this.getMod(), true, "part_" + this.getName() + "Block", null, null){

            public boolean isDisableable() {
                return false;
            }
        };
        Block block = this.createBlock(blockConfig);
        BlockAction.register((Block)block, (ExtendedConfig)blockConfig, (CreativeTabs)blockConfig.getTargetTab());
        return block;
    }

    protected Item createItem(ItemConfig itemConfig) {
        return new ItemPart((ExtendedConfig)itemConfig, this);
    }

    protected Item registerItem() {
        this.itemConfig = new ItemConfig(this.getMod(), true, "part_" + this.getName() + "Item", null, null){

            public boolean isDisableable() {
                return false;
            }

            public String getFullUnlocalizedName() {
                return PartTypeBase.this.getUnlocalizedName();
            }
        };
        Item item = this.createItem(this.itemConfig);
        ItemAction.register((Item)item, (ExtendedConfig)this.itemConfig, (CreativeTabs)this.itemConfig.getTargetTab());
        this.getMod().getConfigHandler().addToConfigDictionary((ExtendedConfig)this.itemConfig);
        return item;
    }

    @Override
    public ResourceLocation getBlockModelPath() {
        return new ResourceLocation(this.getMod().getModId(), "part_" + this.getName() + "Block");
    }

    @Override
    public String getUnlocalizedNameBase() {
        return "parttype.parttypes." + this.getMod().getModId() + "." + this.getName();
    }

    @Override
    public void onInit(IInitListener.Step initStep) {
        if (MinecraftHelpers.isClientSide() && initStep == IInitListener.Step.INIT) {
            ItemAction.handleItemModel((Item)this.getItem(), (String)this.itemConfig.getNamedId(), (CreativeTabs)this.itemConfig.getTargetTab(), (String)this.getMod().getModId(), (IModelProviderConfig)this.itemConfig);
        }
    }

    @Override
    public INetworkElement createNetworkElement(IPartContainer partContainer, DimPos pos, EnumFacing side) {
        return new PartNetworkElement(this, PartTarget.fromCenter(pos, side));
    }

    protected boolean hasGui() {
        return true;
    }

    public ModBase getModGui() {
        return this.getMod();
    }

    @Override
    public boolean onPartActivated(World world, BlockPos pos, S partState, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() || !partState.isEnabled()) {
            return false;
        }
        if (this.hasGui()) {
            this.getModGui().getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)side);
            if (!world.field_72995_K && this.hasGui()) {
                player.openGui((Object)this.getModGui().getModId(), this.getGuiID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getBlockState(IPartContainer partContainer, EnumFacing side) {
        return this.getBlock().func_176223_P().func_177226_a((IProperty)IgnoredBlock.FACING, (Comparable)side);
    }

    @Override
    public BlockStateContainer getBaseBlockState() {
        return this.getBlock().func_176194_O();
    }

    @Override
    public void loadTooltip(S state, List<String> lines) {
        if (!state.isEnabled()) {
            lines.add(L10NHelpers.localize((String)"parttype.parttypes.integrateddynamics.tooltip.disabled"));
        }
        lines.add(L10NHelpers.localize((String)"item.items.integrateddynamics.general.id", (Object[])new Object[]{state.getId()}));
    }

    protected Map<Class<? extends INetworkEvent>, IEventAction> constructNetworkEventActions() {
        return new IdentityHashMap<Class<? extends INetworkEvent>, IEventAction>();
    }

    @Override
    public final boolean hasEventSubscriptions() {
        return !this.networkEventActions.isEmpty();
    }

    @Override
    public final Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return this.networkEventActions.keySet();
    }

    @Override
    public final void onEvent(INetworkEvent event, IPartNetworkElement<P, S> networkElement) {
        this.networkEventActions.get(event.getClass()).onAction(event.getNetwork(), networkElement.getTarget(), networkElement.getPartState(), event);
    }

    @Override
    public boolean forceLightTransparency(S state) {
        return false;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getGuiID() {
        return this.guiID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PartRenderPosition getPartRenderPosition() {
        return this.partRenderPosition;
    }

    public static interface IEventAction<P extends IPartType<P, S>, S extends IPartState<P>, E extends INetworkEvent> {
        public void onAction(INetwork var1, PartTarget var2, S var3, E var4);
    }
}

