/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.CompositeMap;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.FullNetworkListenerAdapter;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.variablecontainer.VariableContainerConfig;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class PartNetwork
extends FullNetworkListenerAdapter
implements IPartNetwork {
    private INetwork network;
    private TIntObjectMap<PartPos> partPositions = new TIntObjectHashMap();
    private List<DimPos> variableContainerPositions = Lists.newArrayList();
    private Map<Integer, IVariableFacade> compositeVariableCache = null;
    private TIntObjectMap<IValue> lazyExpressionValueCache = new TIntObjectHashMap();
    private TIntObjectMap<DimPos> proxyPositions = new TIntObjectHashMap();
    private volatile boolean partsChanged = false;

    @Override
    public boolean addPart(int partId, PartPos partPos) {
        if (this.partPositions.containsKey(partId)) {
            return false;
        }
        this.partPositions.put(partId, (Object)partPos);
        return true;
    }

    @Override
    public IPartState getPartState(int partId) {
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        return PartHelpers.getPartContainer(partPos.getPos()).getPartState(partPos.getSide());
    }

    @Override
    public IPartType getPartType(int partId) {
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        return PartHelpers.getPartContainer(partPos.getPos()).getPart(partPos.getSide());
    }

    @Override
    public void removePart(int partId) {
        this.partPositions.remove(partId);
    }

    @Override
    public boolean hasPart(int partId) {
        if (!this.partPositions.containsKey(partId)) {
            return false;
        }
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        IPartContainer partContainer = PartHelpers.getPartContainer(partPos.getPos());
        return partContainer != null && partContainer.hasPart(partPos.getSide());
    }

    @Override
    public <V extends IValue> boolean hasPartVariable(int partId, IAspectRead<V, ?> aspect) {
        if (!this.hasPart(partId)) {
            return false;
        }
        IPartState partState = this.getPartState(partId);
        if (!(partState instanceof IPartStateReader)) {
            return false;
        }
        IPartType partType = this.getPartType(partId);
        if (!(partType instanceof IPartTypeReader)) {
            return false;
        }
        try {
            return ((IPartTypeReader)this.getPartType(partId)).getVariable(PartTarget.fromCenter((PartPos)this.partPositions.get(partId)), (IPartStateReader)partState, aspect) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public <V extends IValue> IVariable<V> getPartVariable(int partId, IAspectRead<V, ?> aspect) {
        return ((IPartStateReader)this.getPartState(partId)).getVariable(aspect);
    }

    protected Map<Integer, IVariableFacade> getVariableCache() {
        if (this.compositeVariableCache == null) {
            CompositeMap compositeMap = new CompositeMap();
            Iterator<DimPos> it = this.variableContainerPositions.iterator();
            while (it.hasNext()) {
                DimPos dimPos = it.next();
                IVariableContainer variableContainer = (IVariableContainer)TileHelpers.getCapability((DimPos)dimPos, null, VariableContainerConfig.CAPABILITY);
                if (variableContainer != null) {
                    compositeMap.addElement(variableContainer.getVariableCache());
                    continue;
                }
                IntegratedDynamics.clog(Level.ERROR, "The variable container at " + dimPos + " was invalid, skipping.");
                it.remove();
            }
            this.compositeVariableCache = compositeMap;
        }
        return this.compositeVariableCache;
    }

    @Override
    public boolean hasVariableFacade(int variableId) {
        return this.getVariableCache().containsKey(variableId);
    }

    @Override
    public IVariableFacade getVariableFacade(int variableId) {
        return this.getVariableCache().get(variableId);
    }

    @Override
    public void setValue(int id, IValue value) {
        this.lazyExpressionValueCache.put(id, (Object)value);
    }

    @Override
    public boolean hasValue(int id) {
        return this.lazyExpressionValueCache.containsKey(id);
    }

    @Override
    public IValue getValue(int id) {
        return (IValue)this.lazyExpressionValueCache.get(id);
    }

    @Override
    public boolean addVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        return this.variableContainerPositions.add(dimPos);
    }

    @Override
    public void removeVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        this.variableContainerPositions.remove(dimPos);
    }

    @Override
    public boolean addProxy(int proxyId, DimPos dimPos) {
        if (this.proxyPositions.containsKey(proxyId)) {
            return false;
        }
        this.proxyPositions.put(proxyId, (Object)dimPos);
        return true;
    }

    @Override
    public void removeProxy(int proxyId) {
        this.proxyPositions.remove(proxyId);
    }

    @Override
    public DimPos getProxy(int proxyId) {
        return (DimPos)this.proxyPositions.get(proxyId);
    }

    @Override
    public void notifyPartsChanged() {
        this.partsChanged = true;
    }

    private void onPartsChanged() {
    }

    @Override
    public void update() {
        this.lazyExpressionValueCache.clear();
        if (this.partsChanged) {
            this.partsChanged = false;
            this.onPartsChanged();
        }
    }

    @Override
    public boolean removePathElement(IPathElement pathElement) {
        this.notifyPartsChanged();
        return true;
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

