/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.block.BlockLogicProgrammer;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.OperatorLPElementRenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class OperatorLPElement
implements ILogicProgrammerElement<RenderPattern, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final IOperator operator;
    private IVariableFacade[] inputVariables;
    private boolean focused = false;

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.OPERATOR;
    }

    @Override
    public String getMatchString() {
        return this.getOperator().getLocalizedNameFull().toLowerCase();
    }

    @Override
    public boolean matchesInput(IValueType valueType) {
        for (IValueType operatorIn : this.getOperator().getInputTypes()) {
            if (!ValueHelpers.correspondsTo(operatorIn, valueType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesOutput(IValueType valueType) {
        return ValueHelpers.correspondsTo(this.getOperator().getOutputType(), valueType);
    }

    @Override
    public String getLocalizedNameFull() {
        return this.getOperator().getLocalizedNameFull();
    }

    @Override
    public void loadTooltip(List<String> lines) {
        this.getOperator().loadTooltip(lines, true);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.getOperator().getRenderPattern();
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        IVariableFacade variableFacade;
        this.inputVariables[slotId] = variableFacade = ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).handle(itemStack);
    }

    @Override
    public boolean canWriteElementPre() {
        for (IVariableFacade inputVariable : this.inputVariables) {
            if (inputVariable != null && inputVariable.isValid()) continue;
            return false;
        }
        return true;
    }

    protected int[] getVariableIds(IVariableFacade[] inputVariables) {
        int[] variableIds = new int[inputVariables.length];
        for (int i = 0; i < inputVariables.length; ++i) {
            variableIds[i] = inputVariables[i].getId();
        }
        return variableIds;
    }

    @Override
    public ItemStack writeElement(EntityPlayer player, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        int[] variableIds = this.getVariableIds(this.inputVariables);
        return registry.writeVariableFacadeItem(!MinecraftHelpers.isClientSide(), itemStack, Operators.REGISTRY, new OperatorVariableFacadeFactory(this.operator, variableIds), player, (Block)BlockLogicProgrammer.getInstance());
    }

    @Override
    public boolean canCurrentlyReadFromOtherItem() {
        return true;
    }

    @Override
    public void activate() {
        this.inputVariables = new IVariableFacade[this.getRenderPattern().getSlotPositions().length];
    }

    @Override
    public void deactivate() {
        this.inputVariables = null;
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        return this.getOperator().validateTypes(ValueHelpers.from(this.inputVariables));
    }

    @Override
    public int getColor() {
        return this.getOperator().getOutputType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return this.getOperator().getSymbol();
    }

    @Override
    public boolean isFor(IVariableFacade variableFacade) {
        IOperatorVariableFacade operatorFacade;
        if (variableFacade instanceof IOperatorVariableFacade && (operatorFacade = (IOperatorVariableFacade)variableFacade).isValid()) {
            return this.getOperator() == operatorFacade.getOperator();
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return itemStack.func_77973_b() == ItemVariable.getInstance();
    }

    @Override
    public boolean isFocused(RenderPattern subGui) {
        return this.focused;
    }

    @Override
    public void setFocused(RenderPattern subGui, boolean focused) {
        this.focused = focused;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderPattern createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        return new OperatorLPElementRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    @ConstructorProperties(value={"operator"})
    public OperatorLPElement(IOperator operator) {
        this.operator = operator;
    }

    public IOperator getOperator() {
        return this.operator;
    }

    public IVariableFacade[] getInputVariables() {
        return this.inputVariables;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setInputVariables(IVariableFacade[] inputVariables) {
        this.inputVariables = inputVariables;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperatorLPElement)) {
            return false;
        }
        OperatorLPElement other = (OperatorLPElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IOperator this$operator = this.getOperator();
        IOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInputVariables(), other.getInputVariables())) {
            return false;
        }
        return this.isFocused() == other.isFocused();
    }

    protected boolean canEqual(Object other) {
        return other instanceof OperatorLPElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInputVariables());
        result = result * 59 + (this.isFocused() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "OperatorLPElement(operator=" + this.getOperator() + ", inputVariables=" + Arrays.deepToString(this.getInputVariables()) + ", focused=" + this.isFocused() + ")";
    }

    protected static class OperatorVariableFacadeFactory
    implements IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IOperatorVariableFacade> {
        private final IOperator operator;
        private final int[] variableIds;

        public OperatorVariableFacadeFactory(IOperator operator, int[] variableIds) {
            this.operator = operator;
            this.variableIds = variableIds;
        }

        @Override
        public IOperatorVariableFacade create(boolean generateId) {
            return new OperatorVariableFacade(generateId, this.operator, this.variableIds);
        }

        @Override
        public IOperatorVariableFacade create(int id) {
            return new OperatorVariableFacade(id, this.operator, this.variableIds);
        }
    }
}

