/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionServer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class ContainerMultipartAspects<P extends IPartType<P, S> & IGuiContainerProvider, S extends IPartState<P>, A extends IAspect>
extends ScrollingInventoryContainer<A>
implements IDirtyMarkListener {
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final P partType;
    private final World world;
    private final BlockPos pos;
    private final Map<IAspect, Integer> aspectPropertyButtons = Maps.newHashMap();
    protected final IInventory inputSlots;
    protected final EntityPlayer player;

    public ContainerMultipartAspects(EntityPlayer player, PartTarget target, IPartContainer partContainer, P partType, List<A> items) {
        super(player.field_71071_by, (IGuiContainerProvider)partType, items, new ScrollingInventoryContainer.IItemPredicate<A>(){

            public boolean apply(A item, Pattern pattern) {
                return pattern.matcher(L10NHelpers.localize((String)item.getUnlocalizedName()).toLowerCase()).matches();
            }
        });
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = player.func_130014_f_();
        this.pos = player.func_180425_c();
        this.inputSlots = this.constructInputSlotsInventory();
        this.player = player;
        this.putButtonAction(1, (IButtonActionServer)new IButtonActionServer<InventoryContainer>(){

            public void onAction(int buttonId, InventoryContainer container) {
                if (!((ContainerMultipartAspects)ContainerMultipartAspects.this).world.field_72995_K) {
                    IGuiContainerProvider gui = ((PartTypeConfigurable)ContainerMultipartAspects.this.getPartType()).getSettingsGuiProvider();
                    IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.PART, (Object)ContainerMultipartAspects.this.getTarget().getCenter().getSide());
                    BlockPos cPos = ContainerMultipartAspects.this.getTarget().getCenter().getPos().getBlockPos();
                    ContainerMultipartAspects.this.player.openGui((Object)gui.getModGui(), gui.getGuiID(), ContainerMultipartAspects.this.world, cPos.func_177958_n(), cPos.func_177956_o(), cPos.func_177952_p());
                }
            }
        });
        int nextButtonId = 2;
        for (final IAspect aspect : this.getUnfilteredItems()) {
            if (!aspect.hasProperties()) continue;
            this.aspectPropertyButtons.put(aspect, nextButtonId);
            this.putButtonAction(nextButtonId, (IButtonActionServer)new IButtonActionServer<InventoryContainer>(){

                public void onAction(int buttonId, InventoryContainer container) {
                    IGuiContainerProvider gui = aspect.getPropertiesGuiProvider();
                    IntegratedDynamics._instance.getGuiHandler().setTemporaryData(ExtendedGuiHandler.ASPECT, (Object)Pair.of((Object)ContainerMultipartAspects.this.getTarget().getCenter().getSide(), (Object)aspect));
                    if (!((ContainerMultipartAspects)ContainerMultipartAspects.this).world.field_72995_K) {
                        BlockPos cPos = ContainerMultipartAspects.this.getTarget().getCenter().getPos().getBlockPos();
                        ContainerMultipartAspects.this.player.openGui((Object)gui.getModGui(), gui.getGuiID(), ContainerMultipartAspects.this.world, cPos.func_177958_n(), cPos.func_177956_o(), cPos.func_177952_p());
                    }
                }
            });
            ++nextButtonId;
        }
    }

    public Map<IAspect, Integer> getAspectPropertyButtons() {
        return Collections.unmodifiableMap(this.aspectPropertyButtons);
    }

    public S getPartState() {
        return (S)this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public abstract int getAspectBoxHeight();

    protected IInventory constructInputSlotsInventory() {
        SimpleInventory inventory = new SimpleInventory(this.getUnfilteredItemCount(), "temporaryInputSlots", 1);
        inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        return inventory;
    }

    public void func_75134_a(EntityPlayer player) {
        if (this.inputSlots instanceof SimpleInventory) {
            ((SimpleInventory)this.inputSlots).removeDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        slot.field_75223_e = Integer.MIN_VALUE;
        slot.field_75221_f = Integer.MIN_VALUE;
    }

    protected abstract void enableSlot(int var1, int var2);

    public int getPageSize() {
        return 3;
    }

    protected void onScroll() {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
    }

    protected void enableElementAt(int row, int elementIndex, A element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlot(elementIndex, row);
    }

    protected int getSizeInventory() {
        return this.getUnfilteredItemCount();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return PartHelpers.canInteractWith(this.getTarget(), player, this.partContainer);
    }

    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, final IAspect aspect) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, Aspects.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IAspectVariableFacade>(){

            @Override
            public IAspectVariableFacade create(boolean generateId) {
                return new AspectVariableFacade(generateId, ContainerMultipartAspects.this.getPartState().getId(), aspect);
            }

            @Override
            public IAspectVariableFacade create(int id) {
                return new AspectVariableFacade(id, ContainerMultipartAspects.this.getPartState().getId(), aspect);
            }
        }, null, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContainerMultipartAspects)) {
            return false;
        }
        ContainerMultipartAspects other = (ContainerMultipartAspects)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        P this$partType = this.getPartType();
        P other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        BlockPos this$pos = this.getPos();
        BlockPos other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Map<IAspect, Integer> this$aspectPropertyButtons = this.getAspectPropertyButtons();
        Map<IAspect, Integer> other$aspectPropertyButtons = other.getAspectPropertyButtons();
        if (this$aspectPropertyButtons == null ? other$aspectPropertyButtons != null : !((Object)this$aspectPropertyButtons).equals(other$aspectPropertyButtons)) {
            return false;
        }
        IInventory this$inputSlots = this.getInputSlots();
        IInventory other$inputSlots = other.getInputSlots();
        if (this$inputSlots == null ? other$inputSlots != null : !this$inputSlots.equals(other$inputSlots)) {
            return false;
        }
        EntityPlayer this$player = this.getPlayer();
        EntityPlayer other$player = other.getPlayer();
        return !(this$player == null ? other$player != null : !this$player.equals(other$player));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContainerMultipartAspects;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        P $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        BlockPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Map<IAspect, Integer> $aspectPropertyButtons = this.getAspectPropertyButtons();
        result = result * 59 + ($aspectPropertyButtons == null ? 43 : ((Object)$aspectPropertyButtons).hashCode());
        IInventory $inputSlots = this.getInputSlots();
        result = result * 59 + ($inputSlots == null ? 43 : $inputSlots.hashCode());
        EntityPlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public P getPartType() {
        return this.partType;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IInventory getInputSlots() {
        return this.inputSlots;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public String toString() {
        return "ContainerMultipartAspects(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", world=" + this.getWorld() + ", pos=" + this.getPos() + ", aspectPropertyButtons=" + this.getAspectPropertyButtons() + ", inputSlots=" + this.getInputSlots() + ", player=" + this.getPlayer() + ")";
    }
}

