/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.core.client.model.ModelHelpers;
import org.cyclops.integrateddynamics.core.client.model.VariableModelBaked;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;

public class VariableModel
implements IModel {
    private final ModelBlock base;

    public VariableModel(ModelBlock base) {
        this.base = base;
    }

    public static void addAdditionalModels(ImmutableSet.Builder<ResourceLocation> builder) {
        for (IVariableModelProvider<? extends IVariableModelProvider.IBakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            builder.addAll(provider.getDependencies());
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        if (this.base.func_178305_e() == null || this.base.func_178305_e().func_110623_a().startsWith("builtin/")) {
            return Collections.emptyList();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.base.func_178305_e());
        VariableModel.addAdditionalModels((ImmutableSet.Builder<ResourceLocation>)builder);
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        HashSet textures = Sets.newHashSet();
        this.base.field_178315_d = ModelHelpers.MODEL_GENERATED;
        if (this.base.func_178310_f().field_178317_b.equals("generation marker")) {
            for (String textureName : ItemModelGenerator.field_178398_a) {
                String path = this.base.func_178308_c(textureName);
                ResourceLocation resourceLocation = new ResourceLocation(path);
                if (path.equals(textureName)) continue;
                textures.add(resourceLocation);
            }
        }
        for (String textureName : this.base.field_178318_c.values()) {
            if (textureName.startsWith("#")) continue;
            textures.add(new ResourceLocation(textureName));
        }
        return textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseModel = ModelHelpers.bakeModel(this.base, bakedTextureGetter);
        VariableModelBaked bakedModel = new VariableModelBaked(baseModel);
        for (IVariableModelProvider<? extends IVariableModelProvider.IBakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            bakedModel.setSubModels(provider, provider.bakeOverlayModels(state, format, bakedTextureGetter));
        }
        return bakedModel;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

