/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.block.property.UnlistedProperty;
import org.cyclops.cyclopscore.client.icon.Icon;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.integrateddynamics.api.block.IDynamicLight;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.collidable.CollidableComponentCableCenter;
import org.cyclops.integrateddynamics.block.collidable.CollidableComponentCableConnections;
import org.cyclops.integrateddynamics.block.collidable.CollidableComponentFacade;
import org.cyclops.integrateddynamics.block.collidable.CollidableComponentParts;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.block.CollidableComponent;
import org.cyclops.integrateddynamics.core.block.ICollidable;
import org.cyclops.integrateddynamics.core.block.ICollidableParent;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class BlockCable
extends ConfigurableBlockContainer
implements ICollidable<EnumFacing>,
ICollidableParent {
    public static final float BLOCK_HARDNESS = 3.0f;
    public static final Material BLOCK_MATERIAL = Material.field_151592_s;
    @BlockProperty
    public static final IUnlistedProperty<Boolean> REALCABLE = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)"realcable"));
    @BlockProperty
    public static final IUnlistedProperty<Boolean>[] CONNECTED = new IUnlistedProperty[6];
    @BlockProperty
    public static final IUnlistedProperty<PartRenderPosition>[] PART_RENDERPOSITIONS = new IUnlistedProperty[6];
    @BlockProperty
    public static final IUnlistedProperty<Optional> FACADE = new UnlistedProperty("facade", Optional.class);
    @BlockProperty
    public static final IUnlistedProperty<IPartContainer> PARTCONTAINER;
    @BlockProperty
    public static final IUnlistedProperty<IRenderState> RENDERSTATE;
    public static final AxisAlignedBB CABLE_CENTER_BOUNDINGBOX;
    private static final EnumFacingMap<AxisAlignedBB> CABLE_SIDE_BOUNDINGBOXES;
    private static final List<ICollidable.IComponent<EnumFacing, BlockCable>> COLLIDABLE_COMPONENTS;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> FACADE_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> CABLECENTER_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> CABLECONNECTIONS_COMPONENT;
    private static final ICollidable.IComponent<EnumFacing, BlockCable> PARTS_COMPONENT;
    private ICollidable collidableComponent = new CollidableComponent(this, COLLIDABLE_COMPONENTS);
    private static BlockCable _instance;
    public static boolean IS_MCMP_CONVERTING;
    @SideOnly(value=Side.CLIENT)
    @Icon(location="blocks/cable")
    public TextureAtlasSprite texture;
    private boolean disableCollisionBox = false;

    public static BlockCable getInstance() {
        return _instance;
    }

    public BlockCable(ExtendedConfig eConfig) {
        super(eConfig, BLOCK_MATERIAL, TileMultipartTicking.class);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185852_e);
        if (MinecraftHelpers.isClientSide()) {
            eConfig.getMod().getIconProvider().registerIconHolderObject((Object)this);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null && state.func_177230_c() == this) {
            return tile.getConnectionState();
        }
        return this.func_176223_P();
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos, EntityPlayer player) {
        CableHelpers.onCableRemoving(world, pos, true);
        super.onPreBlockDestroyed(world, pos);
    }

    protected void onPreBlockDestroyed(World world, BlockPos pos) {
        CableHelpers.onCableRemoving(world, pos, false);
        super.onPreBlockDestroyed(world, pos);
    }

    protected void onPostBlockDestroyed(World world, BlockPos pos) {
        super.onPostBlockDestroyed(world, pos);
        if (!IS_MCMP_CONVERTING) {
            CableHelpers.onCableRemoved(world, pos);
        }
        IS_MCMP_CONVERTING = false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        return Lists.newArrayList();
    }

    public boolean removedByPlayer(IBlockState blockState, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null && rayTraceResult.getCollisionType() != null && rayTraceResult.getCollisionType().destroy(world, pos, rayTraceResult.getPositionHit(), player)) {
            return true;
        }
        return rayTraceResult != null && super.removedByPlayer(blockState, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ICollidable.RayTraceResult rayTraceResult;
        TileMultipartTicking tile = (TileMultipartTicking)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)pos, TileMultipartTicking.class);
        if (tile != null && (rayTraceResult = this.doRayTrace(world, pos, player)) != null) {
            EnumFacing positionHit = (EnumFacing)rayTraceResult.getPositionHit();
            if (rayTraceResult.getCollisionType() == FACADE_COMPONENT) {
                if (WrenchHelpers.isWrench(player, heldItem, world, pos, side) && player.func_70093_af()) {
                    if (!world.field_72995_K) {
                        FACADE_COMPONENT.destroy(world, pos, side, player);
                        world.func_175685_c(pos, (Block)this);
                    }
                    return true;
                }
                return false;
            }
            if (rayTraceResult.getCollisionType() == PARTS_COMPONENT) {
                if (WrenchHelpers.isWrench(player, heldItem, world, pos, side) && player.func_70093_af()) {
                    if (!world.field_72995_K) {
                        PARTS_COMPONENT.destroy(world, pos, (EnumFacing)rayTraceResult.getPositionHit(), player);
                        ItemBlockCable.playBreakSound(world, pos, BlockCable.getInstance().func_176223_P());
                    }
                    return true;
                }
                if (CableHelpers.isNoFakeCable((IBlockAccess)world, pos)) {
                    IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, pos);
                    return partContainer.getPart(positionHit).onPartActivated(world, pos, partContainer.getPartState(positionHit), player, hand, heldItem, positionHit, hitX, hitY, hitZ);
                }
            } else if ((rayTraceResult.getCollisionType() == CABLECONNECTIONS_COMPONENT || rayTraceResult.getCollisionType() == CABLECENTER_COMPONENT) && CableHelpers.onCableActivated(world, pos, state, player, heldItem, side, rayTraceResult.getCollisionType() == CABLECENTER_COMPONENT ? null : (EnumFacing)rayTraceResult.getPositionHit())) {
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        CableHelpers.onCableAdded(world, pos, placer);
    }

    public boolean saveNBTToDroppedItem() {
        return false;
    }

    public boolean isDropBlockItem(IBlockAccess world, BlockPos pos, IBlockState blockState, int fortune) {
        return CableHelpers.isNoFakeCable(world, pos);
    }

    public ItemStack getPickBlock(IBlockState blockState, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ICollidable.RayTraceResult rayTraceResult = this.doRayTrace(world, pos, player);
        if (rayTraceResult != null) {
            EnumFacing positionHit = (EnumFacing)rayTraceResult.getPositionHit();
            return rayTraceResult.getCollisionType().getPickBlock(world, pos, positionHit);
        }
        return this.func_185473_a(world, pos, blockState);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, world, pos, neighborBlock);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock);
    }

    public AxisAlignedBB getCableBoundingBox(EnumFacing side) {
        if (side == null) {
            return CABLE_CENTER_BOUNDINGBOX;
        }
        return (AxisAlignedBB)CABLE_SIDE_BOUNDINGBOXES.get((Object)side);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.disableCollisionBox) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return super.func_180646_a(blockState, worldIn, pos);
    }

    public int getLightOpacity(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return CableHelpers.hasFacade(world, pos) && !CableHelpers.isLightTransparent(world, pos) ? 255 : 0;
    }

    public EnumBlockRenderType func_149645_b(IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel createDynamicModel() {
        return new CableModel();
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return super.doesSideBlockRendering(state, world, pos, face) || CableHelpers.hasFacade(world, pos) && CableHelpers.getFacade(world, pos).func_185914_p();
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean isNormalCube(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState blockState, World world, RayTraceResult target, ParticleManager particleManager) {
        BlockPos blockPos = target.func_178782_a();
        if (CableHelpers.hasFacade((IBlockAccess)world, blockPos)) {
            IBlockState facadeState = CableHelpers.getFacade((IBlockAccess)world, blockPos);
            RenderHelpers.addBlockHitEffects((ParticleManager)particleManager, (World)world, (IBlockState)facadeState, (BlockPos)blockPos, (EnumFacing)target.field_178784_b);
            return true;
        }
        return super.addHitEffects(blockState, world, target, particleManager);
    }

    public boolean isSideSolid(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (CableHelpers.hasFacade(world, pos)) {
            return true;
        }
        IPartContainer partContainer = PartHelpers.getPartContainer(world, pos);
        if (partContainer != null && partContainer.hasPart(side)) {
            IPartType partType = partContainer.getPart(side);
            return partType.isSolid(partContainer.getPartState(side));
        }
        return super.isSideSolid(blockState, world, pos, side);
    }

    public boolean canRenderInLayer(IBlockState blockState, BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxParent(IBlockState blockState, World worldIn, BlockPos pos) {
        return super.func_180640_a(blockState, worldIn, pos);
    }

    @Override
    public RayTraceResult rayTraceParent(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        return super.func_185503_a(pos, start, end, boundingBox);
    }

    public boolean func_149744_f(IBlockState blockState) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            for (EnumFacing dummySide : EnumFacing.field_82609_l) {
                IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)dummySide, DynamicRedstoneConfig.CAPABILITY);
                if (dynamicRedstone == null || dynamicRedstone.getRedstoneLevel() < 0 && !dynamicRedstone.isAllowRedstoneInput()) continue;
                return true;
            }
            return false;
        }
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY);
        return dynamicRedstone != null && (dynamicRedstone.getRedstoneLevel() >= 0 || dynamicRedstone.isAllowRedstoneInput());
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY);
        return dynamicRedstone != null && dynamicRedstone.isStrong() ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IDynamicRedstone dynamicRedstone = (IDynamicRedstone)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side.func_176734_d(), DynamicRedstoneConfig.CAPABILITY);
        return dynamicRedstone != null ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int getLightValue(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        int light = 0;
        for (EnumFacing side : EnumFacing.values()) {
            IDynamicLight dynamicLight = (IDynamicLight)TileHelpers.getCapability((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side, DynamicLightConfig.CAPABILITY);
            if (dynamicLight == null) continue;
            light = Math.max(light, dynamicLight.getLightLevel());
        }
        return light;
    }

    public void setDisableCollisionBox(boolean disableCollisionBox) {
        this.disableCollisionBox = disableCollisionBox;
    }

    @Override
    public Block getBlock() {
        return this.collidableComponent.getBlock();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List list, Entity collidingEntity) {
        this.collidableComponent.addCollisionBoxToList(state, world, pos, mask, list, collidingEntity);
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.collidableComponent.getSelectedBoundingBox(blockState, worldIn, pos);
    }

    @Override
    public ICollidable.RayTraceResult doRayTrace(World world, BlockPos pos, EntityPlayer player) {
        return this.collidableComponent.doRayTrace(world, pos, player);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        return this.collidableComponent.collisionRayTrace(blockState, world, pos, origin, direction);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.collidableComponent.getBoundingBox(state, world, pos);
    }

    static {
        for (EnumFacing side : EnumFacing.values()) {
            BlockCable.CONNECTED[side.ordinal()] = Properties.toUnlisted((IProperty)PropertyBool.func_177716_a((String)("connect-" + side.func_176610_l())));
            BlockCable.PART_RENDERPOSITIONS[side.ordinal()] = new UnlistedProperty("partRenderPosition-" + side.func_176610_l(), PartRenderPosition.class);
        }
        PARTCONTAINER = new UnlistedProperty("partcontainer", IPartContainer.class);
        RENDERSTATE = new UnlistedProperty("renderState", IRenderState.class);
        CABLE_CENTER_BOUNDINGBOX = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
        CABLE_SIDE_BOUNDINGBOXES = EnumFacingMap.forAllValues((Object)new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), (Object)new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), (Object)new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), (Object)new AxisAlignedBB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0), (Object)new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), (Object)new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
        COLLIDABLE_COMPONENTS = Lists.newArrayList();
        FACADE_COMPONENT = new CollidableComponentFacade();
        CABLECENTER_COMPONENT = new CollidableComponentCableCenter();
        CABLECONNECTIONS_COMPONENT = new CollidableComponentCableConnections();
        PARTS_COMPONENT = new CollidableComponentParts();
        COLLIDABLE_COMPONENTS.add(FACADE_COMPONENT);
        COLLIDABLE_COMPONENTS.add(CABLECENTER_COMPONENT);
        COLLIDABLE_COMPONENTS.add(CABLECONNECTIONS_COMPONENT);
        COLLIDABLE_COMPONENTS.add(PARTS_COMPONENT);
        _instance = null;
        IS_MCMP_CONVERTING = false;
    }
}

