/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.gui.data;

import com.mojang.realmsclient.gui.ChatFormatting;
import guichaguri.betterfps.BetterFpsConfig;
import guichaguri.betterfps.BetterFpsHelper;
import guichaguri.betterfps.gui.GuiConfigOption;
import guichaguri.betterfps.gui.data.AlgorithmAction;
import guichaguri.betterfps.gui.data.UpdateCheckAction;
import guichaguri.betterfps.transformers.Conditions;
import guichaguri.betterfps.tweaker.Mappings;
import java.util.List;

public class OptionManager {
    public static void addButtons(List<GuiConfigOption> buttons) {
        BetterFpsConfig config = BetterFpsHelper.getConfig();
        Boolean[] boolMap = new Boolean[]{true, false};
        String[] enabledNames = new String[]{bxl.a((String)"betterfps.options.on", (Object[])new Object[0]), bxl.a((String)"betterfps.options.off", (Object[])new Object[0])};
        String[] fancyFast = new String[]{bxl.a((String)"betterfps.options.fancy", (Object[])new Object[0]), bxl.a((String)"betterfps.options.fast", (Object[])new Object[0])};
        GuiConfigOption<BetterFpsConfig.AlgorithmType> algorithm = new GuiConfigOption<BetterFpsConfig.AlgorithmType>(0, "betterfps.options.algorithm.title");
        algorithm.add(BetterFpsConfig.AlgorithmType.VANILLA, "betterfps.options.algorithm.vanilla");
        algorithm.add(BetterFpsConfig.AlgorithmType.RIVENS, "betterfps.options.algorithm.rivens");
        algorithm.add(BetterFpsConfig.AlgorithmType.RIVENS_FULL, "betterfps.options.algorithm.rivens-full");
        algorithm.add(BetterFpsConfig.AlgorithmType.RIVENS_HALF, "betterfps.options.algorithm.rivens-half");
        algorithm.add(BetterFpsConfig.AlgorithmType.TAYLORS, "betterfps.options.algorithm.taylors");
        algorithm.add(BetterFpsConfig.AlgorithmType.JAVA, "betterfps.options.algorithm.java");
        algorithm.add(BetterFpsConfig.AlgorithmType.RANDOM, "betterfps.options.algorithm.random");
        algorithm.setRestart(Conditions.isPatched(Mappings.C_MathHelper));
        algorithm.setWide(true);
        algorithm.setDefaults(BetterFpsConfig.AlgorithmType.VANILLA, BetterFpsConfig.AlgorithmType.RIVENS_HALF, config.algorithm);
        algorithm.setDescription(bxl.a((String)"betterfps.options.algorithm.desc", (Object[])new Object[0]), ChatFormatting.YELLOW + bxl.a((String)"betterfps.options.algorithm.action", (Object[])new Object[0]));
        algorithm.setShiftClick(new AlgorithmAction(algorithm));
        buttons.add(algorithm);
        GuiConfigOption<Boolean> updateChecker = new GuiConfigOption<Boolean>(1, "betterfps.options.updatechecker.title");
        updateChecker.set(boolMap, enabledNames);
        updateChecker.setDefaults(true, true, config.updateChecker);
        updateChecker.setDescription(bxl.a((String)"betterfps.options.updatechecker.desc", (Object[])new Object[0]), ChatFormatting.YELLOW + bxl.a((String)"betterfps.options.updatechecker.action", (Object[])new Object[0]));
        updateChecker.setShiftClick(new UpdateCheckAction());
        buttons.add(updateChecker);
        GuiConfigOption<Boolean> allocMemory = new GuiConfigOption<Boolean>(2, "betterfps.options.allocmemory.title");
        allocMemory.set(boolMap, enabledNames);
        allocMemory.setRestart(Conditions.isPatched(Mappings.C_Minecraft));
        allocMemory.setDefaults(true, false, config.preallocateMemory);
        allocMemory.setDescription(bxl.a((String)"betterfps.options.allocmemory.desc", (Object[])new Object[0]));
        buttons.add(allocMemory);
        GuiConfigOption<Boolean> fog = new GuiConfigOption<Boolean>(3, "betterfps.options.fog.title");
        fog.set(boolMap, fancyFast);
        fog.setRestart(Conditions.isPatched(Mappings.C_EntityRenderer));
        fog.setDefaults(true, true, config.fog);
        fog.setDescription(bxl.a((String)"betterfps.options.fog.desc", (Object[])new Object[0]));
        buttons.add(fog);
        GuiConfigOption<Boolean> beam = new GuiConfigOption<Boolean>(4, "betterfps.options.beaconbeam.title");
        beam.set(boolMap, fancyFast);
        beam.setRestart(Conditions.isPatched(Mappings.C_TileEntityBeaconRenderer));
        beam.setDefaults(true, true, config.beaconBeam);
        beam.setDescription(bxl.a((String)"betterfps.options.beaconbeam.desc", (Object[])new Object[0]));
        buttons.add(beam);
        GuiConfigOption<Boolean> hopper = new GuiConfigOption<Boolean>(5, "betterfps.options.hopper.title");
        hopper.set(boolMap, enabledNames);
        hopper.setRestart(Conditions.isPatched(Mappings.C_TileEntityHopper));
        hopper.setDefaults(false, true, config.fastHopper);
        hopper.setDescription(bxl.a((String)"betterfps.options.hopper.desc", (Object[])new Object[0]));
        hopper.setRestart(true);
        buttons.add(hopper);
        GuiConfigOption<Boolean> beacon = new GuiConfigOption<Boolean>(6, "betterfps.options.beacon.title");
        beacon.set(boolMap, enabledNames);
        beacon.setRestart(Conditions.isPatched(Mappings.C_TileEntityBeacon));
        beacon.setDefaults(false, true, config.fastBeacon);
        beacon.setDescription(bxl.a((String)"betterfps.options.beacon.desc", (Object[])new Object[0]));
        buttons.add(beacon);
        GuiConfigOption<Integer> search = new GuiConfigOption<Integer>(7, "betterfps.options.creativesearch.title");
        search.add(0, "betterfps.options.off");
        search.add(1, "betterfps.options.on");
        search.add(2, "betterfps.options.async");
        search.setDefaults(0, 2, !config.fastSearch ? 0 : (!config.asyncSearch ? 1 : 2));
        search.setDescription(bxl.a((String)"betterfps.options.creativesearch.desc", (Object[])new Object[0]));
        buttons.add(search);
    }

    public static boolean store(List<GuiConfigOption> buttons) {
        BetterFpsConfig config = BetterFpsHelper.getConfig();
        boolean restart = false;
        config.algorithm = OptionManager.getButtonValue(buttons, 0, BetterFpsConfig.AlgorithmType.VANILLA);
        config.updateChecker = OptionManager.getButtonValue(buttons, 1);
        config.preallocateMemory = OptionManager.getButtonValue(buttons, 2);
        config.fog = OptionManager.getButtonValue(buttons, 3);
        config.beaconBeam = OptionManager.getButtonValue(buttons, 4);
        config.fastHopper = OptionManager.getButtonValue(buttons, 5);
        config.fastBeacon = OptionManager.getButtonValue(buttons, 6);
        int search = OptionManager.getButtonValue(buttons, 7, 0);
        if (config.fastSearch != (search != 0)) {
            restart = Conditions.isPatched(Mappings.C_GuiContainerCreative);
        }
        config.fastSearch = search != 0;
        config.asyncSearch = search == 2;
        for (GuiConfigOption button : buttons) {
            if (!button.shouldRestart()) continue;
            return true;
        }
        return restart;
    }

    private static boolean getButtonValue(List<GuiConfigOption> buttons, int id) {
        return OptionManager.getButtonValue(buttons, id, true);
    }

    private static <T> T getButtonValue(List<GuiConfigOption> buttons, int id, T def) {
        for (GuiConfigOption button : buttons) {
            if (button.k != id) continue;
            return button.getValue();
        }
        return def;
    }
}

