/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.networking;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.wyldmods.simpleachievements.common.NBTUtils;
import org.wyldmods.simpleachievements.common.TileEntityAchievementStand;
import org.wyldmods.simpleachievements.common.data.DataManager;

public class MessageAchievement
implements IMessage,
IMessageHandler<MessageAchievement, IMessage> {
    private static final MessageType[] VALUES = MessageType.values();
    private int data;
    private boolean state;
    private BlockPos pos;
    private MessageType type;

    public MessageAchievement(int id, EnumHand hand) {
        this(id, hand == EnumHand.MAIN_HAND, new BlockPos(0, 0, 0), MessageType.PAGE);
    }

    public MessageAchievement(int id, boolean state) {
        this(id, state, new BlockPos(0, 0, 0), MessageType.TOGGLE);
    }

    public MessageAchievement(int page, BlockPos pos) {
        this(page, false, pos, MessageType.TILE);
    }

    private MessageAchievement(int id, boolean state, BlockPos pos, MessageType type) {
        this.data = id;
        this.state = state;
        this.pos = pos;
        this.type = type;
    }

    public void fromBytes(ByteBuf buf) {
        this.data = buf.readInt();
        this.state = buf.readBoolean();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.type = VALUES[buf.readInt()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data);
        buf.writeBoolean(this.state);
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.type.ordinal());
    }

    public IMessage onMessage(final MessageAchievement message, final MessageContext ctx) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                switch (message.type) {
                    case PAGE: {
                        NBTUtils.getTag(player.func_184586_b(message.state ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND)).func_74768_a("sa:page", message.data);
                        break;
                    }
                    case TILE: {
                        TileEntity te = player.field_70170_p.func_175625_s(message.pos);
                        if (!(te instanceof TileEntityAchievementStand)) break;
                        ((TileEntityAchievementStand)te).setPage(message.data);
                        IBlockState state = player.field_70170_p.func_180495_p(message.pos);
                        player.field_70170_p.func_184138_a(message.pos, state, state, 8);
                        break;
                    }
                    case TOGGLE: {
                        DataManager.INSTANCE.getHandlerFor((String)player.func_70005_c_()).getAchievement((int)((MessageAchievement)message).data).state = message.state;
                    }
                }
            }
        });
        return null;
    }

    public MessageAchievement() {
    }

    public static enum MessageType {
        TOGGLE,
        PAGE,
        TILE;

    }
}

