/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements.common.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.wyldmods.simpleachievements.SimpleAchievements;
import org.wyldmods.simpleachievements.client.gui.Offset;
import org.wyldmods.simpleachievements.common.config.ConfigHandler;
import org.wyldmods.simpleachievements.common.data.DataHandler;
import org.wyldmods.simpleachievements.common.data.Element;
import org.wyldmods.simpleachievements.common.data.Formatting;
import org.wyldmods.simpleachievements.common.networking.MessageSendAchievements;
import org.wyldmods.simpleachievements.common.networking.PacketHandlerSA;

public class DataManager {
    private static boolean noSave = false;
    public static final DataManager INSTANCE = new DataManager();
    private Map<String, DataHandler> map = new HashMap<String, DataHandler>();
    private Map<Integer, Formatting> formats = new HashMap<Integer, Formatting>();
    private Map<String, Offset> specialUsers = new HashMap<String, Offset>();
    private static Gson dataReader = new GsonBuilder().registerTypeAdapter(Map.class, (Object)new Reader()).create();
    private File saveDir;
    private File saveFile;
    private static final Offset defaultOffset = new Offset(0, 0);

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        if (!load.getWorld().field_72995_K && load.getWorld().field_73011_w.getDimension() == 0) {
            this.load();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save save) {
        if (!save.getWorld().field_72995_K && save.getWorld().field_73011_w.getDimension() == 0) {
            this.save();
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null && !player.field_70170_p.field_72995_K) {
            SimpleAchievements.logger.info("Sending " + player.func_70005_c_() + " achievement list.");
            INSTANCE.checkMap(player.func_70005_c_());
            PacketHandlerSA.INSTANCE.sendTo((IMessage)new MessageSendAchievements(this.getHandlerFor(player.func_70005_c_()).getAchievementList()), (EntityPlayerMP)player);
        }
    }

    private DataManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void initFormatting() {
        String s = "";
        try {
            Scanner scan = new Scanner(SimpleAchievements.divConfig);
            while (scan.hasNextLine()) {
                s = s + scan.nextLine() + "\n";
            }
            scan.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.formats = (Map)new Gson().fromJson(s, new TypeToken<Map<Integer, Formatting>>(){}.getType());
        if (this.formats == null) {
            this.formats = new HashMap<Integer, Formatting>();
            this.formats.put(0, new Formatting());
        }
    }

    public void initSpecialUsers() throws IOException {
        this.specialUsers = (Map)new Gson().fromJson((java.io.Reader)new InputStreamReader(SimpleAchievements.class.getResourceAsStream("/assets/simpleachievements/misc/specialUsers.json")), new TypeToken<Map<String, Offset>>(){}.getType());
        if (this.specialUsers == null) {
            this.specialUsers = new HashMap<String, Offset>();
        }
    }

    public void load() {
        noSave = false;
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory().getAbsolutePath() + "/" + "SimpleAchievements");
        this.saveDir.mkdirs();
        this.saveFile = new File(this.saveDir.getAbsolutePath() + "/achievements.json");
        try {
            this.initSpecialUsers();
            if (this.saveFile.createNewFile()) {
                return;
            }
            this.map = DataManager.loadMap(this.saveFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (!noSave) {
            DataManager.saveMap(this.saveFile, this, this.map);
        }
    }

    public void toggleAchievement(String username, int id) {
        this.checkMap(username);
        this.map.get(username).toggleAchievement(id);
    }

    public DataHandler getHandlerFor(String username) {
        this.checkMap(username);
        return this.map.get(username);
    }

    public void checkMap(String username) {
        if (!this.map.containsKey(username)) {
            this.map.put(username, new DataHandler());
        }
    }

    private static Map<String, DataHandler> loadMap(File file) throws FileNotFoundException {
        String json = "";
        Scanner scan = new Scanner(file);
        while (scan.hasNextLine()) {
            json = json + scan.nextLine() + "\n";
        }
        scan.close();
        Map ret = (Map)dataReader.fromJson(json, new TypeToken<Map<String, DataHandler>>(){}.getType());
        return ret == null ? new HashMap() : ret;
    }

    private static void saveMap(File file, DataManager instance, Map<String, DataHandler> map) {
        String json = dataReader.toJson(map, new TypeToken<Map<String, DataHandler>>(){}.getType());
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(json);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            SimpleAchievements.logger.severe("Could not save achievements file!");
        }
    }

    public void changeMap(EntityPlayer player, DataHandler handler) {
        this.map.put(player.func_70005_c_(), handler);
    }

    public Formatting getFormat(int div) {
        return this.formats.get(div);
    }

    public Offset getOffsetFor(String username) {
        Offset offset = this.specialUsers.get(username);
        return offset == null ? defaultOffset : offset;
    }

    public void flush() {
        noSave = true;
        this.map.clear();
        this.formats.clear();
        this.specialUsers.clear();
        this.saveFile.delete();
        ConfigHandler.flush();
        this.load();
    }

    private static class Reader
    implements JsonSerializer<Map<String, DataHandler>>,
    JsonDeserializer<Map<String, DataHandler>> {
        private Reader() {
        }

        public JsonElement serialize(Map<String, DataHandler> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject root = new JsonObject();
            for (Map.Entry<String, DataHandler> e : src.entrySet()) {
                JsonArray arr = new JsonArray();
                for (Element ele : e.getValue().getAchievementArr()) {
                    JsonObject val = new JsonObject();
                    val.addProperty(ele.text, Boolean.valueOf(ele.state));
                    arr.add((JsonElement)val);
                }
                root.add(e.getKey(), (JsonElement)arr);
            }
            return root;
        }

        public Map<String, DataHandler> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            HashMap ret = Maps.newHashMap();
            for (Map.Entry e : root.entrySet()) {
                JsonArray arr = ((JsonElement)e.getValue()).getAsJsonArray();
                ArrayList elements = Lists.newArrayList();
                for (int i = 0; i < arr.size(); ++i) {
                    JsonObject val = arr.get(i).getAsJsonObject();
                    Map.Entry prop = (Map.Entry)val.entrySet().iterator().next();
                    Element def = new Element(ConfigHandler.idMap.get(prop.getKey()));
                    if (def.text == null) continue;
                    def.setState(((JsonElement)prop.getValue()).getAsBoolean());
                    elements.add(def);
                }
                ret.put(e.getKey(), new DataHandler(elements));
            }
            return ret;
        }
    }
}

