/*
 * Decompiled with CFR 0.152.
 */
package org.wyldmods.simpleachievements;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.wyldmods.simpleachievements.common.BlockAchievementStand;
import org.wyldmods.simpleachievements.common.CommonProxy;
import org.wyldmods.simpleachievements.common.ItemAchievementBook;
import org.wyldmods.simpleachievements.common.ItemBlockAchievementStand;
import org.wyldmods.simpleachievements.common.TileEntityAchievementStand;
import org.wyldmods.simpleachievements.common.config.ConfigHandler;
import org.wyldmods.simpleachievements.common.data.CommandFlush;
import org.wyldmods.simpleachievements.common.data.DataManager;
import org.wyldmods.simpleachievements.common.networking.PacketHandlerSA;

@Mod(modid="SimpleAchievements", name="Simple Achievements", version="MC1.9.4-1.2.2-28", acceptedMinecraftVersions="[1.9.4]")
public class SimpleAchievements {
    public static final String MODID = "SimpleAchievements";
    public static final String NAME = "Simple Achievements";
    public static final String VERSION = "MC1.9.4-1.2.2-28";
    public static ArrayList<String> achievements = null;
    @Mod.Instance(value="SimpleAchievements")
    public static SimpleAchievements instance;
    @SidedProxy(clientSide="org.wyldmods.simpleachievements.client.ClientProxy", serverSide="org.wyldmods.simpleachievements.common.CommonProxy")
    public static CommonProxy proxy;
    public static File configDir;
    public static File achievementConfig;
    public static File divConfig;
    public static Block achievementStand;
    public static Block decorationBlock;
    public static Item achievementBook;
    public static int bookWidth;
    public static int bookHeight;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        configDir = new File(event.getSuggestedConfigurationFile().getParentFile().getAbsolutePath() + "/" + MODID);
        achievementConfig = new File(configDir.getAbsolutePath() + "/achievementList.txt");
        divConfig = new File(configDir.getAbsolutePath() + "/divConfig.json");
        try {
            this.create(achievementConfig, divConfig);
            DataManager.INSTANCE.initFormatting();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        PacketHandlerSA.init();
        achievementStand = new BlockAchievementStand();
        GameRegistry.register((IForgeRegistryEntry)achievementStand);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockAchievementStand(achievementStand).setRegistryName(achievementStand.getRegistryName()));
        GameRegistry.registerTileEntity(TileEntityAchievementStand.class, (String)"sa.tileAchievementStand");
        decorationBlock = (Block)new Block(Material.field_151575_d){
            {
                this.func_149672_a(SoundType.field_185848_a);
            }
        }.func_149647_a(CreativeTabs.field_78031_c).func_149711_c(1.5f).func_149663_c("sa.decorativeWood").setRegistryName("decoration_block");
        GameRegistry.register((IForgeRegistryEntry)decorationBlock);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(decorationBlock).setRegistryName(decorationBlock.getRegistryName()));
        achievementBook = new ItemAchievementBook();
        GameRegistry.register((IForgeRegistryEntry)achievementBook.setRegistryName("achievement_book"));
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ItemStack purpleDye = new ItemStack(Items.field_151100_aR, 1, 5);
        GameRegistry.addRecipe((ItemStack)new ItemStack(achievementStand), (Object[])new Object[]{"dbd", "www", "www", Character.valueOf('d'), purpleDye, Character.valueOf('b'), Items.field_151122_aG, Character.valueOf('w'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(achievementStand), (Object[])new Object[]{" b ", "www", "www", Character.valueOf('b'), achievementBook, Character.valueOf('w'), Blocks.field_150344_f});
        GameRegistry.addRecipe((ItemStack)new ItemStack(achievementBook), (Object[])new Object[]{"dbd", Character.valueOf('d'), purpleDye, Character.valueOf('b'), Items.field_151122_aG});
        GameRegistry.addRecipe((ItemStack)new ItemStack(decorationBlock, 5), (Object[])new Object[]{"www", "wlw", "www", Character.valueOf('w'), Blocks.field_150344_f, Character.valueOf('l'), Items.field_151116_aA});
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        ICommandManager server = event.getServer().func_71187_D();
        ((ServerCommandManager)server).func_71560_a((ICommand)new CommandFlush());
    }

    private void create(File ... files) throws IOException {
        for (File file : files) {
            if (file.exists()) continue;
            file.getParentFile().mkdirs();
            this.copyFromJar(file);
            logger.info("Successfully loaded default file: " + file.getName());
        }
    }

    private void copyFromJar(File file) throws IOException {
        String filename = file.getName();
        URL url = SimpleAchievements.class.getResource("/assets/simpleachievements/misc/" + filename);
        FileUtils.copyURLToFile((URL)url, (File)file);
    }

    public static int toHex(int r, int g, int b) {
        int hex = 0;
        hex |= r << 16;
        hex |= g << 8;
        return hex |= b;
    }

    public static String getPersistentTagName() {
        return "SimpleAchievementsachievements";
    }

    static {
        bookWidth = 417;
        bookHeight = 245;
        logger = Logger.getLogger(MODID);
    }
}

