/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.grid;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.grid.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.IItemGridHandler;
import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.gui.grid.GridFilter;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerGridFilterInGrid;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import com.raoulvdberge.refinedstorage.network.MessageWirelessGridSettingsUpdate;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WirelessGrid
implements IGrid {
    private ItemStack stack;
    private int controllerDimension;
    private BlockPos controller;
    private int viewType;
    private int sortingType;
    private int sortingDirection;
    private int searchBoxMode;
    private List<GridFilter> filteredItems = new ArrayList<GridFilter>();
    private ItemHandlerGridFilterInGrid filter = new ItemHandlerGridFilterInGrid(this.filteredItems){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                if (!WirelessGrid.this.stack.func_77942_o()) {
                    WirelessGrid.this.stack.func_77982_d(new NBTTagCompound());
                }
                RSUtils.writeItems((IItemHandler)this, slot, WirelessGrid.this.stack.func_77978_p());
            }
        }
    };

    public WirelessGrid(int controllerDimension, ItemStack stack) {
        this.controllerDimension = controllerDimension;
        this.controller = new BlockPos(ItemWirelessGrid.getX(stack), ItemWirelessGrid.getY(stack), ItemWirelessGrid.getZ(stack));
        this.stack = stack;
        this.viewType = ItemWirelessGrid.getViewType(stack);
        this.sortingType = ItemWirelessGrid.getSortingType(stack);
        this.sortingDirection = ItemWirelessGrid.getSortingDirection(stack);
        this.searchBoxMode = ItemWirelessGrid.getSearchBoxMode(stack);
        if (stack.func_77942_o()) {
            for (int i = 0; i < 4; ++i) {
                RSUtils.readItems((IItemHandlerModifiable)this.filter, i, stack.func_77978_p());
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public EnumGridType getType() {
        return EnumGridType.NORMAL;
    }

    @Override
    public BlockPos getNetworkPosition() {
        return this.controller;
    }

    @Override
    public IItemGridHandler getItemHandler() {
        TileController controller = this.getController();
        return controller != null ? controller.getItemGridHandler() : null;
    }

    @Override
    public IFluidGridHandler getFluidHandler() {
        return null;
    }

    @Override
    public String getGuiTitle() {
        return "gui.refinedstorage:wireless_grid";
    }

    @Override
    public int getViewType() {
        return this.viewType;
    }

    @Override
    public int getSortingType() {
        return this.sortingType;
    }

    @Override
    public int getSortingDirection() {
        return this.sortingDirection;
    }

    @Override
    public int getSearchBoxMode() {
        return this.searchBoxMode;
    }

    @Override
    public void onViewTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(type, this.getSortingDirection(), this.getSortingType(), this.getSearchBoxMode()));
        this.viewType = type;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSortingTypeChanged(int type) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), type, this.getSearchBoxMode()));
        this.sortingType = type;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSortingDirectionChanged(int direction) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), direction, this.getSortingType(), this.getSearchBoxMode()));
        this.sortingDirection = direction;
        GuiGrid.markForSorting();
    }

    @Override
    public void onSearchBoxModeChanged(int searchBoxMode) {
        RS.INSTANCE.network.sendToServer((IMessage)new MessageWirelessGridSettingsUpdate(this.getViewType(), this.getSortingDirection(), this.getSortingType(), searchBoxMode));
        this.searchBoxMode = searchBoxMode;
    }

    @Override
    public List<GridFilter> getFilters() {
        return this.filteredItems;
    }

    @Override
    public ItemHandlerBasic getFilter() {
        return this.filter;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeConfig() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    public void onClose(EntityPlayer player) {
        TileController controller = this.getController();
        if (controller != null) {
            controller.getNetworkItemHandler().onClose(player);
        }
    }

    private TileController getController() {
        WorldServer world = DimensionManager.getWorld((int)this.controllerDimension);
        if (world != null) {
            TileEntity tile = world.func_175625_s(this.controller);
            return tile instanceof TileController ? (TileController)tile : null;
        }
        return null;
    }
}

