/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile.externalstorage;

import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class ItemStorageExternal
implements IItemStorage {
    private List<ItemStack> cache;

    public abstract int getCapacity();

    public void detectChanges(INetworkMaster network) {
        int i;
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        if (this.cache == null) {
            this.cache = this.getStacks();
            return;
        }
        List newStacks = this.getStacks();
        for (i = 0; i < newStacks.size(); ++i) {
            ItemStack actual = (ItemStack)newStacks.get(i);
            if (i >= this.cache.size()) {
                if (actual == null) continue;
                network.getItemStorageCache().add(actual, actual.field_77994_a, false);
                continue;
            }
            ItemStack cached = this.cache.get(i);
            if (cached != null && actual == null) {
                network.getItemStorageCache().remove(cached, cached.field_77994_a);
                continue;
            }
            if (cached == null && actual != null) {
                network.getItemStorageCache().add(actual, actual.field_77994_a, false);
                continue;
            }
            if (cached == null && actual == null) continue;
            if (!API.instance().getComparer().isEqualNoQuantity(cached, actual)) {
                network.getItemStorageCache().remove(cached, cached.field_77994_a);
                network.getItemStorageCache().add(actual, actual.field_77994_a, false);
                continue;
            }
            if (cached.field_77994_a == actual.field_77994_a) continue;
            int delta = actual.field_77994_a - cached.field_77994_a;
            if (delta > 0) {
                network.getItemStorageCache().add(actual, delta, false);
                continue;
            }
            network.getItemStorageCache().remove(actual, Math.abs(delta));
        }
        if (this.cache.size() > newStacks.size()) {
            for (i = newStacks.size(); i < this.cache.size(); ++i) {
                if (this.cache.get(i) == null) continue;
                network.getItemStorageCache().remove(this.cache.get(i), this.cache.get((int)i).field_77994_a);
            }
        }
        this.cache = newStacks;
    }
}

