/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.tesla;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.tile.IReaderWriter;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.darkhax.tesla.api.implementation.BaseTeslaContainer;
import net.darkhax.tesla.capability.TeslaCapabilities;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.Capability;

public class ReaderWriterHandlerTesla
implements IReaderWriterHandler {
    public static final String ID = "tesla";
    private static final String NBT_CONTAINER = "Container";
    private BaseTeslaContainer container = new BaseTeslaContainer(4000L, 4000L, 4000L);
    private TeslaContainerReader containerReader = new TeslaContainerReader(this.container);
    private TeslaContainerWriter containerWriter = new TeslaContainerWriter(this.container);

    public ReaderWriterHandlerTesla(@Nullable NBTTagCompound tag) {
        if (tag != null && tag.func_74764_b(NBT_CONTAINER)) {
            this.container.deserializeNBT(tag.func_74775_l(NBT_CONTAINER));
        }
    }

    @Override
    public void update(IReaderWriterChannel channel) {
    }

    @Override
    public void onWriterDisabled(IWriter writer) {
    }

    @Override
    public boolean hasCapability(IReaderWriter readerWriter, Capability<?> capability) {
        if (readerWriter instanceof IReader) {
            return capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_CONSUMER;
        }
        if (readerWriter instanceof IWriter) {
            return capability == TeslaCapabilities.CAPABILITY_HOLDER || capability == TeslaCapabilities.CAPABILITY_PRODUCER;
        }
        return false;
    }

    @Override
    public <T> T getCapability(IReaderWriter readerWriter, Capability<T> capability) {
        if (readerWriter instanceof IReader || readerWriter instanceof IWriter) {
            if (capability == TeslaCapabilities.CAPABILITY_HOLDER) {
                return (T)this.container;
            }
            if (capability == TeslaCapabilities.CAPABILITY_CONSUMER && readerWriter instanceof IReader) {
                return (T)this.containerReader;
            }
            if (capability == TeslaCapabilities.CAPABILITY_PRODUCER && readerWriter instanceof IWriter) {
                return (T)this.containerWriter;
            }
        }
        return null;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a(NBT_CONTAINER, (NBTBase)this.container.serializeNBT());
        return tag;
    }

    @Override
    public String getId() {
        return ID;
    }

    private class TeslaContainerWriter
    implements ITeslaHolder,
    ITeslaProducer {
        private BaseTeslaContainer parent;

        public TeslaContainerWriter(BaseTeslaContainer parent) {
            this.parent = parent;
        }

        public long takePower(long power, boolean simulated) {
            return this.parent.takePower(power, simulated);
        }

        public long getStoredPower() {
            return this.parent.getStoredPower();
        }

        public long getCapacity() {
            return this.parent.getCapacity();
        }
    }

    private class TeslaContainerReader
    implements ITeslaHolder,
    ITeslaConsumer {
        private BaseTeslaContainer parent;

        public TeslaContainerReader(BaseTeslaContainer parent) {
            this.parent = parent;
        }

        public long givePower(long power, boolean simulated) {
            return this.parent.givePower(power, simulated);
        }

        public long getStoredPower() {
            return this.parent.getStoredPower();
        }

        public long getCapacity() {
            return this.parent.getCapacity();
        }
    }
}

