/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.sidebutton;

import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButton;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import net.minecraft.util.text.TextFormatting;

public class SideButtonGridSortingType
extends SideButton {
    private IGrid grid;

    public SideButtonGridSortingType(GuiBase gui, IGrid grid) {
        super(gui);
        this.grid = grid;
    }

    @Override
    public String getTooltip() {
        return TextFormatting.YELLOW + GuiBase.t("sidebutton.refinedstorage:grid.sorting.type", new Object[0]) + TextFormatting.RESET + "\n" + GuiBase.t("sidebutton.refinedstorage:grid.sorting.type." + this.grid.getSortingType(), new Object[0]);
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        this.gui.drawTexture(x, y, this.grid.getSortingType() * 16, 32, 16, 16);
    }

    @Override
    public void actionPerformed() {
        int type = this.grid.getSortingType();
        if (type == 0) {
            type = 1;
        } else if (type == 1) {
            type = this.grid.getType() == EnumGridType.FLUID ? 0 : 2;
        } else if (type == 2) {
            type = 0;
        }
        this.grid.onSortingTypeChanged(type);
    }
}

