/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container;

import com.raoulvdberge.refinedstorage.block.EnumGridType;
import com.raoulvdberge.refinedstorage.container.ContainerBase;
import com.raoulvdberge.refinedstorage.container.slot.SlotDisabled;
import com.raoulvdberge.refinedstorage.container.slot.SlotGridCrafting;
import com.raoulvdberge.refinedstorage.container.slot.SlotGridCraftingResult;
import com.raoulvdberge.refinedstorage.container.slot.SlotOutput;
import com.raoulvdberge.refinedstorage.container.slot.SlotSpecimenLegacy;
import com.raoulvdberge.refinedstorage.gui.grid.IGridDisplay;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.grid.IGrid;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.tile.grid.WirelessGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerGrid
extends ContainerBase {
    private IGrid grid;
    private IGridDisplay display;
    private SlotGridCraftingResult craftingResultSlot;
    private SlotDisabled patternResultSlot;

    public ContainerGrid(IGrid grid, IGridDisplay display, EntityPlayer player) {
        super(grid instanceof TileBase ? (TileBase)((Object)grid) : null, player);
        this.grid = grid;
        this.display = display;
        this.initSlots();
    }

    public void initSlots() {
        int i;
        int y;
        int x;
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        int headerAndSlots = this.display.getHeader() + this.display.getVisibleRows() * 18;
        this.addPlayerInventory(8, this.display.getYPlayerInventory());
        if (this.grid.getType() == EnumGridType.CRAFTING) {
            x = 26;
            y = headerAndSlots + 4;
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new SlotGridCrafting((IInventory)((TileGrid)this.grid).getMatrix(), i, x, y));
                x += 18;
                if ((i + 1) % 3 != 0) continue;
                y += 18;
                x = 26;
            }
            this.craftingResultSlot = new SlotGridCraftingResult(this, this.getPlayer(), (TileGrid)this.grid, 0, 134, headerAndSlots + 22);
            this.func_75146_a((Slot)this.craftingResultSlot);
        } else if (this.grid.getType() == EnumGridType.PATTERN) {
            x = 8;
            y = headerAndSlots + 4;
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new SlotSpecimenLegacy((IInventory)((TileGrid)this.grid).getMatrix(), i, x, y));
                x += 18;
                if ((i + 1) % 3 != 0) continue;
                y += 18;
                x = 8;
            }
            this.patternResultSlot = new SlotDisabled((IInventory)((TileGrid)this.grid).getResult(), 0, 116, headerAndSlots + 22);
            this.func_75146_a(this.patternResultSlot);
            this.func_75146_a((Slot)new SlotItemHandler(((TileGrid)this.grid).getPatterns(), 0, 152, headerAndSlots + 4));
            this.func_75146_a((Slot)new SlotOutput(((TileGrid)this.grid).getPatterns(), 1, 152, headerAndSlots + 40));
        }
        if (this.grid.getType() != EnumGridType.FLUID) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.grid.getFilter(), i2, 204, 6 + 18 * i2));
            }
        }
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public void sendCraftingSlots() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            if (!(slot instanceof SlotGridCrafting) && slot != this.craftingResultSlot) continue;
            for (int j = 0; j < this.field_75149_d.size(); ++j) {
                ((IContainerListener)this.field_75149_d.get(j)).func_71111_a((Container)this, i, slot.func_75211_c());
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.func_130014_f_().field_72995_K && this.grid instanceof WirelessGrid) {
            ((WirelessGrid)this.grid).onClose(player);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot == this.craftingResultSlot || slot == this.patternResultSlot ? false : super.func_94530_a(stack, slot);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        Slot slot;
        if (!player.func_130014_f_().field_72995_K && (slot = (Slot)this.field_75151_b.get(slotIndex)).func_75216_d()) {
            if (slot == this.craftingResultSlot) {
                ((TileGrid)this.grid).onCraftedShift(this, player);
            } else if (slot != this.patternResultSlot && !(slot instanceof SlotSpecimenLegacy)) {
                if (this.grid.getType() != EnumGridType.FLUID && this.grid.getItemHandler() != null) {
                    slot.func_75215_d(this.grid.getItemHandler().onInsert((EntityPlayerMP)player, slot.func_75211_c()));
                } else if (this.grid.getType() == EnumGridType.FLUID && this.grid.getFluidHandler() != null) {
                    slot.func_75215_d(this.grid.getFluidHandler().onInsert(slot.func_75211_c()));
                }
                this.func_75142_b();
            }
        }
        return null;
    }
}

