/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.math;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class MathUtils {
    public static final Random RAND = new Random();
    public static final DecimalFormat SMALL_DOUBLE_FORMATTER = new DecimalFormat("#0.00");
    public static final double RAD = Math.PI / 180;
    public static final double DEG = 57.29577951308232;
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;
    public static final float PI_F = (float)Math.PI;
    public static final float RAD_F = (float)Math.PI / 180;
    public static final float DEG_F = 57.29578f;
    public static final float TWO_PI_F = (float)Math.PI * 2;
    public static final float HALF_PI_F = 1.5707964f;
    public static final double SQRT_2 = MathUtils.sqrt(2.0);
    public static final float[] NORMALS_X = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    public static final float[] NORMALS_Y = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] NORMALS_Z = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public static final int FACING_BIT_DOWN = 1;
    public static final int FACING_BIT_UP = 2;
    public static final int FACING_BIT_NORTH = 4;
    public static final int FACING_BIT_SOUTH = 8;
    public static final int FACING_BIT_WEST = 16;
    public static final int FACING_BIT_EAST = 32;
    public static final int[] FACING_BIT = new int[]{1, 2, 4, 8, 16, 32};
    public static final int[] OPPOSITE = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] OPPOSITE_BIT = new int[]{2, 1, 8, 4, 32, 16};
    public static final int[] ROTATION_X = new int[]{0, 180, 90, 90, 90, 90};
    public static final int[] ROTATION_Y = new int[]{0, 0, 180, 0, 90, 270};

    @Nullable
    public static EnumFacing getFacing(int i) {
        return i < 0 || i > 5 ? null : EnumFacing.field_82609_l[i];
    }

    public static int getFacingIndex(@Nullable EnumFacing facing) {
        return facing == null ? -1 : facing.func_176745_a();
    }

    public static boolean isNumberBetween(int num, int num1, int num2) {
        int min = Math.min(num1, num2);
        int max = Math.max(num1, num2);
        return num >= min && num <= max;
    }

    public static BlockLog.EnumAxis getAxis(BlockPos pos1, BlockPos pos2) {
        int x = pos1.func_177958_n() - pos2.func_177958_n();
        int y = pos1.func_177956_o() - pos2.func_177956_o();
        int z = pos1.func_177952_p() - pos2.func_177952_p();
        if (x != 0 && y == 0 && z == 0) {
            return BlockLog.EnumAxis.X;
        }
        if (x == 0 && y != 0 && z == 0) {
            return BlockLog.EnumAxis.Y;
        }
        if (x == 0 && y == 0 && z != 0) {
            return BlockLog.EnumAxis.Z;
        }
        return BlockLog.EnumAxis.NONE;
    }

    public static boolean isPosBetween(BlockPos pos, BlockPos pos1, BlockPos pos2) {
        int posx = pos.func_177958_n();
        int posy = pos.func_177956_o();
        int posz = pos.func_177952_p();
        int pos1x = pos1.func_177958_n();
        int pos1y = pos1.func_177956_o();
        int pos1z = pos1.func_177952_p();
        if (posx == pos1x && posy == pos1y && posz == pos1z) {
            return true;
        }
        int pos2x = pos2.func_177958_n();
        int pos2y = pos2.func_177956_o();
        int pos2z = pos2.func_177952_p();
        if (posx == pos2x && posy == pos2y && posz == pos2z) {
            return true;
        }
        int x = pos1x - pos2x;
        int y = pos1y - pos2y;
        int z = pos1z - pos2z;
        if (x != 0 && y == 0 && z == 0) {
            return posy == pos1y && posz == pos1z && MathUtils.isNumberBetween(posx, pos1x, pos2x);
        }
        if (x == 0 && y != 0 && z == 0) {
            return posx == pos1x && posz == pos1z && MathUtils.isNumberBetween(posy, pos1y, pos2y);
        }
        if (x == 0 && y == 0 && z != 0) {
            return posx == pos1x && posy == pos1y && MathUtils.isNumberBetween(posz, pos1z, pos2z);
        }
        return false;
    }

    @Nullable
    public static EnumFacing getFacing(BlockPos pos1, BlockPos pos2) {
        int x = pos2.func_177958_n() - pos1.func_177958_n();
        int y = pos2.func_177956_o() - pos1.func_177956_o();
        int z = pos2.func_177952_p() - pos1.func_177952_p();
        if (x != 0 && y == 0 && z == 0) {
            return x > 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (x == 0 && y != 0 && z == 0) {
            return y > 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (x == 0 && y == 0 && z != 0) {
            return z > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return null;
    }

    public static double sqrt(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        return Math.sqrt(d);
    }

    public static double sqrt2sq(double x, double y) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y) + MathUtils.sq(z));
    }

    public static double sq(double f) {
        return f * f;
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2 ? 0.0 : MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1) + MathUtils.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            return 0.0;
        }
        return MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, x2, y2));
    }

    public static Vec3d getLook(float yaw, float pitch, float dist) {
        float f = MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float x1 = MathHelper.func_76134_b((float)(1.5707964f - yaw * ((float)Math.PI / 180)));
        float z1 = MathHelper.func_76126_a((float)(1.5707964f - yaw * ((float)Math.PI / 180)));
        float y1 = MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(x1 * f * dist), (double)(y1 * dist), (double)(z1 * f * dist));
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int unchunk(int i) {
        return i << 4;
    }

    public static int chunk(double d) {
        return MathUtils.chunk(MathHelper.func_76128_c((double)d));
    }

    public static boolean isRound(double d) {
        return (double)Math.round(d) == d;
    }

    public static boolean canParseInt(@Nullable String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canParseDouble(@Nullable String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int lerp_int(int i1, int i2, double f) {
        return i1 + (int)((double)(i2 - i1) * f);
    }

    public static double lerp_double(double f1, double f2, double f) {
        return f1 + (f2 - f1) * f;
    }

    public static String toSmallDouble(double d) {
        return SMALL_DOUBLE_FORMATTER.format(d);
    }

    public static double map(double val, double min1, double max1, double min2, double max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static int mapInt(int val, int min1, int max1, int min2, int max2) {
        return min2 + (max2 - min2) * ((val - min1) / (max1 - min1));
    }

    public static Vec3d getMidPoint(double x1, double y1, double z1, double x2, double y2, double z2, double p) {
        double x = x2 - x1;
        double y = y2 - y1;
        double z = z2 - z1;
        double d = MathUtils.sqrt(x * x + y * y + z * z);
        return new Vec3d(x1 + x / d * (d * p), y1 + y / d * (d * p), z1 + z / d * (d * p));
    }

    public static Vec3d getMidPoint(Vec3d v1, Vec3d v2, double p) {
        return MathUtils.getMidPoint(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, p);
    }

    public static int getRotations(double yaw, int max) {
        return MathHelper.func_76128_c((double)(yaw * (double)max / 360.0 + 0.5)) & max - 1;
    }

    public static int getRotYaw(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180;
            }
            case SOUTH: {
                return 0;
            }
            case WEST: {
                return 90;
            }
            case EAST: {
                return -90;
            }
        }
        return 0;
    }

    public static int getRotPitch(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return 90;
            }
            case UP: {
                return -90;
            }
        }
        return 0;
    }

    public static double wrap(double i, double n) {
        return (i %= n) < 0.0 ? i + n : i;
    }

    public static int wrap(int i, int n) {
        return (i %= n) < 0 ? i + n : i;
    }

    public static Vec3d getEyePosition(EntityPlayer ep) {
        return new Vec3d(ep.field_70165_t, ep.field_70170_p.field_72995_K ? ep.field_70163_u : ep.field_70163_u + (double)ep.func_70047_e(), ep.field_70161_v);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer playerIn, boolean useLiquids, double dist) {
        Vec3d vec3d = new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        float f2 = MathHelper.func_76134_b((float)(-playerIn.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-playerIn.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-playerIn.field_70125_A * ((float)Math.PI / 180)));
        Vec3d vec3d1 = vec3d.func_72441_c((double)(f3 * f4) * dist, (double)MathHelper.func_76126_a((float)(-playerIn.field_70125_A * ((float)Math.PI / 180))) * dist, (double)(f2 * f4) * dist);
        return playerIn.field_70170_p.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    @Nullable
    public static RayTraceResult rayTrace(EntityPlayer playerIn, boolean useLiquids) {
        double dist = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            dist = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        return MathUtils.rayTrace(playerIn, useLiquids, dist);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, AxisAlignedBB[] boxes) {
        RayTraceResult current = null;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boxes.length; ++i) {
            RayTraceResult mop;
            if (boxes[i] == null || (mop = MathUtils.collisionRayTrace(w, blockPos, start, end, boxes[i])) == null) continue;
            double d1 = mop.field_72307_f.func_72436_e(start);
            if (current != null && !(d1 < dist)) continue;
            current = mop;
            current.subHit = i;
            dist = d1;
        }
        return current;
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, List<AxisAlignedBB> boxes) {
        AxisAlignedBB[] boxesa = new AxisAlignedBB[boxes.size()];
        for (int i = 0; i < boxesa.length; ++i) {
            boxesa[i] = boxes.get(i).func_72321_a(0.0, 0.0, 0.0);
        }
        return MathUtils.collisionRayTrace(w, blockPos, start, end, boxesa);
    }

    @Nullable
    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, AxisAlignedBB aabb) {
        Vec3d pos = start.func_72441_c((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
        Vec3d rot = end.func_72441_c((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
        Vec3d xmin = pos.func_72429_b(rot, aabb.field_72340_a);
        Vec3d xmax = pos.func_72429_b(rot, aabb.field_72336_d);
        Vec3d ymin = pos.func_72435_c(rot, aabb.field_72338_b);
        Vec3d ymax = pos.func_72435_c(rot, aabb.field_72337_e);
        Vec3d zmin = pos.func_72434_d(rot, aabb.field_72339_c);
        Vec3d zmax = pos.func_72434_d(rot, aabb.field_72334_f);
        if (!MathUtils.isVecInsideYZBounds(xmin, aabb)) {
            xmin = null;
        }
        if (!MathUtils.isVecInsideYZBounds(xmax, aabb)) {
            xmax = null;
        }
        if (!MathUtils.isVecInsideXZBounds(ymin, aabb)) {
            ymin = null;
        }
        if (!MathUtils.isVecInsideXZBounds(ymax, aabb)) {
            ymax = null;
        }
        if (!MathUtils.isVecInsideXYBounds(zmin, aabb)) {
            zmin = null;
        }
        if (!MathUtils.isVecInsideXYBounds(zmax, aabb)) {
            zmax = null;
        }
        Vec3d v = null;
        if (xmin != null) {
            v = xmin;
        }
        if (xmax != null && (v == null || pos.func_72436_e(xmax) < pos.func_72436_e(v))) {
            v = xmax;
        }
        if (ymin != null && (v == null || pos.func_72436_e(ymin) < pos.func_72436_e(v))) {
            v = ymin;
        }
        if (ymax != null && (v == null || pos.func_72436_e(ymax) < pos.func_72436_e(v))) {
            v = ymax;
        }
        if (zmin != null && (v == null || pos.func_72436_e(zmin) < pos.func_72436_e(v))) {
            v = zmin;
        }
        if (zmax != null && (v == null || pos.func_72436_e(zmax) < pos.func_72436_e(v))) {
            v = zmax;
        }
        if (v == null) {
            return null;
        }
        EnumFacing side = null;
        if (v == xmin) {
            side = EnumFacing.WEST;
        }
        if (v == xmax) {
            side = EnumFacing.EAST;
        }
        if (v == ymin) {
            side = EnumFacing.DOWN;
        }
        if (v == ymax) {
            side = EnumFacing.UP;
        }
        if (v == zmin) {
            side = EnumFacing.NORTH;
        }
        if (v == zmax) {
            side = EnumFacing.SOUTH;
        }
        return new RayTraceResult(v.func_72441_c((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), side, blockPos);
    }

    private static boolean isVecInsideYZBounds(@Nullable Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(@Nullable Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(@Nullable Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e;
    }

    public static RayTraceResult getMOPFrom(BlockPos pos, EnumFacing s, float hitX, float hitY, float hitZ) {
        return new RayTraceResult(new Vec3d((double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ)), s, pos);
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB bb, EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return bb;
            }
            case UP: {
                return new AxisAlignedBB(1.0 - bb.field_72340_a, 1.0 - bb.field_72338_b, 1.0 - bb.field_72339_c, 1.0 - bb.field_72336_d, 1.0 - bb.field_72337_e, 1.0 - bb.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72339_c, bb.field_72338_b, bb.field_72336_d, bb.field_72334_f, bb.field_72337_e);
            }
            case SOUTH: {
                bb = MathUtils.rotateAABB(bb, EnumFacing.NORTH);
                return new AxisAlignedBB(1.0 - bb.field_72340_a, bb.field_72338_b, 1.0 - bb.field_72339_c, 1.0 - bb.field_72336_d, bb.field_72337_e, 1.0 - bb.field_72334_f);
            }
            case WEST: {
                return MathUtils.rotateCW(MathUtils.rotateAABB(bb, EnumFacing.SOUTH));
            }
            case EAST: {
                return MathUtils.rotateCW(MathUtils.rotateAABB(bb, EnumFacing.NORTH));
            }
        }
        return bb;
    }

    public static AxisAlignedBB rotateCW(AxisAlignedBB bb) {
        return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
    }

    public static AxisAlignedBB[] getRotatedBoxes(AxisAlignedBB bb) {
        AxisAlignedBB[] boxes = new AxisAlignedBB[6];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            boxes[f.ordinal()] = MathUtils.rotateAABB(bb, f);
        }
        return boxes;
    }

    public static RayTraceResult rayTrace(BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        vec.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        return new RayTraceResult(vec, facing, pos);
    }

    public static boolean intersects(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }
}

