/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.config.IGuiEditConfig;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.config.PropertyEnum;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class PropertyEnumAbstract<E extends Enum<E>>
extends PropertyBase {
    public static final String ID = "enum";
    public static final Color4I COLOR = new Color4I(false, -16739073);

    public String func_176610_l() {
        return ID;
    }

    public abstract EnumNameMap<E> getNameMap();

    @Nullable
    public abstract E get();

    public abstract void set(@Nullable E var1);

    public E getNonnull() {
        E e = this.get();
        Preconditions.checkNotNull(e);
        return e;
    }

    @Override
    public Object getValue() {
        return this.get();
    }

    @Override
    public String getString() {
        return EnumNameMap.getName(this.getValue());
    }

    @Override
    public boolean getBoolean() {
        return this.getValue() != null;
    }

    @Override
    public int getInt() {
        return this.getNameMap().getIndex(this.getValue());
    }

    @Override
    public IConfigValue copy() {
        return new PropertyEnum<E>(this.getNameMap(), this.getNameMap().getFromIndex(this.getInt()));
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public List<String> getVariants() {
        return this.getNameMap().getKeys();
    }

    public void func_152753_a(JsonElement json) {
        this.set(this.getNameMap().get(json.getAsString()));
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive(this.getString());
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeShort(this.getNameMap().size);
        for (String s : this.getNameMap().getKeys()) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)s);
        }
        data.writeShort(this.getNameMap().getIndex(this.getValue()));
    }

    @Override
    public void readData(ByteBuf data) {
        throw new IllegalStateException("Can't read Abstract Enum Property!");
    }

    @Override
    public void onClicked(IGuiEditConfig gui, IConfigKey key, IMouseButton button) {
        this.set(this.getNameMap().getFromIndex(MathUtils.wrap(this.getInt() + (button.isLeft() ? 1 : -1), this.getNameMap().size)));
        gui.onChanged(key, this.func_151003_a());
    }
}

