/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IItemLockable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IQuantifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IShroudable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IVoidable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.storage.BaseDrawerData;
import com.jaquadro.minecraft.storagedrawers.storage.ICentralInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CompDrawerData
extends BaseDrawerData
implements IFractionalDrawer,
IVoidable,
IShroudable,
IQuantifiable,
IItemLockable {
    private ICentralInventory central;
    private int slot;

    public CompDrawerData(ICentralInventory centralInventory, int slot) {
        this.slot = slot;
        this.central = centralInventory;
    }

    @Override
    public ItemStack getStoredItemPrototype() {
        return this.central.getStoredItemPrototype(this.slot);
    }

    @Override
    public void setStoredItem(ItemStack itemPrototype, int amount) {
        this.central.setStoredItem(this.slot, itemPrototype, amount);
        this.refresh();
    }

    @Override
    public IDrawer setStoredItemRedir(ItemStack itemPrototype, int amount) {
        IDrawer target = this.central.setStoredItem(this.slot, itemPrototype, amount);
        this.refresh();
        return target;
    }

    @Override
    public int getStoredItemCount() {
        return this.central.getStoredItemCount(this.slot);
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.central.setStoredItemCount(this.slot, amount);
    }

    @Override
    public int getMaxCapacity() {
        return this.central.getMaxCapacity(this.slot);
    }

    @Override
    public int getMaxCapacity(ItemStack itemPrototype) {
        return this.central.getMaxCapacity(this.slot, itemPrototype);
    }

    @Override
    public int getRemainingCapacity() {
        return this.central.getRemainingCapacity(this.slot);
    }

    @Override
    public int getStoredItemStackSize() {
        return this.central.getStoredItemStackSize(this.slot);
    }

    @Override
    protected int getItemCapacityForInventoryStack() {
        return this.central.getItemCapacityForInventoryStack(this.slot);
    }

    @Override
    public boolean canItemBeStored(ItemStack itemPrototype) {
        if (this.getStoredItemPrototype() == null && !this.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            return true;
        }
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean canItemBeExtracted(ItemStack itemPrototype) {
        return this.areItemsEqual(itemPrototype);
    }

    @Override
    public boolean isEmpty() {
        return this.getStoredItemPrototype() == null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.central.writeToNBT(this.slot, tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.central.readFromNBT(this.slot, tag);
        this.refresh();
    }

    @Override
    public int getConversionRate() {
        return this.central.getConversionRate(this.slot);
    }

    @Override
    public int getStoredItemRemainder() {
        return this.central.getStoredItemRemainder(this.slot);
    }

    @Override
    public boolean isSmallestUnit() {
        return this.central.isSmallestUnit(this.slot);
    }

    public void refresh() {
        this.reset();
        this.refreshOreDictMatches();
    }

    @Override
    public boolean isVoid() {
        return this.central.isVoidSlot(this.slot);
    }

    @Override
    public boolean isShrouded() {
        return this.central.isShroudedSlot(this.slot);
    }

    @Override
    public boolean setIsShrouded(boolean state) {
        return this.central.setIsSlotShrouded(this.slot, state);
    }

    @Override
    public boolean isShowingQuantity() {
        return this.central.isSlotShowingQuantity(this.slot);
    }

    @Override
    public boolean setIsShowingQuantity(boolean state) {
        return this.central.setIsSlotShowingQuantity(this.slot, state);
    }

    @Override
    public boolean isItemLocked(LockAttribute attr) {
        return this.central.isLocked(this.slot, attr);
    }

    @Override
    public boolean canItemLock(LockAttribute attr) {
        return false;
    }

    @Override
    public void setItemLocked(LockAttribute attr, boolean isLocked) {
    }
}

