/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.slot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.container.slot.FakeSlot;
import net.minecraft.item.ItemStack;

public class FakeSlotCraftMatrix
extends FakeSlot {
    private static final float ITEM_SWITCH_TIME = 80.0f;
    private final List<ItemStack> visibleStacks = Lists.newArrayList();
    private float visibleItemTime;
    private int visibleItemIndex;
    private boolean isLocked;

    public FakeSlotCraftMatrix(int slotId, int x, int y) {
        super(slotId, x, y);
    }

    public void setIngredient(List<ItemStack> ingredients) {
        ItemStack prevLockStack = this.isLocked ? this.func_75211_c() : null;
        this.visibleStacks.clear();
        if (ingredients != null) {
            for (ItemStack itemStack : ingredients) {
                if (itemStack == null) continue;
                if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                    ArrayList subItems = Lists.newArrayList();
                    itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), itemStack.func_77973_b().func_77640_w(), (List)subItems);
                    this.visibleStacks.addAll(subItems);
                    continue;
                }
                itemStack.field_77994_a = 1;
                this.visibleStacks.add(itemStack);
            }
        }
        this.visibleItemTime = 0.0f;
        this.visibleItemIndex = 0;
        this.isLocked = false;
        if (prevLockStack != null) {
            for (int i = 0; i < this.visibleStacks.size(); ++i) {
                if (!ItemUtils.areItemStacksEqualWithWildcard(this.visibleStacks.get(i), prevLockStack)) continue;
                this.visibleItemIndex = i;
                this.isLocked = true;
            }
        }
    }

    public void updateSlot(float partialTicks) {
        if (!this.isLocked) {
            this.visibleItemTime += partialTicks;
            if (this.visibleItemTime >= 80.0f) {
                ++this.visibleItemIndex;
                if (this.visibleItemIndex >= this.visibleStacks.size()) {
                    this.visibleItemIndex = 0;
                }
                this.visibleItemTime = 0.0f;
            }
        }
    }

    @Override
    public ItemStack func_75211_c() {
        return this.visibleStacks.size() > 0 ? this.visibleStacks.get(this.visibleItemIndex) : null;
    }

    @Override
    public boolean func_75216_d() {
        return this.visibleStacks.size() > 0;
    }

    public boolean func_111238_b() {
        return this.visibleStacks.size() > 0;
    }

    public List<ItemStack> getVisibleStacks() {
        return this.visibleStacks;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void scrollDisplayList(int i) {
        this.isLocked = true;
        this.visibleItemIndex += i;
        if (this.visibleItemIndex >= this.visibleStacks.size()) {
            this.visibleItemIndex = 0;
        } else if (this.visibleItemIndex < 0) {
            this.visibleItemIndex = this.visibleStacks.size() - 1;
        }
    }
}

