/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.morechickens.modHelper;

import com.gendeathrow.morechickens.core.ChickensMore;
import com.gendeathrow.morechickens.util.ChickenInformation;
import com.gendeathrow.morechickens.util.LogUtil;
import com.setycz.chickens.ChickensRegistryItem;
import com.setycz.chickens.SpawnType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BaseModAddon {
    protected String modID;
    protected String modName;
    protected String texturesLocation;
    private int startID = 2000;
    private boolean needsMod = true;
    boolean first = true;
    public static String IronChicken = "IronChicken";
    public static String CoalChicken = "CoalChicken";
    public static String YellowChicken = "YellowChicken";
    public static String WhiteChicken = "WhiteChicken";
    public static String ClayChicken = "ClayChicken";
    public static String GreenChicken = "GreenChicken";
    public static String BlackChicken = "BlackChicken";
    public static String FlintChicken = "FlintChicken";
    public static String BrownChicken = "BrownChicken";
    public static String GoldChicken = "GoldChicken";
    public static String RedstoneChicken = "RedstoneChicken";
    public static String SandChicken = "SandChicken";
    public static String GhastChicken = "ghastchicken";
    public static String EnderChicken = "enderchicken";
    public static String GunpowderChicken = "GunpowderChicken";
    public static String BlazeChicken = "BlazeChicken";
    public static String NetherWartChicken = "netherwartchicken";
    public static String SlimeChicken = "slimechicken";
    public static String RedChicken = "RedChicken";
    public static String MagmaChicken = "magmachicken";
    public static String BlueChicken = "BlueChicken";
    public static String GlowstoneChicken = "GlowstoneChicken";
    public static String WaterChicken = "WaterChicken";
    public static String QuartzChicken = "quartzChicken";
    public static String EmeraldChicken = "emeraldchicken";
    public static String LavaChicken = "LavaChicken";
    public static String SnowballChicken = "SnowballChicken";
    public static String LogChicken = "LogChicken";
    public static String GrayChicken = "GrayChicken";
    public static String SilverDyeChicken = "SilverDyeChicken";
    public static String CyanChicken = "CyanChicken";
    public static String DiamondChicken = "DiamondChicken";
    public static String PurpleChicken = "PurpleChicken";
    public static String OrangeChicken = "OrangeChicken";

    public BaseModAddon(String modID, String modName, String texturesLocation) {
        this.modID = modID;
        this.modName = modName;
        this.texturesLocation = texturesLocation;
    }

    public String getModID() {
        return this.modID;
    }

    public String getModName() {
        return this.modName;
    }

    public void setNeedsModPresent(boolean bool) {
        this.needsMod = bool;
    }

    public void setStartID(int startID) {
        this.startID = startID;
    }

    public List<ChickensRegistryItem> tryRegisterChickens(List<ChickensRegistryItem> allChickens) {
        LogUtil.info("Looking for " + this.modName + " addon...");
        if (this.needsMod && !Loader.isModLoaded((String)this.modID)) {
            return allChickens;
        }
        LogUtil.info("Loading " + this.modName + " addon...");
        allChickens = this.registerChickens(allChickens);
        return allChickens;
    }

    public abstract List<ChickensRegistryItem> registerChickens(List<ChickensRegistryItem> var1);

    public abstract void RegisterAllParents(List<ChickensRegistryItem> var1);

    protected int nextID() {
        return this.startID++;
    }

    protected ChickensRegistryItem addChicken(List<ChickensRegistryItem> chickenList, String chickenName, int chickenID, String texture, ItemStack layItem, int bgColor, int fgColor) {
        return this.addChicken(chickenList, chickenName, fgColor, texture, layItem, fgColor, fgColor, SpawnType.NONE);
    }

    protected ChickensRegistryItem addChicken(List<ChickensRegistryItem> chickenList, String chickenName, int chickenID, String texture, ItemStack layItem, int bgColor, int fgColor, SpawnType spawntype) {
        if (layItem == null || layItem.func_77973_b() == null) {
            LogUtil.error("Error Registering (" + this.modID + ") Chicken: '" + chickenName + "' It's LayItem was null");
            return null;
        }
        LogUtil.debug("Registering (" + this.modID + ") Chicken: '" + chickenName + "':" + chickenID + ":" + layItem.func_82833_r());
        ChickensRegistryItem chicken = new ChickensRegistryItem(chickenID, chickenName, new ResourceLocation("morechickens", this.texturesLocation + texture), layItem.func_77946_l(), bgColor, fgColor).setSpawnType(spawntype);
        chickenList.add(chicken);
        ChickenInformation.AddChickenInformation(chickenID, new ChickenInformation("More Chickens", "", this.getModName()));
        return chicken;
    }

    protected void setParents(ChickensRegistryItem child, Object parent1, Object parent2) {
        ChickensRegistryItem parentChicken1 = null;
        ChickensRegistryItem parentChicken2 = null;
        if (child == null || parent1 == null || parent2 == null) {
            String msg = "Setting Parents ";
            msg = child == null ? msg + ": Child Missing" : msg + ": " + child.getEntityName();
            if (parent1 == null) {
                msg = msg + ": Parent 1 Missing ";
            }
            if (parent2 == null) {
                msg = msg + ": Parent 2 Missing";
            }
            LogUtil.debug(msg);
            return;
        }
        if (parent1 instanceof String) {
            parentChicken1 = ChickensMore.findChickenChickensMod((String)parent1);
        } else if (parent1 instanceof ChickensRegistryItem) {
            parentChicken1 = (ChickensRegistryItem)parent1;
        }
        if (parent2 instanceof String) {
            parentChicken2 = ChickensMore.findChickenChickensMod((String)parent2);
        } else if (parent2 instanceof ChickensRegistryItem) {
            parentChicken2 = (ChickensRegistryItem)parent2;
        }
        if (parentChicken1 == null) {
            LogUtil.error("Could not find Parent 1 for " + child.getEntityName());
            return;
        }
        if (parentChicken2 == null) {
            LogUtil.error("Could not find Parent 2 for " + child.getEntityName());
            return;
        }
        child.setParentsNew(parentChicken1, parentChicken2);
    }

    @Nullable
    public ItemStack getFirstOreDictionary(String oreID) {
        List itemstacks = OreDictionary.getOres((String)oreID);
        return !itemstacks.isEmpty() ? (ItemStack)itemstacks.get(0) : null;
    }
}

