/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.anvil;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.shadowfacts.shadowmc.anvil.AnvilRecipe;
import net.shadowfacts.shadowmc.anvil.BasicAnvilRecipe;

public class AnvilManager {
    private static AnvilManager instance = new AnvilManager();
    private List<AnvilRecipe> recipes = new ArrayList<AnvilRecipe>();

    private AnvilManager() {
    }

    public AnvilRecipe addRecipe(ItemStack left, ItemStack right, ItemStack result, int xp) {
        BasicAnvilRecipe recipe = new BasicAnvilRecipe(left, right, result, xp);
        this.recipes.add(recipe);
        return recipe;
    }

    public Optional<AnvilRecipe> getRecipe(ItemStack left, ItemStack right) {
        return this.recipes.stream().filter(recipe -> recipe.matches(left, right)).findFirst();
    }

    public Optional<ItemStack> getOutput(ItemStack left, ItemStack right) {
        Optional<AnvilRecipe> recipe = this.getRecipe(left, right);
        if (recipe.isPresent()) {
            return Optional.of(recipe.get().getResult());
        }
        return Optional.empty();
    }

    public int getCost(ItemStack left, ItemStack right) {
        Optional<AnvilRecipe> recipe = this.getRecipe(left, right);
        if (recipe.isPresent()) {
            return recipe.get().getXPCost();
        }
        return 0;
    }

    public static AnvilManager getInstance() {
        return instance;
    }

    public List<AnvilRecipe> getRecipes() {
        return this.recipes;
    }
}

