/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power;

import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketBase;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.IPower;
import com.rwtema.extrautils2.power.PowerManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@NetworkHandler.XUPacket
public class PacketPowerInfo
extends XUPacketBase {
    BlockPos pos;
    float ePos = -1.0f;
    private EntityPlayer player;

    public PacketPowerInfo() {
    }

    public PacketPowerInfo(BlockPos pos) {
        this.pos = pos;
    }

    public PacketPowerInfo(float ePos, BlockPos pos) {
        this.ePos = ePos;
        this.pos = pos;
    }

    @Override
    public void writeData() throws Exception {
        this.writeBlockPos(this.pos);
        this.writeFloat(this.ePos);
    }

    @Override
    public void readData(EntityPlayer player) {
        this.player = player;
        this.pos = this.readBlockPos();
        this.ePos = this.readFloat();
    }

    @Override
    public Runnable doStuffServer() {
        return new Runnable(){

            @Override
            public void run() {
                float v;
                IPower power;
                int frequency;
                if (!(PacketPowerInfo.this.player instanceof EntityPlayerMP)) {
                    return;
                }
                TileEntity tile = ((PacketPowerInfo)PacketPowerInfo.this).player.field_70170_p.func_175625_s(PacketPowerInfo.this.pos);
                if (!(tile instanceof IPower)) {
                    return;
                }
                int freq = Freq.getBasePlayerFreq((EntityPlayerMP)PacketPowerInfo.this.player);
                if (PowerManager.areFreqOnSameGrid(freq, frequency = (power = (IPower)tile).frequency())) {
                    v = PowerManager.getCurrentPower(power);
                    if (v == PacketPowerInfo.this.ePos) {
                        return;
                    }
                } else {
                    v = Float.NaN;
                }
                NetworkHandler.sendPacketToPlayer(new PacketPowerInfo(v, PacketPowerInfo.this.pos), PacketPowerInfo.this.player);
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Runnable doStuffClient() {
        return new Runnable(){

            @Override
            public void run() {
                if (ClientPower.currentPosition == PacketPowerInfo.this.pos || ClientPower.currentPosition != null && ClientPower.currentPosition.equals((Object)PacketPowerInfo.this.pos)) {
                    ClientPower.currentPositionEnergy = PacketPowerInfo.this.ePos;
                }
            }
        };
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return true;
    }
}

