/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.jei.DrawableConcat;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.WidgetFluidBase;
import com.rwtema.extrautils2.machine.BlockMachine;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.TObjectFloatMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class JEIMachine
extends BlankRecipeCategory<JEIMachineRecipe.Wrapper>
implements IRecipeCategory<JEIMachineRecipe.Wrapper> {
    public static final int height;
    public static final int sloty;
    public static final int texty;
    public static final int padding;
    public static final int arrowy;
    static IIngredientHelper<ItemStack> helper;
    static IIngredientRenderer<ItemStack> renderer;
    public final int width;
    public final IDrawableStatic arrowBack;
    final Machine machine;
    private final IDrawableAnimated arrow;
    IDrawable slotDrawable = XUJEIPlugin.jeiHelpers.getGuiHelper().getSlotDrawable();
    IDrawable background;
    IDrawable fluidTank;
    IDrawable fluidTankTicks;

    public JEIMachine(Machine machine) {
        this.machine = machine;
        this.width = (machine.itemInputs.size() + machine.itemOutputs.size()) * 22 + 4 + 22;
        IGuiHelper guiHelper = XUJEIPlugin.jeiHelpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(this.width, height);
        this.arrowBack = guiHelper.createDrawable(DynamicGui.texWidgets, 98, 0, 22, 16);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(DynamicGui.texWidgets, 98, 16, 22, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        int i = 0;
        this.fluidTank = guiHelper.createDrawable(DynamicGui.texWidgets, WidgetFluidBase.ux[i], WidgetFluidBase.uy[i], WidgetFluidBase.uw[i], WidgetFluidBase.uh[i]);
        this.fluidTankTicks = new DrawableConcat().add((IDrawable)guiHelper.createDrawable(DynamicGui.texWidgets, WidgetFluidBase.ux2[i], WidgetFluidBase.uy2[i], WidgetFluidBase.uw2[i], WidgetFluidBase.uh[i] - 2), 0, 0).add((IDrawable)guiHelper.createDrawable(DynamicGui.texWidgets, WidgetFluidBase.ux2[i] + WidgetFluidBase.uw2[i], WidgetFluidBase.uy2[i], WidgetFluidBase.uw2[i], WidgetFluidBase.uh[i] - 2), WidgetFluidBase.uw[i] - 2 - WidgetFluidBase.uw2[i], 0);
    }

    @Nonnull
    public static String getString(Machine machine) {
        return "xu2_machine_" + machine.name;
    }

    @Nonnull
    public String getUid() {
        return JEIMachine.getString(this.machine);
    }

    @Nonnull
    public String getTitle() {
        return BlockMachine.getDisplayName(this.machine);
    }

    @Nonnull
    public String getModName() {
        return "extrautils2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        int x = 0;
        for (MachineSlot ignored : this.machine.fluidInputs) {
            this.fluidTank.draw(minecraft, x, sloty + 9 - WidgetFluidBase.uh[0] / 2);
            x += 4 + this.fluidTank.getWidth();
        }
        for (MachineSlot ignored : this.machine.itemInputs) {
            this.slotDrawable.draw(minecraft, x, sloty);
            x += 22;
        }
        this.arrowBack.draw(minecraft, x, arrowy);
        x += 26;
        for (MachineSlot ignored : this.machine.itemOutputs) {
            this.slotDrawable.draw(minecraft, x, sloty);
            x += 22;
        }
        for (MachineSlot ignored : this.machine.fluidOutputs) {
            this.fluidTank.draw(minecraft, x, sloty + 9 - WidgetFluidBase.uh[0] / 2);
            x += 4 + this.fluidTank.getWidth();
        }
        this.arrow.draw(minecraft, this.machine.fluidInputs.size() * (4 + this.fluidTank.getWidth()) + this.machine.itemInputs.size() * 22, arrowy);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull JEIMachineRecipe.Wrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        JEIMachineRecipe recipe = recipeWrapper.parentRecipe;
        IGuiFluidStackGroup fluidStackGroup = recipeLayout.getFluidStacks();
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int x = 0;
        int itemIndex = 0;
        int fluidIndex = 0;
        HashMap<MachineSlotFluid, IGuiIngredient> fluidinputStackGuiSlots = new HashMap<MachineSlotFluid, IGuiIngredient>();
        for (MachineSlotFluid fluidInput : this.machine.fluidInputs) {
            this.addFluidSlot(fluidStackGroup, x, fluidIndex, fluidInput);
            IGuiIngredient iGuiIngredient = (IGuiIngredient)fluidStackGroup.getGuiIngredients().get(fluidIndex);
            fluidinputStackGuiSlots.put(fluidInput, iGuiIngredient);
            fluidStackGroup.set(fluidIndex, recipe.fluids.get(fluidInput));
            x += 22;
            ++fluidIndex;
        }
        HashMap<MachineSlotItem, IGuiIngredient> inputStackGuiSlots = new HashMap<MachineSlotItem, IGuiIngredient>();
        ImmutableList<MachineSlotItem> itemInputs = this.machine.itemInputs;
        for (MachineSlotItem slot : itemInputs) {
            itemStackGroup.init(itemIndex, true, x, sloty);
            IGuiIngredient iGuiIngredient = (IGuiIngredient)itemStackGroup.getGuiIngredients().get(itemIndex);
            inputStackGuiSlots.put(slot, iGuiIngredient);
            itemStackGroup.set(itemIndex, recipe.inputs.get(slot));
            x += 22;
            ++itemIndex;
        }
        x += 26;
        HashMap<MachineSlotItem, Integer> itemOutputStacks = new HashMap<MachineSlotItem, Integer>();
        for (MachineSlotItem slot : this.machine.itemOutputs) {
            itemStackGroup.init(itemIndex, false, x, sloty);
            itemStackGroup.set(itemIndex, (List)ImmutableList.of());
            itemOutputStacks.put(slot, itemIndex);
            ++itemIndex;
            x += 22;
        }
        HashMap<MachineSlotFluid, Integer> fluidOutputStacks = new HashMap<MachineSlotFluid, Integer>();
        for (MachineSlotFluid slot : this.machine.fluidOutputs) {
            this.addFluidSlot(fluidStackGroup, x, fluidIndex, slot);
            fluidStackGroup.set(fluidIndex, (List)ImmutableList.of());
            fluidOutputStacks.put(slot, fluidIndex);
            ++fluidIndex;
            x += 22;
        }
        recipeWrapper.localFluidInputSlots = fluidinputStackGuiSlots;
        recipeWrapper.localFluidOutputSlots = fluidOutputStacks;
        recipeWrapper.fluidGroupSlots = fluidStackGroup;
        recipeWrapper.localItemInputSlots = inputStackGuiSlots;
        recipeWrapper.localItemOutputSlots = itemOutputStacks;
        recipeWrapper.itemGroupSlots = itemStackGroup;
    }

    private void addFluidSlot(IGuiFluidStackGroup fluidStacks, int x, int itemIndex, MachineSlotFluid slot) {
        fluidStacks.init(itemIndex, false, x + 1, sloty + 1 + 9 - WidgetFluidBase.uh[0] / 2, this.fluidTank.getWidth() - 2, this.fluidTank.getHeight() - 2, slot.stackCapacity, true, this.fluidTankTicks);
    }

    static {
        padding = 4;
        height = padding + 18 + 4 + 9 + 9 + padding;
        sloty = padding;
        texty = padding + 18 + 4;
        arrowy = sloty;
    }

    public static class JEIMachineRecipe {
        public Machine machine;
        public IMachineRecipe recipe;
        public Map<MachineSlotItem, List<ItemStack>> inputs;
        public Map<MachineSlotFluid, List<FluidStack>> fluids;

        public JEIMachineRecipe(Machine machine, IMachineRecipe recipe, Map<MachineSlotItem, List<ItemStack>> inputs, Map<MachineSlotFluid, List<FluidStack>> fluids) {
            this.machine = machine;
            this.recipe = recipe;
            this.inputs = inputs;
            this.fluids = fluids;
        }

        public Wrapper createWrapper() {
            return new Wrapper(this);
        }

        public static class Wrapper
        extends BlankRecipeWrapper
        implements IRecipeWrapper {
            public final JEIMachineRecipe parentRecipe;
            public HashMap<MachineSlotFluid, IGuiIngredient<FluidStack>> localFluidInputSlots;
            public HashMap<MachineSlotFluid, Integer> localFluidOutputSlots;
            public IGuiIngredientGroup<FluidStack> fluidGroupSlots;
            public HashMap<MachineSlotItem, IGuiIngredient<ItemStack>> localItemInputSlots;
            public HashMap<MachineSlotItem, Integer> localItemOutputSlots;
            public IGuiIngredientGroup<ItemStack> itemGroupSlots;

            public Wrapper(JEIMachineRecipe parentRecipe) {
                this.parentRecipe = parentRecipe;
            }

            public void getIngredients(@Nonnull IIngredients ingredients) {
                ArrayList<List<ItemStack>> objects = new ArrayList<List<ItemStack>>();
                for (MachineSlotItem slot : this.parentRecipe.machine.itemInputs) {
                    objects.add(this.parentRecipe.inputs.get(slot));
                }
                ingredients.setInputLists(ItemStack.class, objects);
                ArrayList<List<FluidStack>> fluidObjects = new ArrayList<List<FluidStack>>();
                for (MachineSlotFluid slot : this.parentRecipe.machine.fluidInputs) {
                    fluidObjects.add(this.parentRecipe.fluids.get(slot));
                }
                ingredients.setInputLists(FluidStack.class, fluidObjects);
                Map<MachineSlotItem, ItemStack> items = this.buildMap((List)this.parentRecipe.machine.itemInputs, (Map)this.parentRecipe.inputs);
                Map<MachineSlotFluid, FluidStack> fluids = this.buildMap((List)this.parentRecipe.machine.fluidInputs, (Map)this.parentRecipe.fluids);
                Map<MachineSlotItem, ItemStack> itemOutputs = this.parentRecipe.recipe.getItemOutputs(items, fluids);
                List collect = itemOutputs.values().stream().filter(f -> StackHelper.isNonNull(f)).collect(Collectors.toList());
                ingredients.setOutputs(ItemStack.class, collect);
                Map<MachineSlotFluid, FluidStack> fluidOutputs = this.parentRecipe.recipe.getFluidOutputs(items, fluids);
                List collect1 = fluidOutputs.values().stream().filter(f -> f != null).collect(Collectors.toList());
                ingredients.setOutputs(FluidStack.class, collect1);
            }

            public <K extends MachineSlot<V>, V> Map<K, V> buildMap(List<K> list, Map<K, List<V>> inputs) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (MachineSlot k : list) {
                    List<V> objects = inputs.get(k);
                    Object v = objects.stream().findAny().orElse(null);
                    builder.put((Object)k, v);
                }
                return builder.build();
            }

            public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
                if (this.localItemInputSlots == null || this.localItemOutputSlots == null || this.itemGroupSlots == null) {
                    return;
                }
                HashMap<MachineSlotItem, ItemStack> itemStacks = new HashMap<MachineSlotItem, ItemStack>();
                for (MachineSlotItem slot : this.parentRecipe.machine.itemInputs) {
                    itemStacks.put(slot, (ItemStack)this.localItemInputSlots.get(slot).getDisplayedIngredient());
                }
                HashMap<MachineSlotFluid, FluidStack> fluidStacks = new HashMap<MachineSlotFluid, FluidStack>();
                for (MachineSlotFluid slot : this.parentRecipe.machine.fluidInputs) {
                    fluidStacks.put(slot, (FluidStack)this.localFluidInputSlots.get(slot).getDisplayedIngredient());
                }
                if (!this.parentRecipe.recipe.matches(itemStacks, fluidStacks)) {
                    for (MachineSlotItem slotItem : this.parentRecipe.machine.itemOutputs) {
                        this.itemGroupSlots.set(this.localItemOutputSlots.get(slotItem).intValue(), (List)ImmutableList.of());
                    }
                    for (MachineSlotFluid slot : this.parentRecipe.machine.fluidOutputs) {
                        this.fluidGroupSlots.set(this.localFluidOutputSlots.get(slot).intValue(), (List)ImmutableList.of());
                    }
                    return;
                }
                Map<MachineSlotItem, ItemStack> itemOutputs = this.parentRecipe.recipe.getItemOutputsJEI(itemStacks, fluidStacks);
                for (MachineSlotItem slotItem : this.parentRecipe.machine.itemOutputs) {
                    ItemStack itemStack = itemOutputs.get(slotItem);
                    Integer slotIndex = this.localItemOutputSlots.get(slotItem);
                    if (StackHelper.isNonNull(itemStack)) {
                        this.itemGroupSlots.set(slotIndex.intValue(), (Object)itemStack);
                        continue;
                    }
                    this.itemGroupSlots.set(slotIndex.intValue(), (List)ImmutableList.of());
                }
                Map<MachineSlotFluid, FluidStack> fluidOutputs = this.parentRecipe.recipe.getFluidOutputsJEI(itemStacks, fluidStacks);
                for (MachineSlotFluid slotFluid : this.parentRecipe.machine.fluidOutputs) {
                    FluidStack fluidStack = fluidOutputs.get(slotFluid);
                    Integer slotIndex = this.localFluidOutputSlots.get(slotFluid);
                    if (fluidStack != null) {
                        this.fluidGroupSlots.set(slotIndex.intValue(), (Object)fluidStack);
                        continue;
                    }
                    this.fluidGroupSlots.set(slotIndex.intValue(), (List)ImmutableList.of());
                }
                int energyOutput = this.parentRecipe.recipe.getEnergyOutput(itemStacks, fluidStacks);
                int time = this.parentRecipe.recipe.getProcessingTime(itemStacks, fluidStacks);
                switch (this.parentRecipe.machine.energyMode) {
                    case USES_ENERGY: {
                        String format = StringHelper.format(energyOutput) + "RF " + StringHelper.formatDurationSeconds(time, false);
                        minecraft.field_71466_p.func_78276_b(format, (recipeWidth - minecraft.field_71466_p.func_78256_a(format)) / 2, recipeHeight - 9, Color.gray.getRGB());
                        break;
                    }
                    case GENERATES_ENERGY: {
                        float rate = this.parentRecipe.recipe.getEnergyRate(itemStacks, fluidStacks);
                        String format = StringHelper.format(energyOutput) + "RF " + StringHelper.formatDurationSeconds(time, false) + " " + StringHelper.format(rate) + "RF/T";
                        minecraft.field_71466_p.func_78276_b(format, (recipeWidth - minecraft.field_71466_p.func_78256_a(format)) / 2, recipeHeight - 9, Color.gray.getRGB());
                    }
                }
                TObjectFloatMap<MachineSlot> probabilityModifier = this.parentRecipe.recipe.getProbabilityModifier(itemStacks, fluidStacks);
                if (probabilityModifier == null) {
                    return;
                }
                int x = this.parentRecipe.machine.itemInputs.size() * 22;
                x += 26;
                for (MachineSlot slot : Iterables.concat(this.parentRecipe.machine.itemOutputs, this.parentRecipe.machine.fluidOutputs)) {
                    float v;
                    if (probabilityModifier.containsKey((Object)slot) && (double)(v = probabilityModifier.get((Object)slot)) <= 0.99) {
                        minecraft.field_71466_p.func_78276_b(this.toString(v), x, texty, Color.gray.getRGB());
                    }
                    x += 22;
                }
            }

            public String toString(float v) {
                int round = Math.round(v * 100.0f);
                return round + "%";
            }

            @Nullable
            public List<String> getTooltipStrings(int mouseX, int mouseY) {
                return Collections.emptyList();
            }

            public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
                return false;
            }
        }
    }

    public static class Handler
    implements IRecipeHandler<JEIMachineRecipe> {
        static Handler INSTANCE = new Handler();

        @Nonnull
        public Class<JEIMachineRecipe> getRecipeClass() {
            return JEIMachineRecipe.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            throw new IllegalStateException();
        }

        @Nonnull
        public String getRecipeCategoryUid(@Nonnull JEIMachineRecipe recipe) {
            return JEIMachine.getString(recipe.machine);
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull JEIMachineRecipe recipe) {
            return recipe.createWrapper();
        }

        public boolean isRecipeValid(@Nonnull JEIMachineRecipe recipe) {
            return true;
        }
    }
}

