/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.network;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import squeek.applecore.network.MessageDifficultySync;

public class SyncHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("AppleCore");
    private EnumDifficulty lastDifficultySetting = null;

    public static void init() {
        CHANNEL.registerMessage(MessageDifficultySync.class, MessageDifficultySync.class, 0, Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        CHANNEL.sendTo((IMessage)new MessageDifficultySync(event.player.field_70170_p.func_175659_aa()), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.world instanceof WorldServer && this.lastDifficultySetting != event.world.func_175659_aa()) {
            CHANNEL.sendToAll((IMessage)new MessageDifficultySync(event.world.func_175659_aa()));
            this.lastDifficultySetting = event.world.func_175659_aa();
        }
    }
}

