/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.heavysieve;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.minecraft.block.state.IBlockState;

public class HeavySieveRegistryEntry {
    private final IBlockState inputState;
    private final boolean isWildcard;
    private final List<HeavySieveReward> rewards = Lists.newArrayList();
    private final ArrayListMultimap<Integer, HeavySieveReward> meshRewards = ArrayListMultimap.create();

    public HeavySieveRegistryEntry(IBlockState input, boolean isWildcard) {
        this.inputState = input;
        this.isWildcard = isWildcard;
    }

    public IBlockState getInputState() {
        return this.inputState;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public List<HeavySieveReward> getRewards() {
        return this.rewards;
    }

    public List<HeavySieveReward> getRewardsForMesh(SieveMeshRegistryEntry sieveMesh) {
        if (!ExRegistro.doMeshesSplitLootTables()) {
            return this.rewards;
        }
        return this.meshRewards.get((Object)sieveMesh.getMeshLevel());
    }

    public void addReward(HeavySieveReward reward) {
        this.rewards.add(reward);
        if (ExRegistro.doMeshesSplitLootTables()) {
            this.meshRewards.put((Object)reward.getMeshLevel(), (Object)reward);
        }
    }

    public void addRewards(Collection<HeavySieveReward> rewards) {
        this.rewards.addAll(rewards);
        if (ExRegistro.doMeshesSplitLootTables()) {
            for (HeavySieveReward reward : rewards) {
                this.meshRewards.put((Object)reward.getMeshLevel(), (Object)reward);
            }
        }
    }
}

