/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.blay09.mods.excompressum.registry.compressor.InventoryCompressedMatcher;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CompressedRecipeRegistry {
    private static final List<CompressedRecipe> recipesSmall = Lists.newArrayList();
    private static final List<CompressedRecipe> recipes = Lists.newArrayList();
    private static final InventoryCompressedMatcher matcherSmall = new InventoryCompressedMatcher(2, 2, false);
    private static final InventoryCompressedMatcher matcherSmallStupid = new InventoryCompressedMatcher(3, 3, true);
    private static final InventoryCompressedMatcher matcher = new InventoryCompressedMatcher(3, 3, false);
    private static final Map<RegistryKey, CompressedRecipe> cachedResults = Maps.newHashMap();

    public static void reload() {
        cachedResults.clear();
        recipesSmall.clear();
        recipes.clear();
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)obj;
            if (obj instanceof ShapedRecipes) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, CompressedRecipeRegistry.getRecipeSource((ShapedRecipes)obj));
                continue;
            }
            if (obj instanceof ShapelessRecipes) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, CompressedRecipeRegistry.getRecipeSource((ShapelessRecipes)obj));
                continue;
            }
            if (obj instanceof ShapedOreRecipe) {
                for (ItemStack itemStack : CompressedRecipeRegistry.getRecipeSources((ShapedOreRecipe)obj)) {
                    CompressedRecipeRegistry.addCompressedRecipe(recipe, itemStack);
                }
                continue;
            }
            if (!(obj instanceof ShapelessOreRecipe)) continue;
            for (ItemStack itemStack : CompressedRecipeRegistry.getRecipeSources((ShapelessOreRecipe)obj)) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, itemStack);
            }
        }
    }

    private static void addCompressedRecipe(IRecipe recipe, @Nullable ItemStack sourceStack) {
        if (sourceStack != null && sourceStack.func_77973_b() != null) {
            sourceStack = sourceStack.func_77946_l();
            if (recipe.func_77570_a() == 4) {
                matcherSmall.fill(sourceStack);
                if (recipe.func_77569_a((InventoryCrafting)matcherSmall, null)) {
                    sourceStack.field_77994_a = 4;
                    ItemStack result = recipe.func_77572_b((InventoryCrafting)matcherSmall);
                    if (result != null) {
                        recipesSmall.add(new CompressedRecipe(sourceStack, result.func_77946_l()));
                    }
                }
            } else if (recipe.func_77570_a() == 9) {
                matcher.fill(sourceStack);
                if (recipe.func_77569_a((InventoryCrafting)matcher, null)) {
                    sourceStack.field_77994_a = 9;
                    ItemStack result = recipe.func_77572_b((InventoryCrafting)matcher);
                    if (result != null) {
                        recipes.add(new CompressedRecipe(sourceStack, result.func_77946_l()));
                    }
                } else {
                    matcherSmallStupid.fill(sourceStack);
                    if (recipe.func_77569_a((InventoryCrafting)matcherSmallStupid, null)) {
                        sourceStack.field_77994_a = 4;
                        ItemStack result = recipe.func_77572_b((InventoryCrafting)matcherSmallStupid);
                        if (result != null) {
                            recipesSmall.add(new CompressedRecipe(sourceStack, result.func_77946_l()));
                        }
                    }
                }
            }
        }
    }

    @Nullable
    private static ItemStack getRecipeSource(ShapedRecipes recipe) {
        for (ItemStack itemStack : recipe.field_77574_d) {
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    @Nullable
    private static ItemStack getRecipeSource(ShapelessRecipes recipe) {
        for (Object obj : recipe.field_77579_b) {
            if (obj == null) continue;
            return (ItemStack)obj;
        }
        return null;
    }

    private static List<ItemStack> getRecipeSources(ShapedOreRecipe recipe) {
        for (Object obj : recipe.getInput()) {
            if (obj == null) continue;
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof ItemStack) {
                return Collections.singletonList((ItemStack)obj);
            }
            if (obj instanceof Block) {
                return Collections.singletonList(new ItemStack((Block)obj));
            }
            if (!(obj instanceof Item)) continue;
            return Collections.singletonList(new ItemStack((Item)obj));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getRecipeSources(ShapelessOreRecipe recipe) {
        for (Object obj : recipe.getInput()) {
            if (obj == null) continue;
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof ItemStack) {
                return Collections.singletonList((ItemStack)obj);
            }
            if (obj instanceof Block) {
                return Collections.singletonList(new ItemStack((Block)obj));
            }
            if (!(obj instanceof Item)) continue;
            return Collections.singletonList(new ItemStack((Item)obj));
        }
        return Collections.emptyList();
    }

    @Nullable
    public static CompressedRecipe getRecipe(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return null;
        }
        RegistryKey key = new RegistryKey(itemStack);
        CompressedRecipe foundRecipe = cachedResults.get(key);
        if (foundRecipe != null) {
            return foundRecipe;
        }
        for (CompressedRecipe recipe : recipes) {
            if (itemStack.func_77973_b() != recipe.getSourceStack().func_77973_b() || recipe.getSourceStack().func_77952_i() != Short.MAX_VALUE && recipe.getSourceStack().func_77952_i() != itemStack.func_77952_i()) continue;
            cachedResults.put(key, recipe);
            return recipe;
        }
        for (CompressedRecipe recipe : recipesSmall) {
            if (itemStack.func_77973_b() != recipe.getSourceStack().func_77973_b() || recipe.getSourceStack().func_77952_i() != Short.MAX_VALUE && recipe.getSourceStack().func_77952_i() != itemStack.func_77952_i()) continue;
            cachedResults.put(key, recipe);
            return recipe;
        }
        cachedResults.put(key, null);
        return null;
    }
}

