/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.config;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.blay09.mods.excompressum.item.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class ItemConfig {
    private static final Map<String, Entry> entries = Maps.newHashMap();

    private static void addEntry(String name, ItemStack itemStack, boolean defaultValue) {
        entries.put(name, new Entry(name, itemStack, defaultValue));
    }

    public static Collection<Entry> getEntries() {
        return entries.values();
    }

    public static boolean isEnabled(String name) {
        Entry entry = entries.get(name);
        return entry != null && entry.isEnabled();
    }

    public static void postLoad(Configuration config) {
        ItemConfig.addEntry("Compressed Crook", new ItemStack((Item)ModItems.compressedCrook), true);
        ItemConfig.addEntry("Uncompressed Coal", new ItemStack((Item)ModItems.uncompressedCoal), true);
        ItemConfig.addEntry("Bat Zapper", new ItemStack((Item)ModItems.batZapper), true);
        ItemConfig.addEntry("Ore Smasher", new ItemStack((Item)ModItems.oreSmasher), true);
        ItemConfig.addEntry("Compressed Wooden Hammer", new ItemStack((Item)ModItems.compressedHammerWood), true);
        ItemConfig.addEntry("Compressed Stone Hammer", new ItemStack((Item)ModItems.compressedHammerStone), true);
        ItemConfig.addEntry("Compressed Iron Hammer", new ItemStack((Item)ModItems.compressedHammerIron), true);
        ItemConfig.addEntry("Compressed Gold Hammer", new ItemStack((Item)ModItems.compressedHammerGold), true);
        ItemConfig.addEntry("Compressed Diamond Hammer", new ItemStack((Item)ModItems.compressedHammerDiamond), true);
        ItemConfig.addEntry("Chicken Stick", new ItemStack((Item)ModItems.chickenStick), true);
        for (Entry entry : entries.values()) {
            entry.setEnabled(config.getBoolean(entry.getName(), "items", entry.getDefaultValue(), "If set to false, the recipe for the " + entry.getName() + " will be disabled (and it won't show up in JEI)."));
        }
    }

    public static class Entry {
        private final String name;
        private final ItemStack itemStack;
        private boolean defaultValue;
        private boolean enabled;

        public Entry(String name, ItemStack itemStack, boolean defaultValue) {
            this.name = name;
            this.itemStack = itemStack;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }
    }
}

