/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.exnihiloomnia;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihiloomnia.ENOConfig;
import exnihiloomnia.registries.composting.CompostRegistry;
import exnihiloomnia.registries.composting.CompostRegistryEntry;
import exnihiloomnia.registries.hammering.HammerRegistry;
import exnihiloomnia.registries.hammering.HammerRegistryEntry;
import exnihiloomnia.registries.hammering.HammerReward;
import exnihiloomnia.registries.sifting.SieveRegistry;
import exnihiloomnia.registries.sifting.SieveRegistryEntry;
import exnihiloomnia.registries.sifting.SieveReward;
import exnihiloomnia.util.Color;
import exnihiloomnia.util.enums.EnumMetadataBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.compat.SieveModelBounds;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ExNihiloOmniaAddon
implements ExNihiloProvider,
IAddon {
    private final EnumMap<ExNihiloProvider.NihiloItems, ItemStack> itemMap = Maps.newEnumMap(ExNihiloProvider.NihiloItems.class);
    private final SieveModelBounds sieveModelBounds;

    public ExNihiloOmniaAddon() {
        ItemStack silkMeshItem;
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_WOODEN, this.findItem("hammer_wood", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_STONE, this.findItem("hammer_stone", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_IRON, this.findItem("hammer_iron", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_GOLD, this.findItem("hammer_gold", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.HAMMER_DIAMOND, this.findItem("hammer_diamond", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.CROOK_WOODEN, this.findItem("crook_wood", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SILK_MESH, this.findItem("mesh_silk_white", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SEEDS_GRASS, this.findItem("seeds_grass", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SILK_WORM, this.findItem("silkworm", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.DUST, this.findBlock("dust", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.SIEVE, this.findBlock("sieve_wood", Short.MAX_VALUE));
        this.itemMap.put(ExNihiloProvider.NihiloItems.NETHER_GRAVEL, this.findBlock("gravel_nether", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.ENDER_GRAVEL, this.findBlock("gravel_ender", 0));
        this.itemMap.put(ExNihiloProvider.NihiloItems.INFESTED_LEAVES, this.findBlock("infested_leaves", 0));
        this.sieveModelBounds = new SieveModelBounds(0.5625f, 0.0625f, 0.88f, 0.5f);
        ItemStack woodenMeshItem = this.findItem("mesh_wood", Short.MAX_VALUE);
        if (woodenMeshItem != null) {
            SieveMeshRegistryEntry woodenMesh = new SieveMeshRegistryEntry(woodenMeshItem);
            woodenMesh.setMeshLevel(1);
            woodenMesh.setSpriteLocation(new ResourceLocation("exnihiloomnia", "blocks/sieve_mesh_wood"));
            SieveMeshRegistry.add(woodenMesh);
        }
        if ((silkMeshItem = this.itemMap.get((Object)ExNihiloProvider.NihiloItems.SILK_MESH)) != null) {
            silkMeshItem = silkMeshItem.func_77946_l();
            silkMeshItem.func_77964_b(Short.MAX_VALUE);
            SieveMeshRegistryEntry silkMesh = new SieveMeshRegistryEntry(silkMeshItem);
            silkMesh.setMeshLevel(1);
            silkMesh.setSpriteLocation(new ResourceLocation("exnihiloomnia", "blocks/sieve_mesh_silk_white"));
            SieveMeshRegistry.add(silkMesh);
        }
        ExRegistro.instance = this;
    }

    @Override
    public SieveModelBounds getSieveBounds() {
        return this.sieveModelBounds;
    }

    @Override
    public Collection<HeavySieveReward> generateHeavyRewards(ItemStack sourceStack, int count) {
        SieveRegistryEntry entry;
        IBlockState state = StupidUtils.getStateFromItemStack(sourceStack);
        if (state == null) {
            return Collections.emptyList();
        }
        ArrayList rewards = Lists.newArrayList();
        SieveRegistryEntry genericEntry = SieveRegistry.getEntryForBlockState((IBlockState)state, (EnumMetadataBehavior)EnumMetadataBehavior.IGNORED);
        if (genericEntry != null) {
            for (SieveReward reward : genericEntry.getRewards()) {
                if (reward.getItem().func_77973_b() == null) {
                    ExCompressum.logger.error("Tried to generate Heavy Sieve rewards from a null reward entry: {}", new Object[]{genericEntry.getKey()});
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    rewards.add(new HeavySieveReward(reward.getItem(), (float)reward.getBaseChance() / 100.0f, 0));
                }
            }
        }
        if ((entry = SieveRegistry.getEntryForBlockState((IBlockState)state, (EnumMetadataBehavior)EnumMetadataBehavior.SPECIFIC)) != null) {
            for (SieveReward reward : entry.getRewards()) {
                if (reward.getItem().func_77973_b() == null) {
                    ExCompressum.logger.error("Tried to generate Heavy Sieve rewards from a null reward entry: {}", new Object[]{genericEntry.getKey()});
                    continue;
                }
                for (int i = 0; i < count; ++i) {
                    rewards.add(new HeavySieveReward(reward.getItem(), (float)reward.getBaseChance() / 100.0f, 0));
                }
            }
        }
        return rewards;
    }

    @Nullable
    private ItemStack findItem(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihiloomnia", name);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (item != null) {
            return new ItemStack(item, 1, withMetadata);
        }
        return null;
    }

    @Nullable
    private ItemStack findBlock(String name, int withMetadata) {
        ResourceLocation location = new ResourceLocation("exnihiloomnia", name);
        if (Block.field_149771_c.func_148741_d((Object)location)) {
            return new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)location), 1, withMetadata);
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack getNihiloItem(ExNihiloProvider.NihiloItems type) {
        return this.itemMap.get((Object)type);
    }

    @Override
    public boolean isHammerable(IBlockState state) {
        return HammerRegistry.isHammerable((IBlockState)state);
    }

    @Override
    public Collection<ItemStack> rollHammerRewards(IBlockState state, int miningLevel, float luck, Random rand) {
        HammerRegistryEntry entry = HammerRegistry.getEntryForBlockState((IBlockState)state);
        if (entry != null) {
            ArrayList list = Lists.newArrayList();
            for (HammerReward reward : entry.getRewards()) {
                if (reward.getItem().func_77973_b() == null) {
                    ExCompressum.logger.error("Tried to roll hammer rewards from a null reward entry: {} (base chance: {}, luck: {})", new Object[]{entry.getKey(), reward.getBaseChance(), reward.getFortuneModifier()});
                    continue;
                }
                int fortuneModifier = reward.getFortuneModifier();
                int chance = reward.getBaseChance() + (int)((float)fortuneModifier * luck);
                if (rand.nextInt(100) >= chance) continue;
                list.add(reward.getItem().func_77946_l());
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isSiftable(IBlockState state) {
        return SieveRegistry.isSiftable((IBlockState)state);
    }

    @Override
    public boolean isSiftableWithMesh(IBlockState state, SieveMeshRegistryEntry sieveMesh) {
        return this.isSiftable(state);
    }

    @Override
    public Collection<ItemStack> rollSieveRewards(IBlockState state, SieveMeshRegistryEntry sieveMesh, float luck, Random rand) {
        SieveRegistryEntry entry;
        ArrayList list = Lists.newArrayList();
        SieveRegistryEntry genericEntry = SieveRegistry.getEntryForBlockState((IBlockState)state, (EnumMetadataBehavior)EnumMetadataBehavior.IGNORED);
        if (genericEntry != null) {
            this.rollSieveRewardsToList(genericEntry, list, luck, rand);
        }
        if ((entry = SieveRegistry.getEntryForBlockState((IBlockState)state, (EnumMetadataBehavior)EnumMetadataBehavior.SPECIFIC)) != null) {
            this.rollSieveRewardsToList(entry, list, luck, rand);
        }
        return list;
    }

    @Override
    public Collection<ItemStack> rollCrookRewards(EntityLivingBase player, IBlockState state, float luck, Random rand) {
        ItemStack silkWormItem;
        ItemStack infestedLeaves = this.getNihiloItem(ExNihiloProvider.NihiloItems.INFESTED_LEAVES);
        if (infestedLeaves != null && (rand.nextInt(100) == 0 || state.func_177230_c() == Block.func_149634_a((Item)infestedLeaves.func_77973_b())) && (silkWormItem = this.getNihiloItem(ExNihiloProvider.NihiloItems.SILK_WORM)) != null) {
            return Lists.newArrayList((Object[])new ItemStack[]{silkWormItem.func_77946_l()});
        }
        return Collections.emptyList();
    }

    private void rollSieveRewardsToList(SieveRegistryEntry entry, List<ItemStack> list, float luck, Random rand) {
        for (SieveReward reward : entry.getRewards()) {
            if (reward.getItem().func_77973_b() == null) {
                ExCompressum.logger.error("Tried to roll sieve rewards from a null reward entry: {} (base chance: {})", new Object[]{entry.getKey(), reward.getBaseChance()});
                continue;
            }
            int tries = rand.nextInt((int)luck + 1) + 1;
            for (int i = 0; i < tries; ++i) {
                if (rand.nextInt(100) >= reward.getBaseChance()) continue;
                list.add(reward.getItem().func_77946_l());
            }
        }
    }

    @Override
    public void loadConfig(Configuration config) {
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        if (ExCompressumConfig.enableWoodChippings) {
            HammerRegistryEntry log = new HammerRegistryEntry(Blocks.field_150364_r.func_176223_P(), EnumMetadataBehavior.IGNORED);
            log.addReward(new ItemStack((Item)ModItems.woodChipping), 100, 0);
            log.addReward(new ItemStack((Item)ModItems.woodChipping), 75, 0);
            log.addReward(new ItemStack((Item)ModItems.woodChipping), 50, 0);
            log.addReward(new ItemStack((Item)ModItems.woodChipping), 25, 0);
            HammerRegistry.add((HammerRegistryEntry)log);
            HammerRegistryEntry log2 = new HammerRegistryEntry(Blocks.field_150363_s.func_176223_P(), EnumMetadataBehavior.IGNORED);
            log2.addReward(new ItemStack((Item)ModItems.woodChipping), 100, 0);
            log2.addReward(new ItemStack((Item)ModItems.woodChipping), 75, 0);
            log2.addReward(new ItemStack((Item)ModItems.woodChipping), 50, 0);
            log2.addReward(new ItemStack((Item)ModItems.woodChipping), 25, 0);
            HammerRegistry.add((HammerRegistryEntry)log2);
            List oreDictStacks = OreDictionary.getOres((String)"dustWood", (boolean)false);
            for (ItemStack itemStack : oreDictStacks) {
                CompostRegistry.add((CompostRegistryEntry)new CompostRegistryEntry(itemStack, 125, new Color(-3704794)));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientInit() {
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @Override
    public boolean doMeshesHaveDurability() {
        return !ENOConfig.classic_sieve;
    }

    @Override
    public boolean doMeshesSplitLootTables() {
        return false;
    }

    @Override
    public ExNihiloProvider.NihiloMod getNihiloMod() {
        return ExNihiloProvider.NihiloMod.OMNIA;
    }

    @Override
    public int getMeshFortune(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)meshStack);
    }

    @Override
    public int getMeshEfficiency(ItemStack meshStack) {
        return EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)meshStack);
    }
}

