/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.tile;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import net.blay09.mods.excompressum.block.BlockAutoSieveBase;
import net.blay09.mods.excompressum.block.BlockHeavySieve;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.client.render.RenderUtils;
import net.blay09.mods.excompressum.client.render.model.ModelTinyHuman;
import net.blay09.mods.excompressum.compat.SieveModelBounds;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class RenderAutoSieve
extends TileEntitySpecialRenderer<TileAutoSieveBase> {
    private final ModelTinyHuman biped = new ModelTinyHuman();
    private final boolean isHeavy;
    private IBlockState sieveState;

    public RenderAutoSieve(boolean isHeavy) {
        this.isHeavy = isHeavy;
    }

    public void renderTileEntityAt(TileAutoSieveBase tileEntity, double x, double y, double z, float partialTicks, int destroyStage) {
        IBlockState contentState;
        ItemStack currentStack;
        SieveMeshRegistryEntry sieveMesh;
        ItemStack meshStack;
        if (!tileEntity.func_145830_o()) {
            return;
        }
        IBlockState state = tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v());
        if (!(state.func_177230_c() instanceof BlockAutoSieveBase)) {
            return;
        }
        if (this.sieveState == null) {
            ItemStack nihiloSieve;
            this.sieveState = ModBlocks.heavySieve.func_176223_P();
            if (!this.isHeavy && (nihiloSieve = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SIEVE)) != null) {
                this.sieveState = Block.func_149634_a((Item)nihiloSieve.func_77973_b()).func_176223_P();
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)this.getRotationAngle((EnumFacing)state.func_177229_b((IProperty)BlockAutoSieveBase.FACING)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)0.25f);
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
        this.bindPlayerTexture(tileEntity.getCustomSkin());
        this.biped.renderAll(tileEntity, partialTicks);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179109_b((float)-0.25f, (float)0.0f, (float)-0.5f);
        GlStateManager.func_179094_E();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderUtils.renderBlockWithTranslate(mc, this.sieveState, tileEntity.func_145831_w(), tileEntity.func_174877_v(), renderer);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        SieveModelBounds bounds = ExRegistro.getSieveBounds();
        if (this.isHeavy) {
            bounds = BlockHeavySieve.SIEVE_BOUNDS;
        }
        if ((meshStack = tileEntity.getMeshStack()) != null && (sieveMesh = SieveMeshRegistry.getEntry(meshStack)) != null) {
            TextureAtlasSprite sprite;
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            TextureAtlasSprite textureAtlasSprite = sprite = sieveMesh.getSpriteLocation() != null ? mc.func_147117_R().getTextureExtry(sieveMesh.getSpriteLocation().toString()) : null;
            if (sprite == null) {
                sprite = mc.func_147117_R().func_174944_f();
            }
            int brightness = tileEntity.func_145831_w().func_175626_b(tileEntity.func_174877_v(), 0);
            float meshXZ = bounds.contentOffset;
            float meshXZ2 = 1.0f - meshXZ;
            float meshY = bounds.meshY - 0.025f;
            RenderUtils.renderQuadUp(renderer, meshXZ, meshY, meshXZ, meshXZ2, meshY, meshXZ2, -1, brightness, sprite);
            tessellator.func_78381_a();
        }
        if ((currentStack = tileEntity.getCurrentStack()) != null && (contentState = StupidUtils.getStateFromItemStack(currentStack)) != null) {
            float progress = tileEntity.getProgress();
            renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)bounds.contentOffset, (float)bounds.meshY, (float)bounds.contentOffset);
            GlStateManager.func_179152_a((float)bounds.contentScaleXZ, (float)(bounds.contentBaseScaleY - progress * bounds.contentBaseScaleY), (float)bounds.contentScaleXZ);
            RenderUtils.renderBlockWithTranslate(mc, contentState, tileEntity.func_145831_w(), tileEntity.func_174877_v(), renderer);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    private void bindPlayerTexture(GameProfile customSkin) {
        Map map;
        ResourceLocation resourceLocation = DefaultPlayerSkin.func_177335_a();
        if (customSkin != null && (map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(customSkin)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
            resourceLocation = Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        this.func_147499_a(resourceLocation);
    }

    private float getRotationAngle(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0.0f;
            }
            case EAST: {
                return -90.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 90.0f;
            }
        }
        return -90.0f;
    }
}

