/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.excompressum.IRegisterModel;
import net.blay09.mods.excompressum.block.BlockAutoCompressedHammer;
import net.blay09.mods.excompressum.block.BlockAutoCompressor;
import net.blay09.mods.excompressum.block.BlockAutoHammer;
import net.blay09.mods.excompressum.block.BlockAutoHeavySieve;
import net.blay09.mods.excompressum.block.BlockAutoSieve;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.BlockHeavySieve;
import net.blay09.mods.excompressum.block.BlockManaSieve;
import net.blay09.mods.excompressum.block.BlockWoodenCrucible;
import net.blay09.mods.excompressum.item.ItemBlockBait;
import net.blay09.mods.excompressum.item.ItemBlockCompressed;
import net.blay09.mods.excompressum.item.ItemBlockHeavySieve;
import net.blay09.mods.excompressum.item.ItemBlockWoodenCrucible;
import net.blay09.mods.excompressum.tile.TileAutoCompressedHammer;
import net.blay09.mods.excompressum.tile.TileAutoCompressor;
import net.blay09.mods.excompressum.tile.TileAutoHammer;
import net.blay09.mods.excompressum.tile.TileAutoHeavySieve;
import net.blay09.mods.excompressum.tile.TileAutoSieve;
import net.blay09.mods.excompressum.tile.TileAutoSieveMana;
import net.blay09.mods.excompressum.tile.TileBait;
import net.blay09.mods.excompressum.tile.TileHeavySieve;
import net.blay09.mods.excompressum.tile.TileWoodenCrucible;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ModBlocks {
    private static final List<Block> modBlocks = Lists.newArrayList();
    public static BlockCompressed compressedBlock;
    public static BlockHeavySieve heavySieve;
    public static BlockWoodenCrucible woodenCrucible;
    public static BlockBait bait;
    public static BlockAutoHammer autoHammer;
    public static BlockAutoCompressedHammer autoCompressedHammer;
    public static BlockAutoHeavySieve autoHeavySieve;
    public static BlockAutoSieve autoSieve;
    public static BlockManaSieve manaSieve;
    public static BlockAutoCompressor autoCompressor;

    public static void init() {
        compressedBlock = new BlockCompressed();
        ModBlocks.registerBlock(compressedBlock, (Item)new ItemBlockCompressed(compressedBlock).setRegistryName(compressedBlock.getRegistryName()));
        heavySieve = new BlockHeavySieve();
        ModBlocks.registerBlock((Block)heavySieve, (Item)new ItemBlockHeavySieve((Block)heavySieve).setRegistryName(heavySieve.getRegistryName()));
        woodenCrucible = new BlockWoodenCrucible();
        ModBlocks.registerBlock((Block)woodenCrucible, (Item)new ItemBlockWoodenCrucible((Block)woodenCrucible).setRegistryName(woodenCrucible.getRegistryName()));
        bait = new BlockBait();
        ModBlocks.registerBlock((Block)bait, (Item)new ItemBlockBait((Block)bait).setRegistryName(bait.getRegistryName()));
        autoHammer = new BlockAutoHammer("auto_hammer");
        autoCompressedHammer = new BlockAutoCompressedHammer();
        autoSieve = new BlockAutoSieve("auto_sieve");
        autoHeavySieve = new BlockAutoHeavySieve();
        autoCompressor = new BlockAutoCompressor();
        ModBlocks.registerDefaultBlock((Block)autoHammer);
        ModBlocks.registerDefaultBlock((Block)autoCompressedHammer);
        ModBlocks.registerDefaultBlock((Block)autoSieve);
        ModBlocks.registerDefaultBlock((Block)autoHeavySieve);
        ModBlocks.registerDefaultBlock((Block)autoCompressor);
        manaSieve = new BlockManaSieve();
        if (Loader.isModLoaded((String)"Botania")) {
            ModBlocks.registerDefaultBlock((Block)manaSieve);
        }
        GameRegistry.registerTileEntity(TileWoodenCrucible.class, (String)"excompressum:wooden_crucible");
        GameRegistry.registerTileEntity(TileHeavySieve.class, (String)"excompressum:heavy_sieve");
        GameRegistry.registerTileEntity(TileBait.class, (String)"excompressum:bait");
        GameRegistry.registerTileEntity(TileAutoHammer.class, (String)"excompressum:auto_hammer");
        GameRegistry.registerTileEntity(TileAutoCompressedHammer.class, (String)"excompressum:auto_compressed_hammer.json");
        GameRegistry.registerTileEntity(TileAutoSieve.class, (String)"excompressum:auto_sieve");
        GameRegistry.registerTileEntity(TileAutoHeavySieve.class, (String)"excompressum:auto_heavy_sieve");
        GameRegistry.registerTileEntity(TileAutoCompressor.class, (String)"excompressum:auto_compressor");
        if (Loader.isModLoaded((String)"Botania")) {
            GameRegistry.registerTileEntity(TileAutoSieveMana.class, (String)"excompressum:mana_sieve");
        }
    }

    private static void registerDefaultBlock(Block block) {
        ModBlocks.registerBlock(block, (Item)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    private static void registerBlock(Block block, Item itemBlock) {
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)itemBlock);
        modBlocks.add(block);
    }

    public static void registerModels() {
        for (Block block : modBlocks) {
            Item itemBlock = Item.func_150898_a((Block)block);
            if (itemBlock == null) continue;
            if (block instanceof IRegisterModel) {
                ((IRegisterModel)block).registerModel(itemBlock);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemBlock.getRegistryName(), "inventory"));
        }
    }
}

