/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.IRegisterModel;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.tile.TileBait;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBait
extends BlockContainer
implements IRegisterModel {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockBait() {
        super(Material.field_151578_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(ExCompressum.creativeTab);
        this.setRegistryName("bait");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= Type.values.length) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @Nullable
    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((Type)((Object)state.func_177229_b(VARIANT))).ordinal());
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < Type.values.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileBait();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBait tileEntity = (TileBait)world.func_175625_s(pos);
        if (tileEntity != null) {
            TileBait.EnvironmentalCondition environmentStatus = tileEntity.checkSpawnConditions(true);
            if (!world.field_72995_K) {
                TextComponentTranslation chatComponent = new TextComponentTranslation(environmentStatus.langKey, new Object[0]);
                chatComponent.func_150256_b().func_150238_a(environmentStatus != TileBait.EnvironmentalCondition.CanSpawn ? TextFormatting.RED : TextFormatting.GREEN);
                player.func_146105_b((ITextComponent)chatComponent);
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileBait tileEntity;
        if (placer instanceof EntityPlayer && (tileEntity = (TileBait)world.func_175625_s(pos)) != null) {
            TileBait.EnvironmentalCondition environmentStatus = tileEntity.checkSpawnConditions(true);
            if (!world.field_72995_K) {
                TextComponentTranslation chatComponent = new TextComponentTranslation(environmentStatus.langKey, new Object[0]);
                chatComponent.func_150256_b().func_150238_a(environmentStatus != TileBait.EnvironmentalCondition.CanSpawn ? TextFormatting.RED : TextFormatting.GREEN);
                ((EntityPlayer)placer).func_146105_b((ITextComponent)chatComponent);
            }
        }
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileBait tileEntity;
        if (!ExCompressumConfig.disableParticles && (tileEntity = (TileBait)world.func_175625_s(pos)) != null && tileEntity.checkSpawnConditions(false) == TileBait.EnvironmentalCondition.CanSpawn && rand.nextFloat() <= 0.2f) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat() * 0.5f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item) {
        ResourceLocation[] variants = new ResourceLocation[Type.values.length];
        for (int i = 0; i < variants.length; ++i) {
            variants[i] = new ResourceLocation("excompressum", "bait_" + Type.values[i].func_176610_l());
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])variants);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack itemStack) {
                Type type;
                Type type2 = type = itemStack.func_77952_i() >= 0 && itemStack.func_77952_i() < Type.values.length ? Type.values[itemStack.func_77952_i()] : null;
                if (type != null) {
                    return new ModelResourceLocation(new ResourceLocation("excompressum", "bait_" + type.func_176610_l()), "inventory");
                }
                return new ModelResourceLocation("missingno");
            }
        });
    }

    public static enum Type implements IStringSerializable
    {
        WOLF,
        OCELOT,
        COW,
        PIG,
        CHICKEN,
        SHEEP,
        SQUID,
        RABBIT,
        HORSE,
        DONKEY;

        public static Type[] values;

        @Nullable
        public static Type fromId(int id) {
            return id >= 0 && id < values.length ? values[id] : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            values = Type.values();
        }
    }
}

