/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum;

import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.config.BlockConfig;
import net.blay09.mods.excompressum.config.ItemConfig;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.ExNihiloProvider;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ModRecipes {
    public static void init() {
        int i;
        ModRecipes.registerItems();
        if (BlockConfig.isEnabled("Heavy Sieve")) {
            for (i = 0; i < 4; ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.heavySieve, 1, i), new Object[]{"p p", "ppp", "s s", Character.valueOf('p'), new ItemStack(Blocks.field_150364_r, 1, i), Character.valueOf('s'), "stickWood"}));
            }
            for (i = 0; i < 2; ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.heavySieve, 1, 4 + i), new Object[]{"p p", "ppp", "s s", Character.valueOf('p'), new ItemStack(Blocks.field_150363_s, 1, i), Character.valueOf('s'), "stickWood"}));
            }
        }
        if (BlockConfig.isEnabled("Wooden Crucible")) {
            for (i = 0; i < 4; ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.woodenCrucible, 1, i), new Object[]{"p p", "p p", "psp", Character.valueOf('p'), new ItemStack(Blocks.field_150364_r, 1, i), Character.valueOf('s'), "slabWood"}));
            }
            for (i = 0; i < 2; ++i) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.woodenCrucible, 1, 4 + i), new Object[]{"p p", "p p", "psp", Character.valueOf('p'), new ItemStack(Blocks.field_150363_s, 1, i), Character.valueOf('s'), "slabWood"}));
            }
        }
        ModRecipes.registerCompressedBlocks();
        ModRecipes.registerBaits();
        if (BlockConfig.isEnabled("Auto Compressor")) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.autoCompressor), (Object[])new Object[]{"#I#", "IBI", "#I#", Character.valueOf('#'), Blocks.field_150462_ai, Character.valueOf('B'), Blocks.field_150339_S, Character.valueOf('I'), Items.field_151042_j});
        }
        if (BlockConfig.isEnabled("Auto Hammer")) {
            ItemStack hammerDiamond = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_DIAMOND);
            if (hammerDiamond != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoHammer), new Object[]{"IPI", "IHI", "IPI", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('H'), hammerDiamond, Character.valueOf('I'), "ingotIron"}));
            } else {
                ExCompressum.logger.warn("No diamond hammer found - Auto Hammer recipe will be disabled.");
            }
        }
        if (BlockConfig.isEnabled("Auto Compressed Hammer")) {
            if (OreDictionary.getOres((String)"blockSteel", (boolean)false).isEmpty() || OreDictionary.getOres((String)"ingotSteel", (boolean)false).isEmpty()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoCompressedHammer), new Object[]{"BPB", "IHI", "BPB", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('H'), ModItems.compressedHammerDiamond, Character.valueOf('B'), "blockIron", Character.valueOf('I'), "ingotIron"}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoCompressedHammer), new Object[]{"IPI", "IHI", "IPI", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('H'), ModItems.compressedHammerDiamond, Character.valueOf('B'), "blockSteel", Character.valueOf('I'), "ingotSteel"}));
            }
        }
        if (BlockConfig.isEnabled("Auto Sieve")) {
            ItemStack sieveBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SIEVE);
            if (sieveBlock != null) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoSieve), new Object[]{"BGB", "GSG", "IGI", Character.valueOf('B'), "blockIron", Character.valueOf('S'), sieveBlock, Character.valueOf('G'), "paneGlassColorless", Character.valueOf('I'), "ingotIron"}));
            } else {
                ExCompressum.logger.warn("No Sieve found - Auto Sieve recipe will be disabled.");
            }
        }
        if (BlockConfig.isEnabled("Auto Heavy Sieve")) {
            if (OreDictionary.getOres((String)"blockSteel", (boolean)false).isEmpty() || OreDictionary.getOres((String)"ingotSteel", (boolean)false).isEmpty()) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoHeavySieve), new Object[]{"BGB", "GSG", "IGI", Character.valueOf('B'), "blockIron", Character.valueOf('S'), new ItemStack((Block)ModBlocks.heavySieve, 1, Short.MAX_VALUE), Character.valueOf('G'), "paneGlassColorless", Character.valueOf('I'), "ingotIron"}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.autoHeavySieve), new Object[]{"BGB", "GSG", "IGI", Character.valueOf('B'), "blockSteel", Character.valueOf('S'), new ItemStack((Block)ModBlocks.heavySieve, 1, Short.MAX_VALUE), Character.valueOf('G'), "paneGlassColorless", Character.valueOf('I'), "ingotSteel"}));
            }
        }
        if (Loader.isModLoaded((String)"Botania") && BlockConfig.isEnabled("Mana Sieve")) {
            ResourceLocation manaSteelLocation = new ResourceLocation("Botania", "storage");
            if (Block.field_149771_c.func_148741_d((Object)manaSteelLocation)) {
                ItemStack sieveBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SIEVE);
                if (sieveBlock != null) {
                    ItemStack manaSteelBlockStack = new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)manaSteelLocation));
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)ModBlocks.manaSieve), new Object[]{"BGB", "GSG", "IGI", Character.valueOf('B'), manaSteelBlockStack, Character.valueOf('S'), sieveBlock, Character.valueOf('G'), "paneGlassColorless", Character.valueOf('I'), "ingotManasteel"}));
                } else {
                    ExCompressum.logger.warn("No Sieve found - Mana Sieve recipe will be disabled.");
                }
            } else {
                ExCompressum.logger.warn("No Manasteel Block found - Mana Sieve recipe will be disabled.");
            }
        }
    }

    private static void registerItems() {
        if (ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.IRON_MESH) == null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.ironMesh), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Blocks.field_150411_aY});
        }
        ModRecipes.registerCompressedHammers();
        if (ItemConfig.isEnabled("Compressed Crook")) {
            ItemStack itemCrook = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.CROOK_WOODEN);
            if (itemCrook != null) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedCrook), (Object[])new Object[]{"## ", " # ", " # ", Character.valueOf('#'), itemCrook});
            } else {
                ExCompressum.logger.warn("No Crook found - Compressed Crook recipe will be disabled.");
            }
        }
        if (ItemConfig.isEnabled("Uncompressed Coal")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)ModItems.uncompressedCoal, 8), (Object[])new Object[]{Items.field_151044_h});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151044_h), (Object[])new Object[]{new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal), new ItemStack((Item)ModItems.uncompressedCoal)});
        }
        GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){

            public int getBurnTime(ItemStack itemStack) {
                if (itemStack.func_77973_b() == ModItems.uncompressedCoal) {
                    return 200;
                }
                return 0;
            }
        });
        if (ItemConfig.isEnabled("Bat Zapper")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.batZapper), new Object[]{" RG", " SR", "S  ", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), Items.field_151114_aO, Character.valueOf('S'), "stickWood"}));
        }
        if (ItemConfig.isEnabled("Ore Smasher")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.oreSmasher), new Object[]{" CD", " SC", "S  ", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('S'), "stickWood"}));
        }
    }

    private static void registerCompressedHammers() {
        ItemStack nihiloHammer;
        if (ItemConfig.isEnabled("Compressed Wooden Hammer")) {
            nihiloHammer = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_WOODEN);
            if (nihiloHammer != null) {
                if (nihiloHammer.func_77952_i() == Short.MAX_VALUE) {
                    nihiloHammer = new ItemStack(nihiloHammer.func_77973_b(), 1, 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerWood), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), nihiloHammer});
            } else {
                ExCompressum.logger.warn("No Wooden Hammer found - Compressed Wooden Hammer recipe will be disabled.");
            }
        }
        if (ItemConfig.isEnabled("Compressed Stone Hammer")) {
            nihiloHammer = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_STONE);
            if (nihiloHammer != null) {
                if (nihiloHammer.func_77952_i() == Short.MAX_VALUE) {
                    nihiloHammer = new ItemStack(nihiloHammer.func_77973_b(), 1, 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerStone), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), nihiloHammer});
            } else {
                ExCompressum.logger.warn("No Stone Hammer found - Compressed Stone Hammer recipe will be disabled.");
            }
        }
        if (ItemConfig.isEnabled("Compressed Iron Hammer")) {
            nihiloHammer = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_IRON);
            if (nihiloHammer != null) {
                if (nihiloHammer.func_77952_i() == Short.MAX_VALUE) {
                    nihiloHammer = new ItemStack(nihiloHammer.func_77973_b(), 1, 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerIron), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), nihiloHammer});
            } else {
                ExCompressum.logger.warn("No Iron Hammer found - Compressed Iron Hammer recipe will be disabled.");
            }
        }
        if (ItemConfig.isEnabled("Compressed Gold Hammer")) {
            nihiloHammer = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_GOLD);
            if (nihiloHammer != null) {
                if (nihiloHammer.func_77952_i() == Short.MAX_VALUE) {
                    nihiloHammer = new ItemStack(nihiloHammer.func_77973_b(), 1, 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerGold), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), nihiloHammer});
            } else {
                ExCompressum.logger.warn("No Gold Hammer found - Compressed Gold Hammer recipe will be disabled.");
            }
        }
        if (ItemConfig.isEnabled("Compressed Diamond Hammer")) {
            nihiloHammer = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.HAMMER_DIAMOND);
            if (nihiloHammer != null) {
                if (nihiloHammer.func_77952_i() == Short.MAX_VALUE) {
                    nihiloHammer = new ItemStack(nihiloHammer.func_77973_b(), 1, 0);
                }
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerDiamond), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), nihiloHammer});
            } else {
                ExCompressum.logger.warn("No Diamond Hammer found - Compressed Diamond Hammer recipe will be disabled.");
            }
        }
    }

    private static void registerCompressedBlocks() {
        if (BlockConfig.isEnabled("Compressed Dust")) {
            OreDictionary.registerOre((String)"compressed1xDust", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DUST.ordinal()));
            ItemStack dustBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.DUST);
            if (dustBlock != null) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, 0), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), dustBlock});
                GameRegistry.addShapelessRecipe((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)dustBlock, (int)9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, 0)});
            } else {
                ExCompressum.logger.warn("No Dust found - Compressed Dust recipe will be disabled.");
            }
        }
        if (BlockConfig.isEnabled("Compressed Cobblestone")) {
            OreDictionary.registerOre((String)"compressed1xCobblestone", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.COBBLESTONE.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.COBBLESTONE.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150347_e});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150347_e, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.COBBLESTONE.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Gravel")) {
            OreDictionary.registerOre((String)"compressed1xGravel", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150351_n});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150351_n, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Sand")) {
            OreDictionary.registerOre((String)"compressed1xSand", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150354_m});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)Blocks.field_150354_m, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Dirt")) {
            OreDictionary.registerOre((String)"compressed1xDirt", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(Blocks.field_150346_d, 1, 0)});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150346_d, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Flint")) {
            OreDictionary.registerOre((String)"compressed1xFlint", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.FLINT.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.FLINT.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Items.field_151145_ak});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151145_ak, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.FLINT.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Ender Gravel")) {
            ItemStack enderGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.ENDER_GRAVEL);
            if (enderGravelBlock != null) {
                OreDictionary.registerOre((String)"compressed1xEnderGravel", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal()));
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), enderGravelBlock});
                GameRegistry.addShapelessRecipe((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)enderGravelBlock, (int)9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal())});
            } else {
                ExCompressum.logger.warn("No Ender Gravel found - Compressed Ender Gravel recipe will be disabled.");
            }
        }
        if (BlockConfig.isEnabled("Compressed Nether Gravel")) {
            ItemStack netherGravelBlock = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.NETHER_GRAVEL);
            if (netherGravelBlock != null) {
                OreDictionary.registerOre((String)"compressed1xNetherGravel", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal()));
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), netherGravelBlock});
                GameRegistry.addShapelessRecipe((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)netherGravelBlock, (int)9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal())});
            } else {
                ExCompressum.logger.warn("No Nether Gravel found - Compressed Nether Gravel recipe will be disabled.");
            }
        }
        if (BlockConfig.isEnabled("Compressed Soul Sand")) {
            OreDictionary.registerOre((String)"compressed1xSoulsand", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150425_aM});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150425_aM, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed Netherrack")) {
            OreDictionary.registerOre((String)"compressed1xNetherrack", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHERRACK.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHERRACK.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150424_aL});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150424_aL, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHERRACK.ordinal())});
        }
        if (BlockConfig.isEnabled("Compressed End Stone")) {
            OreDictionary.registerOre((String)"compressed1xEndStone", (ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.END_STONE.ordinal()));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.END_STONE.ordinal()), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), Blocks.field_150377_bs});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150377_bs, 9), (Object[])new Object[]{new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.END_STONE.ordinal())});
        }
    }

    private static void registerBaits() {
        if (BlockConfig.isEnabled("Wolf Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.WOLF.ordinal()), (Object[])new Object[]{Items.field_151103_aS, Items.field_151082_bd});
        }
        if (BlockConfig.isEnabled("Ocelot Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.OCELOT.ordinal()), (Object[])new Object[]{Items.field_151016_H, new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE)});
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.OCELOT.ordinal()), new Object[]{Items.field_151016_H, "listAllfishraw"}));
        }
        if (BlockConfig.isEnabled("Cow Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.COW.ordinal()), (Object[])new Object[]{Items.field_151015_O, Items.field_151015_O});
        }
        if (BlockConfig.isEnabled("Pig Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.PIG.ordinal()), (Object[])new Object[]{Items.field_151172_bF, Items.field_151172_bF});
        }
        if (BlockConfig.isEnabled("Chicken Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.CHICKEN.ordinal()), (Object[])new Object[]{Items.field_151014_N, Items.field_151014_N});
        }
        if (BlockConfig.isEnabled("Sheep Bait")) {
            ItemStack grassSeeds = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SEEDS_GRASS);
            if (grassSeeds != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SHEEP.ordinal()), (Object[])new Object[]{grassSeeds, Items.field_151015_O});
            } else {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SHEEP.ordinal()), (Object[])new Object[]{Items.field_151014_N, Items.field_151015_O});
            }
        }
        if (BlockConfig.isEnabled("Squid Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SQUID.ordinal()), (Object[])new Object[]{Items.field_151115_aP, Items.field_151115_aP});
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SQUID.ordinal()), new Object[]{"listAllfishraw", "listAllfishraw"}));
        }
        if (BlockConfig.isEnabled("Rabbit Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.RABBIT.ordinal()), (Object[])new Object[]{Items.field_151172_bF, Items.field_151081_bc});
        }
        if (BlockConfig.isEnabled("Horse Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.HORSE.ordinal()), (Object[])new Object[]{Items.field_151153_ao, Items.field_151153_ao});
        }
        if (BlockConfig.isEnabled("Donkey Bait")) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.DONKEY.ordinal()), (Object[])new Object[]{Items.field_151150_bK, Items.field_151150_bK});
        }
    }
}

