/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.init;

import com.phylogeny.extrabitmanipulation.config.ConfigRecipe;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ItemsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.recipe.RecipeChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipesExtraBitManipulation {
    public static void recipeInit() {
        if (!Configs.disableDiamondNuggetOreDict) {
            OreDictionary.registerOre((String)"nuggetDiamond", (Item)ItemsExtraBitManipulation.diamondNugget);
        }
        if (!Configs.disableDiamondToNuggets) {
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(Items.field_151045_i), new Object[]{"nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond", "nuggetDiamond"}));
        }
        if (!Configs.disableNuggetsToDiamond) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ItemsExtraBitManipulation.diamondNugget, 9), (Object[])new Object[]{Items.field_151045_i});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150347_e), (Object[])new Object[]{BlocksExtraBitManipulation.bodyPartTemplate});
        for (Item item : Configs.itemRecipeMap.keySet()) {
            ConfigRecipe configRecipe = (ConfigRecipe)Configs.itemRecipeMap.get(item);
            if (!configRecipe.isEnabled) continue;
            RecipesExtraBitManipulation.registerRecipe(item, configRecipe.isShaped, configRecipe.useOreDictionary, configRecipe.recipe, configRecipe.getRecipeDefault());
        }
        RecipeSorter.register((String)"ExtraBitManipulation:chiseled_armor", RecipeChiseledArmor.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(ItemsExtraBitManipulation.chiseledHelmet, (Item)Items.field_151161_ac, 272);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(ItemsExtraBitManipulation.chiseledChestplate, (Item)Items.field_151163_ad, 444);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(ItemsExtraBitManipulation.chiseledLeggings, (Item)Items.field_151173_ae, 572);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(ItemsExtraBitManipulation.chiseledBoots, (Item)Items.field_151175_af, 272);
    }

    private static void registerChiseledArmorRecipes(Item output, Item inputArmor, int bitCost) {
        ModItems items = ChiselsAndBits.getItems();
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(output, inputArmor, (Item)items.itemChiselStone, bitCost);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(output, inputArmor, (Item)items.itemChiselIron, bitCost);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(output, inputArmor, (Item)items.itemChiselGold, bitCost);
        RecipesExtraBitManipulation.registerChiseledArmorRecipes(output, inputArmor, (Item)items.itemChiselDiamond, bitCost);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(output), (Object[])new Object[]{output});
    }

    private static void registerChiseledArmorRecipes(Item output, Item input, Item inputChisel, int bitCost) {
        RecipesExtraBitManipulation.registerChiseledArmorRecipe(output, input, inputChisel, bitCost);
        RecipesExtraBitManipulation.registerChiseledArmorRecipe(input, output, inputChisel, bitCost);
    }

    private static void registerChiseledArmorRecipe(Item output, Item input, Item inputChisel, int bitCost) {
        GameRegistry.addRecipe((IRecipe)new RecipeChiseledArmor(output, input, inputChisel, bitCost));
    }

    private static void registerRecipe(Item item, boolean isShaped, boolean useOreDictionary, String[] userInput, String[] defaultInput) {
        Object[] recipeArray;
        Object[] objectArray = recipeArray = isShaped ? RecipesExtraBitManipulation.createShapedRecipeArray(userInput, useOreDictionary, isShaped) : RecipesExtraBitManipulation.createShapelessRecipeArray(userInput, useOreDictionary, isShaped);
        if (recipeArray == null && defaultInput.length > 0) {
            Object[] objectArray2 = recipeArray = isShaped ? RecipesExtraBitManipulation.createShapedRecipeArray(defaultInput, useOreDictionary, isShaped) : RecipesExtraBitManipulation.createShapelessRecipeArray(defaultInput, useOreDictionary, isShaped);
        }
        if (recipeArray != null) {
            if (isShaped) {
                if (useOreDictionary) {
                    GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(item), recipeArray));
                } else {
                    GameRegistry.addRecipe((ItemStack)new ItemStack(item), (Object[])recipeArray);
                }
            } else if (useOreDictionary) {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(item), recipeArray));
            } else {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(item), (Object[])recipeArray);
            }
        }
    }

    private static Object[] createShapedRecipeArray(String[] inputArr, boolean useOreDictionary, boolean isShaped) {
        Object[] recipe = null;
        double r = Math.sqrt(inputArr.length);
        if (r == (double)((int)r) && r > 0.0) {
            int i;
            int root = (int)r;
            ArrayList<String> template = new ArrayList<String>();
            ArrayList<Character> ingredients = new ArrayList<Character>();
            String templateString = "";
            for (i = 0; i < inputArr.length; ++i) {
                String name = inputArr[i];
                char character = RecipesExtraBitManipulation.isValidName(useOreDictionary, name) ? (char)(i + 65) : (char)' ';
                if ((templateString = templateString + character).length() == root) {
                    template.add(templateString);
                    templateString = "";
                }
                if (character == 32) continue;
                ingredients.add(Character.valueOf(character));
                RecipesExtraBitManipulation.addIngredient(ingredients, name, useOreDictionary, isShaped);
            }
            if (!ingredients.isEmpty()) {
                recipe = new Object[root + ingredients.size()];
                for (i = 0; i < recipe.length; ++i) {
                    recipe[i] = i < root ? template.get(i) : ingredients.get(i - root);
                }
            }
        }
        return recipe;
    }

    private static Object[] createShapelessRecipeArray(String[] inputArr, boolean useOreDictionary, boolean isShaped) {
        Object[] recipe = null;
        if (inputArr.length > 0) {
            int i;
            ArrayList ingredients = new ArrayList();
            for (i = 0; i < inputArr.length; ++i) {
                String name = inputArr[i];
                if (!RecipesExtraBitManipulation.isValidName(useOreDictionary, name)) continue;
                RecipesExtraBitManipulation.addIngredient(ingredients, name, useOreDictionary, isShaped);
            }
            if (!ingredients.isEmpty()) {
                recipe = new Object[ingredients.size()];
                for (i = 0; i < recipe.length; ++i) {
                    recipe[i] = ingredients.get(i);
                }
            }
        }
        return recipe;
    }

    private static void addIngredient(ArrayList ingredients, String name, boolean useOreDictionary, boolean isShaped) {
        if (useOreDictionary) {
            if (isShaped || !ingredients.contains(name)) {
                ingredients.add(name);
            }
        } else {
            ItemStack stack = RecipesExtraBitManipulation.getStack(Item.func_111206_d((String)name));
            if (isShaped || !ingredients.contains(stack)) {
                ingredients.add(stack);
            }
        }
    }

    private static boolean isValidName(boolean useOreDictionary, String name) {
        if (useOreDictionary) {
            return OreDictionary.doesOreNameExist((String)name);
        }
        return Item.func_111206_d((String)name) != null;
    }

    private static ItemStack getStack(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }
}

