/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.IMultiStateBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Level;

public class BitIOHelper {
    public static Map<IBlockState, IBitBrush> getModelBitMapFromEntryStrings(String[] entryStrings) {
        HashMap<IBlockState, IBitBrush> bitMap = new HashMap<IBlockState, IBitBrush>();
        for (String entryString : entryStrings) {
            IBlockState value;
            String[] entryStringArray;
            IBlockState key;
            if (entryString.indexOf("-") < 0 || entryString.length() < 3 || (key = BitIOHelper.getStateFromString((entryStringArray = entryString.split("-"))[0])) == null || BitIOHelper.isAir(key) || (value = BitIOHelper.getStateFromString(entryStringArray[1])) == null) continue;
            try {
                bitMap.put(key, ChiselsAndBitsAPIAccess.apiInstance.createBrushFromState(value));
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        return bitMap;
    }

    public static String[] getEntryStringsFromModelBitMap(Map<IBlockState, IBitBrush> bitMap) {
        String[] entryStrings = new String[bitMap.size()];
        int index = 0;
        for (Map.Entry<IBlockState, IBitBrush> entry : bitMap.entrySet()) {
            entryStrings[index++] = BitIOHelper.getModelBitMapEntryString(entry);
        }
        return entryStrings;
    }

    public static void stateToBitMapToBytes(ByteBuf buffer, Map<IBlockState, IBitBrush> stateToBitMap) {
        if (BitIOHelper.notNullToBuffer(buffer, stateToBitMap)) {
            BitIOHelper.objectToBytes(buffer, BitIOHelper.stateToBitMapToStateIdArray(stateToBitMap));
        }
    }

    public static Map<IBlockState, IBitBrush> stateToBitMapFromBytes(ByteBuf buffer) {
        HashMap<IBlockState, IBitBrush> stateToBitMap = new HashMap<IBlockState, IBitBrush>();
        if (!buffer.readBoolean()) {
            return stateToBitMap;
        }
        int[] mapArray = (int[])BitIOHelper.objectFromBytes(buffer);
        if (mapArray == null) {
            return stateToBitMap;
        }
        BitIOHelper.stateToBitMapFromStateIdArray(stateToBitMap, mapArray, ChiselsAndBitsAPIAccess.apiInstance);
        return stateToBitMap;
    }

    private static int[] stateToBitMapToStateIdArray(Map<IBlockState, IBitBrush> stateToBitMap) {
        int counter = 0;
        int[] mapArray = new int[stateToBitMap.size() * 2];
        for (Map.Entry<IBlockState, IBitBrush> entry : stateToBitMap.entrySet()) {
            mapArray[counter++] = Block.func_176210_f((IBlockState)entry.getKey());
            mapArray[counter++] = entry.getValue().getStateID();
        }
        return mapArray;
    }

    private static void stateToBitMapFromStateIdArray(Map<IBlockState, IBitBrush> stateToBitMap, int[] mapArray, IChiselAndBitsAPI api) {
        for (int i = 0; i < mapArray.length; i += 2) {
            IBlockState state = Block.func_176220_d((int)mapArray[i]);
            if (BitIOHelper.isAir(state)) continue;
            try {
                stateToBitMap.put(state, api.createBrushFromState(Block.func_176220_d((int)mapArray[i + 1])));
                continue;
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
    }

    public static void writeStateToBitMapToNBT(ItemStack bitStack, String key, Map<IBlockState, IBitBrush> stateToBitMap, boolean saveStatesById) {
        if (!bitStack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = ItemStackHelper.getNBT(bitStack);
        if (saveStatesById) {
            BitIOHelper.writeObjectToNBT(nbt, key + 0, BitIOHelper.stateToBitMapToStateIdArray(stateToBitMap));
            nbt.func_82580_o(key + 1);
            nbt.func_82580_o(key + 2);
            nbt.func_82580_o(key + 3);
        } else {
            int counter = 0;
            int n = stateToBitMap.size();
            boolean isBlockMap = key.equals("blockToBitMapPermanent");
            String[] domainArray = new String[n * 2];
            String[] pathArray = new String[n * 2];
            byte[] metaArray = new byte[isBlockMap ? n : n * 2];
            for (Map.Entry<IBlockState, IBitBrush> entry : stateToBitMap.entrySet()) {
                BitIOHelper.saveStateToMapArrays(domainArray, pathArray, isBlockMap ? null : metaArray, counter++, isBlockMap, entry.getKey());
                BitIOHelper.saveStateToMapArrays(domainArray, pathArray, metaArray, counter++, isBlockMap, Block.func_176220_d((int)entry.getValue().getStateID()));
            }
            nbt.func_82580_o(key + 0);
            BitIOHelper.writeObjectToNBT(nbt, key + 1, domainArray);
            BitIOHelper.writeObjectToNBT(nbt, key + 2, pathArray);
            BitIOHelper.writeObjectToNBT(nbt, key + 3, metaArray);
        }
    }

    private static void saveStateToMapArrays(String[] domainArray, String[] pathArray, byte[] metaArray, int index, boolean isBlockMap, IBlockState state) {
        ResourceLocation regName = state.func_177230_c().getRegistryName();
        if (regName == null) {
            return;
        }
        domainArray[index] = regName.func_110624_b();
        pathArray[index] = regName.func_110623_a();
        if (metaArray != null) {
            metaArray[isBlockMap ? index / 2 : index] = (byte)state.func_177230_c().func_176201_c(state);
        }
    }

    public static Map<IBlockState, IBitBrush> readStateToBitMapFromNBT(IChiselAndBitsAPI api, ItemStack bitStack, String key) {
        boolean saveStatesById;
        HashMap<IBlockState, IBitBrush> stateToBitMap = new HashMap<IBlockState, IBitBrush>();
        if (!bitStack.func_77942_o()) {
            return stateToBitMap;
        }
        NBTTagCompound nbt = ItemStackHelper.getNBT(bitStack);
        boolean bl = saveStatesById = !nbt.func_74764_b(key + 2);
        if (saveStatesById ? !nbt.func_74764_b(key + 0) : !nbt.func_74764_b(key + 1) || !nbt.func_74764_b(key + 3)) {
            return stateToBitMap;
        }
        if (saveStatesById) {
            int[] mapArray = (int[])BitIOHelper.readObjectFromNBT(nbt, key + 0);
            if (mapArray == null) {
                return stateToBitMap;
            }
            BitIOHelper.stateToBitMapFromStateIdArray(stateToBitMap, mapArray, api);
        } else {
            String[] domainArray = (String[])BitIOHelper.readObjectFromNBT(nbt, key + 1);
            String[] pathArray = (String[])BitIOHelper.readObjectFromNBT(nbt, key + 2);
            byte[] metaArray = (byte[])BitIOHelper.readObjectFromNBT(nbt, key + 3);
            if (domainArray == null || pathArray == null || metaArray == null) {
                return stateToBitMap;
            }
            boolean isBlockMap = key.equals("blockToBitMapPermanent");
            for (int i = 0; i < domainArray.length; i += 2) {
                IBlockState state = BitIOHelper.readStateFromMapArrays(domainArray, pathArray, isBlockMap ? null : metaArray, i, isBlockMap);
                if (BitIOHelper.isAir(state)) continue;
                try {
                    stateToBitMap.put(state, api.createBrushFromState(BitIOHelper.readStateFromMapArrays(domainArray, pathArray, metaArray, i + 1, isBlockMap)));
                    continue;
                }
                catch (APIExceptions.InvalidBitItem invalidBitItem) {
                    // empty catch block
                }
            }
        }
        return stateToBitMap;
    }

    private static IBlockState readStateFromMapArrays(String[] domainArray, String[] pathArray, byte[] metaArray, int index, boolean isBlockMap) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(domainArray[index], pathArray[index]));
        return block == null ? Blocks.field_150350_a.func_176223_P() : (metaArray != null ? BitIOHelper.getStateFromMeta(block, metaArray[isBlockMap ? index / 2 : index]) : block.func_176223_P());
    }

    private static byte[] compressObject(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream objectStream = new ObjectOutputStream(new DeflaterOutputStream(byteStream));
        objectStream.writeObject(object);
        objectStream.close();
        return byteStream.toByteArray();
    }

    private static Object decompressObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return new ObjectInputStream(new InflaterInputStream(new ByteArrayInputStream(bytes))).readObject();
    }

    private static void writeObjectToNBT(NBTTagCompound nbt, String key, Object object) {
        try {
            nbt.func_74773_a(key, BitIOHelper.compressObject(object));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object readObjectFromNBT(NBTTagCompound nbt, String key) {
        try {
            return BitIOHelper.decompressObject(nbt.func_74770_j(key));
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Object objectFromBytes(ByteBuf buffer) {
        int length = buffer.readInt();
        if (length == 0) {
            return null;
        }
        try {
            byte[] bytes = new byte[length];
            buffer.readBytes(bytes);
            return BitIOHelper.decompressObject(bytes);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void objectToBytes(ByteBuf buffer, Object object) {
        try {
            byte[] bytes = BitIOHelper.compressObject(object);
            buffer.writeInt(bytes.length);
            buffer.writeBytes(bytes);
        }
        catch (IOException e) {
            buffer.writeInt(0);
        }
    }

    public static void readStatesFromNBT(NBTTagCompound nbt, Map<IBlockState, Integer> stateMap, IBlockState[][][] stateArray) {
        int i;
        String key = "savedStates";
        int[] stateIDs = (int[])BitIOHelper.readObjectFromNBT(nbt, key);
        if (stateIDs == null) {
            stateIDs = new int[4096];
        }
        for (int n = 0; n < stateIDs.length; ++n) {
            IBlockState state;
            i = n / 256;
            int n2 = n % 256;
            int j = n2 / 16;
            int k = n2 % 16;
            stateArray[i][j][k] = state = Block.func_176220_d((int)stateIDs[n]);
            if (BitIOHelper.isAir(state)) continue;
            stateMap.put(state, 1 + (stateMap.containsKey(state) ? stateMap.get(state) : 0));
        }
        if (stateIDs.length == 0) {
            IBlockState air = Blocks.field_150350_a.func_176223_P();
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        stateArray[i][j][k] = air;
                    }
                }
            }
        }
    }

    public static void saveBlockStates(IChiselAndBitsAPI api, EntityPlayer player, World world, AxisAlignedBB box, NBTTagCompound nbt) {
        if (world.field_72995_K) {
            return;
        }
        int[] stateIDs = new int[4096];
        int index = 0;
        int diffX = 16 - (int)(box.field_72336_d - box.field_72340_a);
        int diffZ = 16 - (int)(box.field_72334_f - box.field_72339_c);
        int halfDiffX = diffX / 2;
        int halfDiffZ = diffZ / 2;
        int minX = (int)(box.field_72340_a - (double)halfDiffX);
        int maxX = (int)(box.field_72336_d + (double)(diffX - halfDiffX));
        int minZ = (int)(box.field_72339_c - (double)halfDiffZ);
        int maxZ = (int)(box.field_72334_f + (double)(diffZ - halfDiffZ));
        IBlockState airState = Blocks.field_150350_a.func_176223_P();
        for (int x = minX; x < maxX; ++x) {
            int y = (int)box.field_72338_b;
            while ((double)y < box.field_72338_b + 16.0) {
                for (int z = minZ; z < maxZ; ++z) {
                    IBlockState state;
                    if ((double)y <= box.field_72337_e && (double)x >= box.field_72340_a && (double)x <= box.field_72336_d && (double)z >= box.field_72339_c && (double)z <= box.field_72334_f) {
                        BlockPos pos = new BlockPos(x, y, z);
                        state = world.func_180495_p(pos);
                        if (api.isBlockChiseled(world, pos) && state.func_177230_c() instanceof IMultiStateBlock) {
                            state = ((IMultiStateBlock)state.func_177230_c()).getPrimaryState((IBlockAccess)world, pos);
                        }
                    } else {
                        state = airState;
                    }
                    stateIDs[index++] = Block.func_176210_f((IBlockState)state);
                }
                ++y;
            }
        }
        String key = "savedStates";
        BitIOHelper.writeObjectToNBT(nbt, key, stateIDs);
        player.field_71069_bz.func_75142_b();
    }

    public static boolean isAir(IBlockState state) {
        return state.equals(Blocks.field_150350_a.func_176223_P());
    }

    public static boolean isAir(Block block) {
        return block.equals(Blocks.field_150350_a);
    }

    public static void stateToBytes(ByteBuf buffer, IBlockState state) {
        buffer.writeInt(Block.func_176210_f((IBlockState)state));
    }

    public static IBlockState stateFromBytes(ByteBuf buffer) {
        return Block.func_176220_d((int)buffer.readInt());
    }

    public static IBlockState getStateFromString(String stateString) {
        Block block;
        if (stateString.isEmpty()) {
            return null;
        }
        int meta = -1;
        int i = stateString.lastIndexOf(":");
        if (i >= 0 && i < stateString.length() - 1) {
            try {
                meta = Integer.parseInt(stateString.substring(i + 1));
                stateString = stateString.substring(0, i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((block = Block.func_149684_b((String)stateString)) == null) {
            FMLLog.log((String)"Extra Bit Manipulation", (Level)Level.ERROR, (String)("Block failed to load from the following string: " + stateString), (Object[])new Object[0]);
            return null;
        }
        return meta < 0 ? block.func_176223_P() : BitIOHelper.getStateFromMeta(block, meta);
    }

    public static IBlockState getStateFromMeta(Block block, int meta) {
        return block.func_176203_a(meta);
    }

    public static String getStringFromState(IBlockState state) {
        if (state == null) {
            return "minecraft:air";
        }
        Block block = state.func_177230_c();
        ResourceLocation regName = block.getRegistryName();
        if (regName == null) {
            return "minecraft:air";
        }
        String valueString = regName.func_110624_b() + ":" + regName.func_110623_a();
        if (!state.equals(block.func_176223_P())) {
            valueString = valueString + ":" + block.func_176201_c(state);
        }
        return valueString;
    }

    public static boolean hasBitMapsInNbt(ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
        for (int i = 0; i < 4; ++i) {
            if (!nbt.func_74764_b("stateToBitMapPermanent" + i) && !nbt.func_74764_b("blockToBitMapPermanent" + i)) continue;
            return true;
        }
        return false;
    }

    public static void clearAllBitMapsFromNbt(ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
        for (int i = 0; i < 4; ++i) {
            nbt.func_82580_o("stateToBitMapPermanent" + i);
            nbt.func_82580_o("blockToBitMapPermanent" + i);
        }
    }

    public static boolean areSortedBitMapsIdentical(Map<IBlockState, IBitBrush> map1, Map<IBlockState, IBitBrush> map2) {
        int n = map1.size();
        if (n != map2.size()) {
            return false;
        }
        int matches = 0;
        Iterator<Map.Entry<IBlockState, IBitBrush>> iterator1 = map1.entrySet().iterator();
        Iterator<Map.Entry<IBlockState, IBitBrush>> iterator2 = map2.entrySet().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Map.Entry<IBlockState, IBitBrush> entry1 = iterator1.next();
            Map.Entry<IBlockState, IBitBrush> entry2 = iterator2.next();
            if (!BitIOHelper.getModelBitMapEntryString(entry1).equals(BitIOHelper.getModelBitMapEntryString(entry2))) continue;
            ++matches;
        }
        return matches == n;
    }

    private static String getModelBitMapEntryString(Map.Entry<IBlockState, IBitBrush> entry) {
        return BitIOHelper.getStringFromState(entry.getKey()) + "-" + BitIOHelper.getStringFromState(entry.getValue().getState());
    }

    public static boolean notNullToBuffer(ByteBuf buffer, Object object) {
        boolean notNull = object != null;
        buffer.writeBoolean(notNull);
        return notNull;
    }
}

