/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui.armor;

import com.google.common.base.Predicate;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiListEntryChiseledArmor;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonBase;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Keyboard;

public class GuiListEntryGlOperation<L>
extends GuiListEntryChiseledArmor<GlOperation> {
    private static final ResourceLocation TEXTURE_ROTATION = new ResourceLocation("ExtraBitManipulation", "textures/guis/rotation.png");
    private static final ResourceLocation TEXTURE_TRANSLATION = new ResourceLocation("ExtraBitManipulation", "textures/guis/translation.png");
    private static final ResourceLocation TEXTURE_SCALE = new ResourceLocation("ExtraBitManipulation", "textures/guis/scale.png");
    private static int scaleFactor;
    private List<GuiTextField> dataFields = new ArrayList<GuiTextField>();
    private GuiButtonExt buttonPlus;
    private GuiButtonExt buttonMinus;
    private ResourceLocation textureIcon;
    private boolean iconHovered;
    private int index;
    private final Predicate<String> numberFilter = new Predicate<String>(){

        public boolean apply(@Nullable String text) {
            if (StringUtils.func_151246_b((String)text) || text.equals("-")) {
                return true;
            }
            try {
                Float.parseFloat(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public boolean equals(@Nullable Object object) {
            return super.equals(object);
        }
    };

    public GuiListEntryGlOperation(GuiListChiseledArmor<GlOperation> listChiseledArmor, GlOperation entryObject, int index) {
        super(listChiseledArmor, entryObject);
        int len = entryObject.getType() == GlOperation.GlOperationType.ROTATION ? 4 : 3;
        for (int i = 0; i < len; ++i) {
            float data;
            float f = i == 0 ? entryObject.getX() : (i == 1 ? entryObject.getY() : (data = i == 2 ? entryObject.getZ() : entryObject.getAngle()));
            if (entryObject.getType() == GlOperation.GlOperationType.TRANSLATION && i < 3 && listChiseledArmor.guiChiseledArmor.scalePixel()) {
                data /= 0.0625f;
            }
            this.dataFields.add(this.createDataField(listChiseledArmor, 20 + i * 45, i == 3 ? 21 : 35, this.getDataFieldString(data)));
        }
        this.buttonPlus = this.createPlusMinusButton(listChiseledArmor, 184, "+");
        this.buttonMinus = this.createPlusMinusButton(listChiseledArmor, 198, "-");
        switch (entryObject.getType()) {
            case ROTATION: {
                this.textureIcon = TEXTURE_ROTATION;
                break;
            }
            case TRANSLATION: {
                this.textureIcon = TEXTURE_TRANSLATION;
                break;
            }
            case SCALE: {
                this.textureIcon = TEXTURE_SCALE;
            }
        }
        this.index = index;
        scaleFactor = GuiHelper.getScaleFactor();
    }

    public boolean fieldIsFocused() {
        for (GuiTextField field : this.dataFields) {
            if (!field.func_146206_l()) continue;
            return true;
        }
        return false;
    }

    private String getDataFieldString(float data) {
        return "" + (data == (float)((int)data) ? Integer.toString((int)data) : Float.toString(data));
    }

    private GuiButtonExt createPlusMinusButton(GuiListChiseledArmor<GlOperation> listChiseledArmor, int offsetX, String text) {
        return new GuiButtonExt(0, listChiseledArmor.field_148152_e + offsetX, 0, 12, 12, text);
    }

    private GuiTextField createDataField(GuiListChiseledArmor<GlOperation> listChiseledArmor, int offsetX, int width, String text) {
        GuiTextField field = new GuiTextField(6, this.mc.field_71466_p, listChiseledArmor.field_148152_e + offsetX, 0, width, 9);
        field.func_175205_a(this.numberFilter);
        field.func_146185_a(false);
        field.func_146193_g(-1);
        field.func_146180_a(text);
        field.func_146196_d();
        return field;
    }

    public void formatDataFields(int mouseX, int mouseY) {
        for (int i = 0; i < this.dataFields.size(); ++i) {
            GuiTextField field = this.dataFields.get(i);
            this.changeData(field, i, field.func_146179_b(), true);
            if (this.buttonPlus.func_146115_a() || this.buttonMinus.func_146115_a() || mouseX >= field.field_146209_f && mouseX <= field.field_146209_f + field.field_146218_h && mouseY >= field.field_146210_g && mouseY <= field.field_146210_g + field.field_146219_i) continue;
            field.func_146195_b(false);
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        boolean enterPressed = keyCode == 28;
        for (int i = 0; i < this.dataFields.size(); ++i) {
            GuiTextField field = this.dataFields.get(i);
            String textInitial = field.func_146179_b();
            if (!enterPressed && !field.func_146201_a(typedChar, keyCode)) continue;
            if (field.func_146206_l() && keyCode != 203 && keyCode != 205 && !GuiScreen.func_175278_g((int)keyCode) && !GuiScreen.func_175280_f((int)keyCode)) {
                this.changeData(field, i, textInitial, enterPressed);
            }
            if (!enterPressed) continue;
            field.func_146195_b(false);
        }
    }

    private void changeData(GuiTextField field, int index, String textInitial, boolean changeText) {
        float data = 0.0f;
        try {
            data = Float.parseFloat(field.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int pos = field.func_146198_h();
        if (changeText) {
            if (index == 3) {
                data %= 360.0f;
            }
            field.func_146180_a(this.getDataFieldString(data));
        }
        field.func_146190_e(pos);
        if (index == 3) {
            data %= 360.0f;
        }
        if (((GlOperation)this.entryObject).getType() == GlOperation.GlOperationType.TRANSLATION && index < 3 && this.listChiseledArmor.guiChiseledArmor.scalePixel()) {
            data *= 0.0625f;
        }
        switch (index) {
            case 0: {
                ((GlOperation)this.entryObject).setX(data);
                break;
            }
            case 1: {
                ((GlOperation)this.entryObject).setY(data);
                break;
            }
            case 2: {
                ((GlOperation)this.entryObject).setZ(data);
                break;
            }
            case 3: {
                ((GlOperation)this.entryObject).setAngle(data);
            }
        }
        if (!textInitial.equals(field.func_146179_b())) {
            this.listChiseledArmor.guiChiseledArmor.setGlOperationListData(-1, false);
        }
    }

    @Override
    public void updateScreen(boolean isSelected) {
        int y = -MathHelper.func_76125_a((int)this.listChiseledArmor.func_148148_g(), (int)0, (int)this.listChiseledArmor.func_148135_f()) + this.listChiseledArmor.field_148149_f * this.index + this.listChiseledArmor.field_148160_j + this.listChiseledArmor.field_148153_b + 5;
        for (GuiTextField field : this.dataFields) {
            if (isSelected) {
                field.func_146178_a();
            } else {
                field.func_146195_b(false);
            }
            field.field_146210_g = y;
        }
        this.buttonPlus.field_146129_i = this.buttonMinus.field_146129_i = y - 2;
    }

    public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
        this.iconHovered = mouseX > x + 2 && mouseX < x + 16 && mouseY > y + 1 && mouseY < y + 14;
        ClientHelper.bindTexture(this.textureIcon);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiButtonBase.func_73734_a((int)(x + 2), (int)(y + 2), (int)(x + 15), (int)(y + 14), (int)-38400);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        double iconX = x + 2;
        double iconY = y + 2;
        double iconWidth = 13.0;
        double iconHieght = 12.0;
        if (scaleFactor == 3) {
            iconWidth *= 0.6666666865348816;
            iconHieght *= 0.6666666865348816;
            iconX += 2.0;
            iconY += 2.0;
        }
        GuiHelper.drawTexturedRect(iconX, iconY, iconX + iconWidth, iconY + iconHieght);
        GlStateManager.func_179121_F();
        for (GuiTextField field : this.dataFields) {
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)GuiChiseledArmor.TEXTURE_GUI, (int)(field.field_146209_f - 3), (int)(field.field_146210_g - 2), (int)78, (int)115, (int)(field.field_146218_h + 9), (int)(field.field_146219_i + 3), (int)13, (int)12, (int)2, (float)100.0f);
            field.func_146194_f();
        }
        this.buttonPlus.func_146112_a(this.mc, mouseX, mouseY);
        this.buttonMinus.func_146112_a(this.mc, mouseX, mouseY);
    }

    @Override
    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        float inc = 0.0f;
        boolean shiftDown = GuiScreen.func_146272_n();
        if (this.buttonPlus.func_146115_a() || this.buttonMinus.func_146115_a()) {
            float f = inc = this.buttonPlus.func_146115_a() ? 1.0f : -1.0f;
            if (((GlOperation)this.entryObject).getType() == GlOperation.GlOperationType.TRANSLATION) {
                boolean scalePixel = this.listChiseledArmor.guiChiseledArmor.scalePixel();
                if (scalePixel && shiftDown) {
                    inc *= 16.0f;
                }
                if (!scalePixel && !shiftDown) {
                    inc *= 0.0625f;
                }
            }
            inc = this.alterIncrementAmount(inc);
            this.buttonPlus.func_146113_a(this.mc.func_147118_V());
        }
        for (int i = 0; i < this.dataFields.size(); ++i) {
            GuiTextField field = this.dataFields.get(i);
            if (inc == 0.0f) {
                field.func_146192_a(mouseX, mouseY, mouseEvent);
                if (!field.func_146206_l()) continue;
                float data = 0.0f;
                try {
                    data = Float.parseFloat(field.func_146179_b());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (data != 0.0f) break;
                field.func_146180_a("");
                break;
            }
            if (!field.func_146206_l()) continue;
            if (i == 3) {
                float f = inc = this.buttonPlus.func_146115_a() ? 1.0f : -1.0f;
                if (shiftDown) {
                    inc *= 90.0f;
                }
                inc = this.alterIncrementAmount(inc);
            }
            String textInitial = field.func_146179_b();
            try {
                float data = Float.parseFloat(field.func_146179_b()) + inc;
                if (i == 3) {
                    data %= 360.0f;
                }
                field.func_146180_a(this.getDataFieldString(data));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.changeData(field, i, textInitial, true);
            break;
        }
        return super.func_148278_a(slotIndex, mouseX, mouseY, mouseEvent, relativeX, relativeY);
    }

    private float alterIncrementAmount(float inc) {
        if (Minecraft.field_142025_a ? Keyboard.isKeyDown((int)219) : Keyboard.isKeyDown((int)29)) {
            inc *= 0.5f;
        }
        if (Minecraft.field_142025_a ? Keyboard.isKeyDown((int)220) : Keyboard.isKeyDown((int)157)) {
            inc *= 0.1f;
        }
        if (Keyboard.isKeyDown((int)56)) {
            inc *= 0.25f;
        }
        if (Keyboard.isKeyDown((int)184)) {
            inc *= 10.0f;
        }
        if (Keyboard.isKeyDown((int)44)) {
            inc = (float)((double)inc * ((double)Math.round((double)Configs.armorZFightingBufferScale * 100000.0) / 100000.0));
        }
        return inc;
    }

    public boolean isElementHovered(boolean isHelpMode) {
        return this.iconHovered || isHelpMode && (this.buttonPlus.func_146115_a() || this.buttonMinus.func_146115_a());
    }

    public String getElementHoverText(@Nullable String hoverHelpText) {
        if (this.iconHovered) {
            String name = ((GlOperation)this.entryObject).getType().getName();
            return hoverHelpText == null ? name : "GL Operation: " + name + "\n\n" + hoverHelpText;
        }
        return "If one of the fields to the left is focused, pressing these buttons will increase or decrease its contents.\n\nHolding shift affects the base value of the change for the following GL operation fields:\n" + this.getBaseValueText(GlOperation.GlOperationType.ROTATION, "angle value", "1\u00b0", "90\u00b0") + "\n" + this.getBaseValueText(GlOperation.GlOperationType.TRANSLATION, "x/y/z values", "1 pixel", "1 meter") + "\n\nHolding the following buttons multiplies the base value by:\n" + TextFormatting.AQUA + "All fields:" + TextFormatting.RESET + "\n" + GuiChiseledArmor.getPointSub("Left Control-click") + " 0.5\n" + GuiChiseledArmor.getPointSub("Left Alt-click") + " 0.25\n" + GuiChiseledArmor.getPointSub("Right Control-click") + " 0.1\n" + GuiChiseledArmor.getPointSub("Right Alt-click") + " 10\n" + GuiChiseledArmor.getPointSub("Z-click") + " Z-fighting buffer (default = 1/20th pixel)";
    }

    private String getBaseValueText(GlOperation.GlOperationType operationType, String fieldType, String click, String shiftClick) {
        return TextFormatting.AQUA + operationType.getName() + " " + fieldType + ":" + TextFormatting.RESET + "\n" + GuiChiseledArmor.getPointSub("Click") + " " + click + "\n" + GuiChiseledArmor.getPointSub("Shift-click") + " " + shiftClick;
    }
}

