/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.gui.armor;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.jei.JustEnoughItemsPlugin;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import com.phylogeny.extrabitmanipulation.client.gui.button.GuiButtonHelp;
import com.phylogeny.extrabitmanipulation.client.render.RenderState;
import com.phylogeny.extrabitmanipulation.container.ContainerPlayerArmorSlots;
import com.phylogeny.extrabitmanipulation.container.SlotChiseledArmor;
import com.phylogeny.extrabitmanipulation.init.ReflectionExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketOpenInventoryGui;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.reference.JeiReferences;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiInventoryArmorSlots
extends InventoryEffectRenderer
implements GuiHelper.IHoveringTextRenderer {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("ExtraBitManipulation", "textures/guis/inventory_chiseled_armor_slots.png");
    private static final ResourceLocation IMAGE = new ResourceLocation("ExtraBitManipulation", "textures/jei/images/chiseled_helmet.png");
    private static final int[] ICON_STACK_OFFSETS = new int[]{3, 1, 0, -3};
    private float oldMouseX;
    private float oldMouseY;
    private boolean helpMode;
    private GuiButtonHelp buttonHelp;
    private GuiButtonExt buttonJEI;

    public GuiInventoryArmorSlots(ContainerPlayerArmorSlots container) {
        super((Container)container);
        this.field_146291_p = true;
        this.helpMode = false;
    }

    public boolean isInHelpMode() {
        return this.helpMode;
    }

    private void resetGuiLeft() {
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
    }

    public void func_73876_c() {
        this.func_175378_g();
        this.resetGuiLeft();
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.resetGuiLeft();
        this.buttonHelp = new GuiButtonHelp(100, this.field_146292_n, this.field_147003_i + this.field_146999_f - 17, this.field_147009_r + 5, "Show slot/button hover help text", "Exit help mode");
        this.buttonHelp.selected = this.helpMode;
        this.buttonJEI = new GuiButtonExt(100, this.field_147003_i + 119, this.field_147009_r + 55, 46, 26, "");
        this.buttonJEI.field_146125_m = JeiReferences.isJeiLoaded ? this.helpMode : false;
        this.field_146292_n.add(this.buttonHelp);
        this.field_146292_n.add(this.buttonJEI);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 97, 8, 0x404040);
        if (!this.helpMode || !JeiReferences.isJeiLoaded) {
            return;
        }
        int color = this.buttonJEI.func_146115_a() ? 0xFFFFA0 : -1;
        this.field_146289_q.func_78276_b("JEI", 123, 59, color);
        this.field_146289_q.func_78276_b("Info", 122, 69, color);
        ClientHelper.bindTexture(IMAGE);
        int x = 143;
        int y = 58;
        GuiHelper.drawTexturedRect(x, y, (double)x + 18.5, y + 20);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.oldMouseX = mouseX;
        this.oldMouseY = mouseY;
        Slot slot = this.getSlotUnderMouse();
        for (i = 46; i < 50 && this.helpMode; ++i) {
            ((SlotChiseledArmor)this.field_147002_h.func_75139_a(i)).setDisabled(true);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (i = 46; i < 50 && this.helpMode; ++i) {
            ((SlotChiseledArmor)this.field_147002_h.func_75139_a(i)).setDisabled(false);
        }
        GuiHelper.drawHoveringTextForButtons(this, this.field_146292_n, mouseX, mouseY);
        if (this.buttonJEI.func_146115_a()) {
            this.func_146279_a("Get more info on Chiseled Armor", mouseX, mouseY);
        }
        if (slot != null && this.helpMode && slot instanceof SlotChiseledArmor) {
            this.func_146279_a("Only Chiseled Armor with items to render can be put in these slots.\n\nArmor warn here will render in addition to any normally worn armor, but will not confer any additional protection.", mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GuiInventory.func_147046_a((int)(this.field_147003_i + 51), (int)(this.field_147009_r + 75), (int)30, (float)((float)(this.field_147003_i + 51) - this.oldMouseX), (float)((float)(this.field_147009_r + 75 - 50) - this.oldMouseY), (EntityLivingBase)this.field_146297_k.field_71439_g);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-200.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)this.field_146297_k.field_71439_g);
        for (int i = 0; i < ItemChiseledArmor.ArmorType.values().length; ++i) {
            if (cap != null && cap.getStackInSlot(i) != null) continue;
            RenderState.renderStateModelIntoGUI(null, ItemChiseledArmor.ArmorType.values()[i].getIconModel(), null, 0.4f, true, false, this.field_147003_i + 71, this.field_147009_r + 6 + i * 18 + ICON_STACK_OFFSETS[i], 0.0f, 0.0f, 1.0f);
        }
        GlStateManager.func_179121_F();
        if (this.helpMode) {
            for (int i = 0; i < ItemChiseledArmor.ArmorType.values().length; ++i) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(46 + i);
                int x = this.field_147003_i + slot.field_75223_e;
                int y = this.field_147009_r + slot.field_75221_f;
                GuiInventoryArmorSlots.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)1694460416);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (Configs.armorSlotsGuiExitToMainInventory && (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode))) {
            this.openVanillaInventory(this.oldMouseX, this.oldMouseY);
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketOpenInventoryGui(true));
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.buttonJEI) {
            JustEnoughItemsPlugin.openCategory("extrabitmanipulationchiseled_armor");
        } else {
            super.func_146284_a(button);
        }
        this.helpMode = this.buttonHelp.selected;
        if (JeiReferences.isJeiLoaded) {
            this.buttonJEI.field_146125_m = this.helpMode;
        }
    }

    public void openVanillaInventory(float mouseX, float mouseY) {
        EntityPlayer player = ClientHelper.getPlayer();
        player.field_71070_bA.func_75134_a(player);
        GuiInventory gui = new GuiInventory(player);
        this.field_146297_k.func_147108_a((GuiScreen)gui);
        ReflectionExtraBitManipulation.setCursorPosition(gui, mouseX, mouseY);
    }

    @Override
    public void render(String text, int mouseX, int mouseY) {
        this.func_146279_a(text, mouseX, mouseY);
    }
}

