/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ArmorItem {
    private List<GlOperation> glOperations = new ArrayList<GlOperation>();
    private ItemStack stack;

    public ArmorItem() {
    }

    public ArmorItem(ItemStack stack) {
        this.stack = stack;
    }

    public ArmorItem(NBTTagCompound nbt) {
        this.stack = ItemStackHelper.loadStackFromNBT(nbt, "armorItem");
        GlOperation.loadListFromNBT(nbt, "glOperations", this.glOperations);
    }

    public void addGlOperation(GlOperation glOperation) {
        this.glOperations.add(glOperation);
    }

    public void addGlOperation(int index, GlOperation glOperation) {
        this.glOperations.add(index, glOperation);
    }

    public void removeGlOperation(int index) {
        this.glOperations.remove(index);
    }

    public List<GlOperation> getGlOperations() {
        ArrayList<GlOperation> glOperations = new ArrayList<GlOperation>();
        glOperations.addAll(this.glOperations);
        return glOperations;
    }

    public void render(EntityLivingBase entity, float scale, boolean isRightLegOrFoot) {
        float scale2 = 32.0f * scale + Configs.armorZFightingBufferScale;
        if (isRightLegOrFoot) {
            scale2 += Configs.armorZFightingBufferScaleRightLegOrFoot;
        }
        GlStateManager.func_179152_a((float)scale2, (float)scale2, (float)scale2);
        if (ChiselsAndBitsAPIAccess.apiInstance.getItemType(this.stack) != ItemType.CHISLED_BLOCK) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        Minecraft.func_71410_x().func_175597_ag().func_178099_a(entity, this.stack, ItemCameraTransforms.TransformType.NONE);
    }

    public void executeGlOperations() {
        GlOperation.executeList(this.glOperations);
    }

    public boolean isEmpty() {
        return this.stack == null;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        ItemStackHelper.saveStackToNBT(nbt, this.stack, "armorItem");
        GlOperation.saveListToNBT(nbt, "glOperations", this.glOperations);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

